/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.awt.util;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import org.mapsforge.map.awt.graphics.AwtGraphicFactory;
import org.mapsforge.map.layer.cache.FileSystemTileCache;
import org.mapsforge.map.layer.cache.InMemoryTileCache;
import org.mapsforge.map.layer.cache.TileCache;
import org.mapsforge.map.layer.cache.TwoLevelTileCache;

public final class AwtUtil {
    public static TileCache createTileCache(int tileSize, double overdrawFactor, int capacity, File cacheDirectory) {
        int cacheSize = AwtUtil.getMinimumCacheSize(tileSize, overdrawFactor);
        InMemoryTileCache firstLevelTileCache = new InMemoryTileCache(cacheSize);
        FileSystemTileCache secondLevelTileCache = new FileSystemTileCache(capacity, cacheDirectory, AwtGraphicFactory.INSTANCE);
        return new TwoLevelTileCache((TileCache)firstLevelTileCache, (TileCache)secondLevelTileCache);
    }

    public static int getMinimumCacheSize(int tileSize, double overdrawFactor) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return (int)Math.max(4L, Math.round((2.0 + screenSize.getWidth() * overdrawFactor / (double)tileSize) * (2.0 + screenSize.getHeight() * overdrawFactor / (double)tileSize)));
    }

    private AwtUtil() {
    }
}

