/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.awt.view;

import java.awt.Container;
import java.awt.Graphics;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.mapsforge.core.graphics.GraphicContext;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.Dimension;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.MapPosition;
import org.mapsforge.map.awt.graphics.AwtGraphicFactory;
import org.mapsforge.map.awt.input.MapViewComponentListener;
import org.mapsforge.map.awt.input.MouseEventListener;
import org.mapsforge.map.controller.FrameBufferController;
import org.mapsforge.map.controller.LayerManagerController;
import org.mapsforge.map.controller.MapViewController;
import org.mapsforge.map.layer.Layer;
import org.mapsforge.map.layer.LayerManager;
import org.mapsforge.map.layer.TileLayer;
import org.mapsforge.map.layer.labels.LabelStore;
import org.mapsforge.map.layer.renderer.TileRendererLayer;
import org.mapsforge.map.model.Model;
import org.mapsforge.map.scalebar.DefaultMapScaleBar;
import org.mapsforge.map.scalebar.MapScaleBar;
import org.mapsforge.map.util.MapPositionUtil;
import org.mapsforge.map.util.MapViewProjection;
import org.mapsforge.map.view.FpsCounter;
import org.mapsforge.map.view.FrameBuffer;
import org.mapsforge.map.view.FrameBufferHA2;
import org.mapsforge.map.view.InputListener;

public class MapView
extends Container
implements org.mapsforge.map.view.MapView {
    private static final GraphicFactory GRAPHIC_FACTORY = AwtGraphicFactory.INSTANCE;
    private static final long serialVersionUID = 1L;
    private final FpsCounter fpsCounter;
    private final FrameBuffer frameBuffer;
    private final FrameBufferController frameBufferController;
    private final List<InputListener> inputListeners = new CopyOnWriteArrayList<InputListener>();
    private final LayerManager layerManager;
    private MapScaleBar mapScaleBar;
    private final MapViewProjection mapViewProjection;
    private final Model model = new Model();

    public MapView() {
        this.fpsCounter = new FpsCounter(GRAPHIC_FACTORY, this.model.displayModel);
        this.frameBuffer = new FrameBufferHA2(this.model.frameBufferModel, this.model.displayModel, GRAPHIC_FACTORY);
        this.frameBufferController = FrameBufferController.create((FrameBuffer)this.frameBuffer, (Model)this.model);
        this.layerManager = new LayerManager((org.mapsforge.map.view.MapView)this, this.model.mapViewPosition, GRAPHIC_FACTORY);
        this.layerManager.start();
        LayerManagerController.create((LayerManager)this.layerManager, (Model)this.model);
        MapViewController.create((org.mapsforge.map.view.MapView)this, (Model)this.model);
        this.mapScaleBar = new DefaultMapScaleBar(this.model.mapViewPosition, this.model.mapViewDimension, GRAPHIC_FACTORY, this.model.displayModel);
        this.mapViewProjection = new MapViewProjection((org.mapsforge.map.view.MapView)this);
        this.addListeners();
    }

    public void addInputListener(InputListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.inputListeners.contains(listener)) {
            throw new IllegalArgumentException("listener is already registered: " + listener);
        }
        this.inputListeners.add(listener);
    }

    public void addLayer(Layer layer) {
        this.layerManager.getLayers().add(layer);
    }

    public void addListeners() {
        this.addComponentListener(new MapViewComponentListener(this));
        MouseEventListener mouseEventListener = new MouseEventListener(this);
        this.addMouseListener(mouseEventListener);
        this.addMouseMotionListener(mouseEventListener);
        this.addMouseWheelListener(mouseEventListener);
    }

    public void destroy() {
        this.layerManager.finish();
        this.frameBufferController.destroy();
        this.frameBuffer.destroy();
        if (this.mapScaleBar != null) {
            this.mapScaleBar.destroy();
        }
        this.getModel().mapViewPosition.destroy();
    }

    public void destroyAll() {
        for (Layer layer : this.layerManager.getLayers()) {
            LabelStore labelStore;
            this.layerManager.getLayers().remove(layer);
            layer.onDestroy();
            if (layer instanceof TileLayer) {
                ((TileLayer)layer).getTileCache().destroy();
            }
            if (!(layer instanceof TileRendererLayer) || (labelStore = ((TileRendererLayer)layer).getLabelStore()) == null) continue;
            labelStore.clear();
        }
        this.destroy();
    }

    public BoundingBox getBoundingBox() {
        return MapPositionUtil.getBoundingBox((MapPosition)this.model.mapViewPosition.getMapPosition(), (Dimension)this.getDimension(), (int)this.model.displayModel.getTileSize());
    }

    public Dimension getDimension() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public FpsCounter getFpsCounter() {
        return this.fpsCounter;
    }

    public FrameBuffer getFrameBuffer() {
        return this.frameBuffer;
    }

    public LayerManager getLayerManager() {
        return this.layerManager;
    }

    public MapScaleBar getMapScaleBar() {
        return this.mapScaleBar;
    }

    public MapViewProjection getMapViewProjection() {
        return this.mapViewProjection;
    }

    public Model getModel() {
        return this.model;
    }

    public void onMoveEvent() {
        for (InputListener listener : this.inputListeners) {
            listener.onMoveEvent();
        }
    }

    public void onZoomEvent() {
        for (InputListener listener : this.inputListeners) {
            listener.onZoomEvent();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        GraphicContext graphicContext = AwtGraphicFactory.createGraphicContext(graphics);
        this.frameBuffer.draw(graphicContext);
        if (this.mapScaleBar != null) {
            this.mapScaleBar.draw(graphicContext);
        }
        this.fpsCounter.draw(graphicContext);
    }

    public void removeInputListener(InputListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (!this.inputListeners.contains(listener)) {
            throw new IllegalArgumentException("listener is not registered: " + listener);
        }
        this.inputListeners.remove(listener);
    }

    public void setCenter(LatLong center) {
        this.model.mapViewPosition.setCenter(center);
    }

    public void setMapScaleBar(MapScaleBar mapScaleBar) {
        if (this.mapScaleBar != null) {
            this.mapScaleBar.destroy();
        }
        this.mapScaleBar = mapScaleBar;
    }

    public void setZoomLevel(byte zoomLevel) {
        this.model.mapViewPosition.setZoomLevel(zoomLevel);
    }

    public void setZoomLevelMax(byte zoomLevelMax) {
        this.model.mapViewPosition.setZoomLevelMax(zoomLevelMax);
    }

    public void setZoomLevelMin(byte zoomLevelMin) {
        this.model.mapViewPosition.setZoomLevelMin(zoomLevelMin);
    }
}

