/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.awt.graphics;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.mapsforge.core.graphics.Bitmap;

public class AwtBitmap
implements Bitmap {
    BufferedImage bufferedImage;

    public AwtBitmap(InputStream inputStream) throws IOException {
        this.bufferedImage = ImageIO.read(inputStream);
        if (this.bufferedImage == null) {
            throw new IOException("ImageIO filed to read inputStream");
        }
    }

    public AwtBitmap(int width, int height) {
        this(width, height, true);
    }

    public AwtBitmap(int width, int height, boolean hasAlpha) {
        this(new BufferedImage(width, height, hasAlpha ? 2 : 1));
    }

    public AwtBitmap(BufferedImage bufferedImage) {
        this.bufferedImage = bufferedImage;
    }

    public void compress(OutputStream outputStream) throws IOException {
        ImageIO.write((RenderedImage)this.bufferedImage, "png", outputStream);
    }

    public void decrementRefCount() {
    }

    public int getHeight() {
        return this.bufferedImage.getHeight();
    }

    public int getWidth() {
        return this.bufferedImage.getWidth();
    }

    public void incrementRefCount() {
    }

    public boolean isDestroyed() {
        return this.bufferedImage == null;
    }

    public void scaleTo(int width, int height) {
        if (this.getWidth() != width || this.getHeight() != height) {
            BufferedImage resizedImage = new BufferedImage(width, height, 2);
            Graphics2D graphics = resizedImage.createGraphics();
            graphics.setComposite(AlphaComposite.Src);
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.drawImage(this.bufferedImage, 0, 0, width, height, null);
            graphics.dispose();
            this.bufferedImage = resizedImage;
        }
    }

    public void setBackgroundColor(int color) {
        Graphics2D graphics = this.bufferedImage.createGraphics();
        graphics.setColor(new Color(color, true));
        graphics.fillRect(0, 0, this.bufferedImage.getWidth(), this.bufferedImage.getHeight());
        graphics.dispose();
    }
}

