/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.awt.graphics;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.util.AbstractMap;
import java.util.Map;
import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.Matrix;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.graphics.Path;
import org.mapsforge.core.graphics.Style;
import org.mapsforge.core.model.Dimension;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Rectangle;
import org.mapsforge.core.model.Rotation;
import org.mapsforge.core.util.Parameters;
import org.mapsforge.map.awt.graphics.AwtGraphicFactory;
import org.mapsforge.map.awt.graphics.AwtPaint;
import org.mapsforge.map.awt.graphics.AwtPath;
import org.mapsforge.map.awt.graphics.TextStroke;

class AwtCanvas
implements Canvas {
    private static final String UNKNOWN_STYLE = "unknown style: ";
    private BufferedImage bufferedImage;
    private Graphics2D graphics2D;
    private static final Color NEUTRAL_HILLS = AwtGraphicFactory.getColor(org.mapsforge.core.graphics.Color.TRANSPARENT);
    private static Map.Entry<Float, Composite> sizeOneShadingCompositeCache = null;
    private final AffineTransform transform = new AffineTransform();

    private static Composite getHillshadingComposite(float magnitude, boolean external) {
        Map.Entry<Float, Composite> existing = sizeOneShadingCompositeCache;
        if (existing != null && existing.getKey().floatValue() == magnitude) {
            return existing.getValue();
        }
        AlphaComposite selected = AlphaComposite.getInstance(external ? 3 : 10, magnitude);
        if (sizeOneShadingCompositeCache == null) {
            sizeOneShadingCompositeCache = new AbstractMap.SimpleImmutableEntry<Float, AlphaComposite>(Float.valueOf(magnitude), selected);
        }
        return selected;
    }

    AwtCanvas() {
    }

    AwtCanvas(Graphics2D graphics2D) {
        this.graphics2D = graphics2D;
        this.setAntiAlias(Parameters.ANTI_ALIASING);
    }

    public void destroy() {
    }

    public void drawBitmap(Bitmap bitmap, int left, int top) {
        BufferedImage awtBitmap = AwtGraphicFactory.getBitmap(bitmap);
        if (awtBitmap.getColorModel() instanceof IndexColorModel) {
            this.fillColor(org.mapsforge.core.graphics.Color.TRANSPARENT);
        }
        this.graphics2D.drawImage((Image)awtBitmap, left, top, null);
    }

    public void drawBitmap(Bitmap bitmap, int left, int top, float alpha) {
        Composite composite = this.graphics2D.getComposite();
        if (alpha != 1.0f) {
            this.graphics2D.setComposite(AlphaComposite.getInstance(3, alpha));
        }
        this.graphics2D.drawImage((Image)AwtGraphicFactory.getBitmap(bitmap), left, top, null);
        if (alpha != 1.0f) {
            this.graphics2D.setComposite(composite);
        }
    }

    public void drawBitmap(Bitmap bitmap, Matrix matrix) {
        this.graphics2D.drawRenderedImage(AwtGraphicFactory.getBitmap(bitmap), AwtGraphicFactory.getAffineTransform(matrix));
    }

    public void drawBitmap(Bitmap bitmap, Matrix matrix, float alpha) {
        Composite composite = this.graphics2D.getComposite();
        if (alpha != 1.0f) {
            this.graphics2D.setComposite(AlphaComposite.getInstance(3, alpha));
        }
        this.graphics2D.drawRenderedImage(AwtGraphicFactory.getBitmap(bitmap), AwtGraphicFactory.getAffineTransform(matrix));
        if (alpha != 1.0f) {
            this.graphics2D.setComposite(composite);
        }
    }

    public void drawBitmap(Bitmap bitmap, int srcLeft, int srcTop, int srcRight, int srcBottom, int dstLeft, int dstTop, int dstRight, int dstBottom) {
        this.graphics2D.drawImage(AwtGraphicFactory.getBitmap(bitmap), dstLeft, dstTop, dstRight, dstBottom, srcLeft, srcTop, srcRight, srcBottom, null);
    }

    public void drawBitmap(Bitmap bitmap, int srcLeft, int srcTop, int srcRight, int srcBottom, int dstLeft, int dstTop, int dstRight, int dstBottom, float alpha) {
        Composite composite = this.graphics2D.getComposite();
        if (alpha != 1.0f) {
            this.graphics2D.setComposite(AlphaComposite.getInstance(3, alpha));
        }
        this.graphics2D.drawImage(AwtGraphicFactory.getBitmap(bitmap), dstLeft, dstTop, dstRight, dstBottom, srcLeft, srcTop, srcRight, srcBottom, null);
        if (alpha != 1.0f) {
            this.graphics2D.setComposite(composite);
        }
    }

    public void drawCircle(int x, int y, int radius, Paint paint) {
        if (paint.isTransparent()) {
            return;
        }
        AwtPaint awtPaint = AwtGraphicFactory.getPaint(paint);
        this.setColorAndStroke(awtPaint);
        int doubleRadius = radius * 2;
        Style style = awtPaint.style;
        switch (style) {
            case FILL: {
                this.graphics2D.fillOval(x - radius, y - radius, doubleRadius, doubleRadius);
                return;
            }
            case STROKE: {
                this.graphics2D.drawOval(x - radius, y - radius, doubleRadius, doubleRadius);
                return;
            }
        }
        throw new IllegalArgumentException(UNKNOWN_STYLE + style);
    }

    public void drawLine(int x1, int y1, int x2, int y2, Paint paint) {
        if (paint.isTransparent()) {
            return;
        }
        this.setColorAndStroke(AwtGraphicFactory.getPaint(paint));
        this.graphics2D.drawLine(x1, y1, x2, y2);
    }

    public void drawPath(Path path, Paint paint) {
        if (paint.isTransparent()) {
            return;
        }
        AwtPaint awtPaint = AwtGraphicFactory.getPaint(paint);
        AwtPath awtPath = AwtGraphicFactory.getPath(path);
        this.setColorAndStroke(awtPaint);
        this.graphics2D.setPaint(awtPaint.texturePaint);
        Style style = awtPaint.style;
        switch (style) {
            case FILL: {
                this.graphics2D.fill(awtPath.path2D);
                return;
            }
            case STROKE: {
                this.graphics2D.draw(awtPath.path2D);
                return;
            }
        }
        throw new IllegalArgumentException(UNKNOWN_STYLE + style);
    }

    public void drawLines(Point[][] coordinates, float dy, Paint paint) {
    }

    public void drawPathText(String text, Path path, Paint paint) {
        if (text == null || text.trim().isEmpty()) {
            return;
        }
        if (paint.isTransparent()) {
            return;
        }
        AwtPaint awtPaint = AwtGraphicFactory.getPaint(paint);
        AwtPath awtPath = AwtGraphicFactory.getPath(path);
        if (awtPaint.stroke == null) {
            this.graphics2D.setColor(awtPaint.color);
            this.graphics2D.setFont(awtPaint.font);
        } else {
            this.setColorAndStroke(awtPaint);
        }
        TextStroke textStroke = new TextStroke(text, awtPaint.font, this.graphics2D.getFontRenderContext(), false, false);
        Style style = awtPaint.style;
        switch (style) {
            case FILL: {
                this.graphics2D.fill(textStroke.createStrokedShape(awtPath.path2D));
                return;
            }
            case STROKE: {
                this.graphics2D.draw(textStroke.createStrokedShape(awtPath.path2D));
                return;
            }
        }
        throw new IllegalArgumentException(UNKNOWN_STYLE + style);
    }

    public void drawText(String text, int x, int y, Paint paint) {
        if (text == null || text.trim().isEmpty()) {
            return;
        }
        if (paint.isTransparent()) {
            return;
        }
        AwtPaint awtPaint = AwtGraphicFactory.getPaint(paint);
        if (awtPaint.stroke == null) {
            this.graphics2D.setColor(awtPaint.color);
            this.graphics2D.setFont(awtPaint.font);
            this.graphics2D.drawString(text, x, y);
        } else {
            this.setColorAndStroke(awtPaint);
            TextLayout textLayout = new TextLayout(text, awtPaint.font, this.graphics2D.getFontRenderContext());
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(x, y);
            this.graphics2D.draw(textLayout.getOutline(affineTransform));
        }
    }

    public void drawTextRotated(String text, int x1, int y1, int x2, int y2, Paint paint) {
        if (text == null || text.trim().isEmpty()) {
            return;
        }
        if (paint.isTransparent()) {
            return;
        }
        AffineTransform affineTransform = this.graphics2D.getTransform();
        double theta = Math.atan2(y2 - y1, x2 - x1);
        this.graphics2D.rotate(theta, x1, y1);
        double lineLength = Math.hypot(x2 - x1, y2 - y1);
        int textWidth = paint.getTextWidth(text);
        int dx = (int)(lineLength - (double)textWidth) / 2;
        int xy = paint.getTextHeight(text) / 3;
        this.drawText(text, x1 + dx, y1 + xy, paint);
        this.graphics2D.setTransform(affineTransform);
    }

    public void fillColor(org.mapsforge.core.graphics.Color color) {
        this.fillColor(AwtGraphicFactory.getColor(color));
    }

    public void fillColor(int color) {
        this.fillColor(new Color(color, true));
    }

    public Dimension getDimension() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    Graphics2D getGraphicObject() {
        return this.graphics2D;
    }

    public int getHeight() {
        return this.bufferedImage != null ? this.bufferedImage.getHeight() : 0;
    }

    public int getWidth() {
        return this.bufferedImage != null ? this.bufferedImage.getWidth() : 0;
    }

    public boolean isAntiAlias() {
        return this.graphics2D.getRenderingHints().containsValue(RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public boolean isFilterBitmap() {
        return this.graphics2D.getRenderingHints().containsValue(RenderingHints.VALUE_INTERPOLATION_BICUBIC) || this.graphics2D.getRenderingHints().containsValue(RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    }

    public void resetClip() {
        this.graphics2D.setClip(null);
    }

    public void restore() {
    }

    public void rotate(float degrees, float px, float py) {
        if (degrees != 0.0f) {
            this.graphics2D.rotate(degrees, px, py);
        }
    }

    public void rotate(Rotation rotation) {
        if (!Rotation.noRotation((Rotation)rotation)) {
            this.rotate(rotation.degrees, rotation.px, rotation.py);
        }
    }

    public void save() {
    }

    public void setAntiAlias(boolean aa) {
        this.graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aa ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        this.graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, aa ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, aa ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
    }

    public void setBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            this.bufferedImage = null;
            this.graphics2D = null;
        } else {
            this.bufferedImage = AwtGraphicFactory.getBitmap(bitmap);
            this.graphics2D = this.bufferedImage.createGraphics();
            this.setAntiAlias(Parameters.ANTI_ALIASING);
            this.graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            this.graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        }
    }

    public void setBitmap(Bitmap bitmap, float dx, float dy, float degrees, float px, float py) {
        this.translate(dx, dy);
        this.rotate(degrees, px, py);
        this.setBitmap(bitmap);
    }

    public void setClip(int left, int top, int width, int height) {
        this.setClip(left, top, width, height, false);
    }

    public void setClip(int left, int top, int width, int height, boolean intersect) {
        this.graphics2D.setClip(left, top, width, height);
    }

    public void setClipDifference(float left, float top, float width, float height) {
        Area clip = new Area(new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()));
        clip.subtract(new Area(new Rectangle2D.Double(left, top, width, height)));
        this.graphics2D.setClip(clip);
    }

    public void setFilterBitmap(boolean filter) {
        this.graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, filter ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
    }

    public void shadeBitmap(Bitmap bitmap, Rectangle shadeRect, Rectangle tileRect, float magnitude, int color, boolean external) {
        Composite oldComposite = this.graphics2D.getComposite();
        Composite composite = AwtCanvas.getHillshadingComposite(magnitude, external);
        this.graphics2D.setComposite(composite);
        if (bitmap == null) {
            if (tileRect != null) {
                this.graphics2D.setClip((int)Math.round(tileRect.left), (int)Math.round(tileRect.top), (int)Math.round(tileRect.right - (double)((int)tileRect.left)), (int)Math.round(tileRect.bottom) - (int)Math.round(tileRect.top));
            }
            this.graphics2D.setColor(NEUTRAL_HILLS);
            this.graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.graphics2D.setComposite(oldComposite);
            this.graphics2D.setClip(null);
            return;
        }
        if (shadeRect.getWidth() != 0.0 && shadeRect.getHeight() != 0.0) {
            double horizontalScale = tileRect.getWidth() / shadeRect.getWidth();
            double verticalScale = tileRect.getHeight() / shadeRect.getHeight();
            int srcLeft = Math.max(0, (int)shadeRect.left - 1);
            int srcTop = Math.max(0, (int)shadeRect.top - 1);
            int srcWidth = Math.min(bitmap.getWidth() - srcLeft, (int)shadeRect.getWidth() + 4);
            int srcHeight = Math.min(bitmap.getHeight() - srcTop, (int)shadeRect.getHeight() + 4);
            BufferedImage subImage = AwtGraphicFactory.getBitmap(bitmap).getSubimage(srcLeft, srcTop, srcWidth, srcHeight);
            this.transform.setToIdentity();
            this.transform.translate(tileRect.left, tileRect.top);
            this.transform.scale(horizontalScale, verticalScale);
            this.transform.translate(-(shadeRect.left - (double)srcLeft), -(shadeRect.top - (double)srcTop));
            this.graphics2D.setClip((int)Math.round(tileRect.left), (int)Math.round(tileRect.top), (int)Math.round(tileRect.right) - (int)Math.round(tileRect.left), (int)Math.round(tileRect.bottom) - (int)Math.round(tileRect.top));
            this.graphics2D.drawRenderedImage(subImage, this.transform);
            this.graphics2D.setClip(null);
        }
        this.graphics2D.setComposite(oldComposite);
    }

    public void translate(float dx, float dy) {
        this.graphics2D.translate(dx, dy);
    }

    private void fillColor(Color color) {
        Composite originalComposite = this.graphics2D.getComposite();
        this.graphics2D.setComposite(AlphaComposite.getInstance(color.getAlpha() == 0 ? 1 : 3));
        this.graphics2D.setColor(color);
        this.graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.graphics2D.setComposite(originalComposite);
    }

    void setColorAndStroke(AwtPaint awtPaint) {
        this.graphics2D.setColor(awtPaint.color);
        if (awtPaint.stroke != null) {
            this.graphics2D.setStroke(awtPaint.stroke);
        }
    }
}

