/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.awt.graphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import org.mapsforge.core.graphics.Align;
import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.Cap;
import org.mapsforge.core.graphics.FontFamily;
import org.mapsforge.core.graphics.FontStyle;
import org.mapsforge.core.graphics.Join;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.graphics.Style;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Rectangle;
import org.mapsforge.map.awt.graphics.AwtGraphicFactory;

public class AwtPaint
implements Paint {
    private static final Map<AttributedCharacterIterator.Attribute, Object> TEXT_ATTRIBUTES = new HashMap<AttributedCharacterIterator.Attribute, Object>();
    Color color;
    Font font;
    Stroke stroke;
    Style style;
    TexturePaint texturePaint;
    private int cap;
    private String fontName;
    private int fontStyle;
    private int join;
    private float[] strokeDasharray;
    private float strokeWidth;
    private float textSize;
    private int shaderWidth;
    private int shaderHeight;
    private final BufferedImage bufferedImage = new BufferedImage(1, 1, 2);

    private static int getCap(Cap cap) {
        switch (cap) {
            case BUTT: {
                return 0;
            }
            case ROUND: {
                return 1;
            }
            case SQUARE: {
                return 2;
            }
        }
        throw new IllegalArgumentException("unknown cap: " + cap);
    }

    private static String getFontName(FontFamily fontFamily) {
        switch (fontFamily) {
            case MONOSPACE: {
                return "Monospaced";
            }
            case DEFAULT: {
                return null;
            }
            case SANS_SERIF: {
                return "SansSerif";
            }
            case SERIF: {
                return "Serif";
            }
        }
        throw new IllegalArgumentException("unknown fontFamily: " + fontFamily);
    }

    private static int getFontStyle(FontStyle fontStyle) {
        switch (fontStyle) {
            case BOLD: {
                return 1;
            }
            case BOLD_ITALIC: {
                return 3;
            }
            case ITALIC: {
                return 2;
            }
            case NORMAL: {
                return 0;
            }
        }
        throw new IllegalArgumentException("unknown fontStyle: " + fontStyle);
    }

    private static int getJoin(Join join) {
        switch (join) {
            case ROUND: {
                return 1;
            }
            case BEVEL: {
                return 2;
            }
            case MITER: {
                return 0;
            }
        }
        throw new IllegalArgumentException("unknown cap: " + join);
    }

    public static int getFontPadding(int fontHeight) {
        return (int)Math.max(1.0, 0.2 * (double)fontHeight);
    }

    AwtPaint() {
        this.cap = AwtPaint.getCap(Cap.ROUND);
        this.color = Color.BLACK;
        this.style = Style.FILL;
        this.join = AwtPaint.getJoin(Join.ROUND);
    }

    AwtPaint(Paint paint) {
        AwtPaint ap = (AwtPaint)paint;
        this.cap = ap.cap;
        this.color = ap.color;
        this.style = ap.style;
        this.join = ap.join;
        this.stroke = ap.stroke;
        this.fontStyle = ap.fontStyle;
        this.font = ap.font;
        this.fontName = ap.fontName;
        this.strokeWidth = ap.strokeWidth;
        this.textSize = ap.textSize;
        this.strokeDasharray = ap.strokeDasharray;
    }

    public int getColor() {
        return this.color.getRGB();
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public Rectangle getTextBounds(String text) {
        Graphics2D graphics2d = this.bufferedImage.createGraphics();
        FontMetrics fontMetrics = graphics2d.getFontMetrics(this.font);
        graphics2d.dispose();
        java.awt.Rectangle bounds = this.font.createGlyphVector(fontMetrics.getFontRenderContext(), text).getVisualBounds().getBounds();
        return new Rectangle((double)bounds.x, (double)bounds.y, (double)(bounds.x + bounds.width), (double)(bounds.y + bounds.height));
    }

    public int getTextHeight(String text) {
        Graphics2D graphics2d = this.bufferedImage.createGraphics();
        FontMetrics fontMetrics = graphics2d.getFontMetrics(this.font);
        graphics2d.dispose();
        return (int)this.font.createGlyphVector(fontMetrics.getFontRenderContext(), text).getVisualBounds().getHeight();
    }

    public int getTextWidth(String text) {
        Graphics2D graphics2d = this.bufferedImage.createGraphics();
        FontMetrics fontMetrics = graphics2d.getFontMetrics(this.font);
        graphics2d.dispose();
        return fontMetrics.stringWidth(text);
    }

    public boolean isTransparent() {
        return this.texturePaint == null && this.color.getAlpha() == 0;
    }

    public boolean isComplexStyle() {
        return true;
    }

    public void setBitmapShader(Bitmap bitmap) {
        if (bitmap == null) {
            return;
        }
        this.shaderWidth = bitmap.getWidth();
        this.shaderHeight = bitmap.getHeight();
        java.awt.Rectangle rectangle = new java.awt.Rectangle(0, 0, bitmap.getWidth(), bitmap.getHeight());
        this.texturePaint = new TexturePaint(AwtGraphicFactory.getBitmap(bitmap), rectangle);
    }

    public void setBitmapShaderShift(Point origin) {
        if (this.texturePaint != null) {
            int relativeDx = (int)(-origin.x) % this.shaderWidth;
            int relativeDy = (int)(-origin.y) % this.shaderHeight;
            java.awt.Rectangle rectangle = new java.awt.Rectangle(relativeDx, relativeDy, this.shaderWidth, this.shaderHeight);
            this.texturePaint = new TexturePaint(this.texturePaint.getImage(), rectangle);
        }
    }

    public void setColor(org.mapsforge.core.graphics.Color color) {
        this.color = AwtGraphicFactory.getColor(color);
    }

    public void setColor(int color) {
        this.color = new Color(color, true);
    }

    public void setDashPathEffect(float[] strokeDasharray) {
        this.strokeDasharray = strokeDasharray;
        this.createStroke();
    }

    public void setStrokeCap(Cap cap) {
        this.cap = AwtPaint.getCap(cap);
        this.createStroke();
    }

    public void setStrokeJoin(Join join) {
        this.join = AwtPaint.getJoin(join);
        this.createStroke();
    }

    public void setStrokeWidth(float strokeWidth) {
        this.strokeWidth = strokeWidth;
        this.createStroke();
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public void setTextAlign(Align align) {
    }

    public void setTextSize(float textSize) {
        this.textSize = textSize;
        this.createFont();
    }

    public void setTypeface(FontFamily fontFamily, FontStyle fontStyle) {
        this.fontName = AwtPaint.getFontName(fontFamily);
        this.fontStyle = AwtPaint.getFontStyle(fontStyle);
        this.createFont();
    }

    private void createFont() {
        this.font = this.textSize > 0.0f ? new Font(this.fontName, this.fontStyle, (int)this.textSize).deriveFont(TEXT_ATTRIBUTES) : null;
    }

    private void createStroke() {
        if (this.strokeWidth <= 0.0f) {
            return;
        }
        this.stroke = new BasicStroke(this.strokeWidth, this.cap, this.join, this.join == 0 ? 1.0f : 0.0f, this.strokeDasharray, 0.0f);
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    static {
        TEXT_ATTRIBUTES.put(TextAttribute.KERNING, TextAttribute.KERNING_ON);
    }
}

