/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.awt.util;

import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.io.File;
import org.mapsforge.map.awt.graphics.AwtGraphicFactory;
import org.mapsforge.map.layer.cache.FileSystemTileCache;
import org.mapsforge.map.layer.cache.InMemoryTileCache;
import org.mapsforge.map.layer.cache.TileCache;
import org.mapsforge.map.layer.cache.TwoLevelTileCache;

public final class AwtUtil {
    public static TileCache createTileCache(int tileSize, double overdrawFactor, int capacity, File cacheDirectory) {
        int cacheSize = AwtUtil.getMinimumCacheSize(tileSize, overdrawFactor);
        InMemoryTileCache firstLevelTileCache = new InMemoryTileCache(cacheSize);
        FileSystemTileCache secondLevelTileCache = new FileSystemTileCache(capacity, cacheDirectory, AwtGraphicFactory.INSTANCE);
        return new TwoLevelTileCache((TileCache)firstLevelTileCache, (TileCache)secondLevelTileCache);
    }

    public static int getMinimumCacheSize(int tileSize, double overdrawFactor) {
        GraphicsDevice[] screenDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        int size = 4;
        for (GraphicsDevice screenDevice : screenDevices) {
            DisplayMode displayMode = screenDevice.getDisplayMode();
            size = Math.max(size, (int)Math.round((2.0 + (double)displayMode.getWidth() * overdrawFactor / (double)tileSize) * (2.0 + (double)displayMode.getHeight() * overdrawFactor / (double)tileSize)));
        }
        return size;
    }

    private AwtUtil() {
    }
}

