/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import org.mapsforge.core.util.LRUCache;
import org.mapsforge.map.reader.Deserializer;
import org.mapsforge.map.reader.IndexCacheEntryKey;
import org.mapsforge.map.reader.header.SubFileParameter;

class IndexCache {
    private static final int INDEX_ENTRIES_PER_BLOCK = 128;
    private static final int SIZE_OF_INDEX_BLOCK = 640;
    private final Map<IndexCacheEntryKey, byte[]> map;
    private final FileChannel fileChannel;

    IndexCache(FileChannel inputChannel, int capacity) {
        this.fileChannel = inputChannel;
        this.map = new LRUCache(capacity);
    }

    void destroy() {
        this.map.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getIndexEntry(SubFileParameter subFileParameter, long blockNumber) throws IOException {
        if (blockNumber >= subFileParameter.numberOfBlocks) {
            throw new IOException("invalid block number: " + blockNumber);
        }
        long indexBlockNumber = blockNumber / 128L;
        IndexCacheEntryKey indexCacheEntryKey = new IndexCacheEntryKey(subFileParameter, indexBlockNumber);
        byte[] indexBlock = this.map.get(indexCacheEntryKey);
        if (indexBlock == null) {
            long indexBlockPosition = subFileParameter.indexStartAddress + indexBlockNumber * 640L;
            int remainingIndexSize = (int)(subFileParameter.indexEndAddress - indexBlockPosition);
            int indexBlockSize = Math.min(640, remainingIndexSize);
            indexBlock = new byte[indexBlockSize];
            ByteBuffer indexBlockWrapper = ByteBuffer.wrap(indexBlock, 0, indexBlockSize);
            FileChannel fileChannel = this.fileChannel;
            synchronized (fileChannel) {
                this.fileChannel.position(indexBlockPosition);
                if (this.fileChannel.read(indexBlockWrapper) != indexBlockSize) {
                    throw new IOException("could not read index block with size: " + indexBlockSize);
                }
            }
            this.map.put(indexCacheEntryKey, indexBlock);
        }
        long indexEntryInBlock = blockNumber % 128L;
        int addressInIndexBlock = (int)(indexEntryInBlock * 5L);
        return Deserializer.getFiveBytesLong(indexBlock, addressInIndexBlock);
    }
}

