/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.reader;

import org.mapsforge.core.model.Tile;
import org.mapsforge.map.reader.QueryCalculations;
import org.mapsforge.map.reader.header.SubFileParameter;

class QueryParameters {
    long fromBaseTileX;
    long fromBaseTileY;
    long fromBlockX;
    long fromBlockY;
    int queryTileBitmask;
    int queryZoomLevel;
    long toBaseTileX;
    long toBaseTileY;
    long toBlockX;
    long toBlockY;
    boolean useTileBitmask;

    QueryParameters() {
    }

    public void calculateBaseTiles(Tile tile, SubFileParameter subFileParameter) {
        if (tile.zoomLevel < subFileParameter.baseZoomLevel) {
            int zoomLevelDifference = subFileParameter.baseZoomLevel - tile.zoomLevel;
            this.fromBaseTileX = tile.tileX << zoomLevelDifference;
            this.fromBaseTileY = tile.tileY << zoomLevelDifference;
            this.toBaseTileX = this.fromBaseTileX + (long)(1 << zoomLevelDifference) - 1L;
            this.toBaseTileY = this.fromBaseTileY + (long)(1 << zoomLevelDifference) - 1L;
            this.useTileBitmask = false;
        } else if (tile.zoomLevel > subFileParameter.baseZoomLevel) {
            int zoomLevelDifference = tile.zoomLevel - subFileParameter.baseZoomLevel;
            this.fromBaseTileX = tile.tileX >>> zoomLevelDifference;
            this.fromBaseTileY = tile.tileY >>> zoomLevelDifference;
            this.toBaseTileX = this.fromBaseTileX;
            this.toBaseTileY = this.fromBaseTileY;
            this.useTileBitmask = true;
            this.queryTileBitmask = QueryCalculations.calculateTileBitmask(tile, zoomLevelDifference);
        } else {
            this.fromBaseTileX = tile.tileX;
            this.fromBaseTileY = tile.tileY;
            this.toBaseTileX = this.fromBaseTileX;
            this.toBaseTileY = this.fromBaseTileY;
            this.useTileBitmask = false;
        }
    }

    public void calculateBaseTiles(Tile upperLeft, Tile lowerRight, SubFileParameter subFileParameter) {
        if (upperLeft.zoomLevel < subFileParameter.baseZoomLevel) {
            int zoomLevelDifference = subFileParameter.baseZoomLevel - upperLeft.zoomLevel;
            this.fromBaseTileX = upperLeft.tileX << zoomLevelDifference;
            this.fromBaseTileY = upperLeft.tileY << zoomLevelDifference;
            this.toBaseTileX = (lowerRight.tileX << zoomLevelDifference) + (1 << zoomLevelDifference) - 1;
            this.toBaseTileY = (lowerRight.tileY << zoomLevelDifference) + (1 << zoomLevelDifference) - 1;
            this.useTileBitmask = false;
        } else if (upperLeft.zoomLevel > subFileParameter.baseZoomLevel) {
            int zoomLevelDifference = upperLeft.zoomLevel - subFileParameter.baseZoomLevel;
            this.fromBaseTileX = upperLeft.tileX >>> zoomLevelDifference;
            this.fromBaseTileY = upperLeft.tileY >>> zoomLevelDifference;
            this.toBaseTileX = lowerRight.tileX >>> zoomLevelDifference;
            this.toBaseTileY = lowerRight.tileY >>> zoomLevelDifference;
            this.useTileBitmask = true;
            this.queryTileBitmask = QueryCalculations.calculateTileBitmask(upperLeft, lowerRight, zoomLevelDifference);
        } else {
            this.fromBaseTileX = upperLeft.tileX;
            this.fromBaseTileY = upperLeft.tileY;
            this.toBaseTileX = lowerRight.tileX;
            this.toBaseTileY = lowerRight.tileY;
            this.useTileBitmask = false;
        }
    }

    public void calculateBlocks(SubFileParameter subFileParameter) {
        this.fromBlockX = Math.max(this.fromBaseTileX - subFileParameter.boundaryTileLeft, 0L);
        this.fromBlockY = Math.max(this.fromBaseTileY - subFileParameter.boundaryTileTop, 0L);
        this.toBlockX = Math.min(this.toBaseTileX - subFileParameter.boundaryTileLeft, subFileParameter.blocksWidth - 1L);
        this.toBlockY = Math.min(this.toBaseTileY - subFileParameter.boundaryTileTop, subFileParameter.blocksHeight - 1L);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QueryParameters)) {
            return false;
        }
        QueryParameters other = (QueryParameters)obj;
        return this.fromBaseTileX == other.fromBaseTileX && this.fromBlockX == other.fromBlockX && this.fromBaseTileY == other.fromBaseTileY && this.fromBlockY == other.fromBlockY && this.queryTileBitmask == other.queryTileBitmask && this.queryZoomLevel == other.queryZoomLevel && this.toBaseTileX == other.toBaseTileX && this.toBaseTileY == other.toBaseTileY && this.toBlockX == other.toBlockX && this.toBlockY == other.toBlockY && this.useTileBitmask == other.useTileBitmask;
    }

    public int hashCode() {
        int result = 7;
        result = 31 * result + (int)(this.fromBaseTileX ^ this.fromBaseTileX >>> 16);
        result = 31 * result + (int)(this.fromBaseTileY ^ this.fromBaseTileY >>> 16);
        result = 31 * result + (int)(this.toBaseTileX ^ this.toBaseTileX >>> 16);
        result = 31 * result + (int)(this.toBaseTileY ^ this.toBaseTileY >>> 16);
        result = 31 * result + (int)(this.fromBlockX ^ this.fromBlockX >>> 16);
        result = 31 * result + (int)(this.fromBlockY ^ this.fromBlockY >>> 16);
        result = 31 * result + (int)(this.toBlockX ^ this.toBlockX >>> 16);
        result = 31 * result + (int)(this.toBlockY ^ this.toBlockY >>> 16);
        result = 31 * result + this.queryZoomLevel;
        result = 31 * result + this.queryTileBitmask;
        return result;
    }
}

