/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.reader;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mapsforge.core.model.Tag;
import org.mapsforge.core.util.Parameters;
import org.mapsforge.map.reader.Deserializer;

public class ReadBuffer {
    private static final String CHARSET_UTF8 = "UTF-8";
    private static final Logger LOGGER = Logger.getLogger(ReadBuffer.class.getName());
    private byte[] bufferData;
    private int bufferPosition;
    private ByteBuffer bufferWrapper;
    private final FileChannel inputChannel;
    private final List<Integer> tagIds = new ArrayList<Integer>();

    ReadBuffer(FileChannel inputChannel) {
        this.inputChannel = inputChannel;
    }

    public byte readByte() {
        return this.bufferData[this.bufferPosition++];
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public boolean readFromFile(int length) throws IOException {
        if (this.bufferData == null || this.bufferData.length < length) {
            if (length > Parameters.MAXIMUM_BUFFER_SIZE) {
                LOGGER.warning("invalid read length: " + length);
                return false;
            }
            try {
                this.bufferData = new byte[length];
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, t.getMessage(), t);
                return false;
            }
            this.bufferWrapper = ByteBuffer.wrap(this.bufferData, 0, length);
        }
        this.bufferPosition = 0;
        this.bufferWrapper.clear();
        return this.inputChannel.read(this.bufferWrapper) == length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readFromFile(long offset, int length) throws IOException {
        if (this.bufferData == null || this.bufferData.length < length) {
            if (length > Parameters.MAXIMUM_BUFFER_SIZE) {
                LOGGER.warning("invalid read length: " + length);
                return false;
            }
            try {
                this.bufferData = new byte[length];
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, t.getMessage(), t);
                return false;
            }
            this.bufferWrapper = ByteBuffer.wrap(this.bufferData, 0, length);
        }
        this.bufferPosition = 0;
        this.bufferWrapper.clear();
        FileChannel fileChannel = this.inputChannel;
        synchronized (fileChannel) {
            this.inputChannel.position(offset);
            return this.inputChannel.read(this.bufferWrapper) == length;
        }
    }

    public int readInt() {
        this.bufferPosition += 4;
        return Deserializer.getInt(this.bufferData, this.bufferPosition - 4);
    }

    public long readLong() {
        this.bufferPosition += 8;
        return Deserializer.getLong(this.bufferData, this.bufferPosition - 8);
    }

    public int readShort() {
        this.bufferPosition += 2;
        return Deserializer.getShort(this.bufferData, this.bufferPosition - 2);
    }

    public int readSignedInt() {
        int variableByteDecode = 0;
        int variableByteShift = 0;
        while ((this.bufferData[this.bufferPosition] & 0x80) != 0) {
            variableByteDecode |= (this.bufferData[this.bufferPosition++] & 0x7F) << variableByteShift;
            variableByteShift = (byte)(variableByteShift + 7);
        }
        if ((this.bufferData[this.bufferPosition] & 0x40) != 0) {
            return -(variableByteDecode | (this.bufferData[this.bufferPosition++] & 0x3F) << variableByteShift);
        }
        return variableByteDecode | (this.bufferData[this.bufferPosition++] & 0x3F) << variableByteShift;
    }

    List<Tag> readTags(Tag[] tagsArray, byte numberOfTags) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        this.tagIds.clear();
        int maxTag = tagsArray.length;
        for (byte tagIndex = numberOfTags; tagIndex != 0; tagIndex = (byte)(tagIndex - 1)) {
            int tagId = this.readUnsignedInt();
            if (tagId < 0 || tagId >= maxTag) {
                LOGGER.warning("invalid tag ID: " + tagId);
                return null;
            }
            this.tagIds.add(tagId);
        }
        for (int tagId : this.tagIds) {
            Tag tag = tagsArray[tagId];
            if (tag.value.length() == 2 && tag.value.charAt(0) == '%') {
                String value = tag.value;
                if (value.charAt(1) == 'b') {
                    value = String.valueOf(this.readByte());
                } else if (value.charAt(1) == 'i') {
                    value = tag.key.contains(":colour") ? "#" + Integer.toHexString(this.readInt()) : String.valueOf(this.readInt());
                } else if (value.charAt(1) == 'f') {
                    value = String.valueOf(this.readFloat());
                } else if (value.charAt(1) == 'h') {
                    value = String.valueOf(this.readShort());
                } else if (value.charAt(1) == 's') {
                    value = this.readUTF8EncodedString();
                }
                tag = new Tag(tag.key, value);
            }
            tags.add(tag);
        }
        return tags;
    }

    public int readUnsignedInt() {
        int variableByteDecode = 0;
        int variableByteShift = 0;
        while ((this.bufferData[this.bufferPosition] & 0x80) != 0) {
            variableByteDecode |= (this.bufferData[this.bufferPosition++] & 0x7F) << variableByteShift;
            variableByteShift = (byte)(variableByteShift + 7);
        }
        return variableByteDecode | this.bufferData[this.bufferPosition++] << variableByteShift;
    }

    public String readUTF8EncodedString() {
        return this.readUTF8EncodedString(this.readUnsignedInt());
    }

    public String readUTF8EncodedString(int stringLength) {
        if (stringLength > 0 && this.bufferPosition + stringLength <= this.bufferData.length) {
            this.bufferPosition += stringLength;
            try {
                return new String(this.bufferData, this.bufferPosition - stringLength, stringLength, CHARSET_UTF8);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        LOGGER.warning("invalid string length: " + stringLength);
        return null;
    }

    int getBufferPosition() {
        return this.bufferPosition;
    }

    int getBufferSize() {
        return this.bufferData.length;
    }

    void setBufferPosition(int bufferPosition) {
        this.bufferPosition = bufferPosition;
    }

    void skipBytes(int bytes) {
        this.bufferPosition += bytes;
    }
}

