/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.reader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.Tag;
import org.mapsforge.core.model.Tile;
import org.mapsforge.core.util.LatLongUtils;
import org.mapsforge.core.util.MercatorProjection;
import org.mapsforge.core.util.Parameters;
import org.mapsforge.map.datastore.MapDataStore;
import org.mapsforge.map.datastore.MapReadResult;
import org.mapsforge.map.datastore.PoiWayBundle;
import org.mapsforge.map.datastore.PointOfInterest;
import org.mapsforge.map.datastore.Way;
import org.mapsforge.map.reader.IndexCache;
import org.mapsforge.map.reader.QueryParameters;
import org.mapsforge.map.reader.ReadBuffer;
import org.mapsforge.map.reader.header.MapFileException;
import org.mapsforge.map.reader.header.MapFileHeader;
import org.mapsforge.map.reader.header.MapFileInfo;
import org.mapsforge.map.reader.header.SubFileParameter;

public class MapFile
extends MapDataStore {
    private static final Logger LOGGER = Logger.getLogger(MapFile.class.getName());
    public static final MapFile TEST_MAP_FILE = new MapFile();
    private static final long BITMASK_INDEX_OFFSET = 0x7FFFFFFFFFL;
    private static final long BITMASK_INDEX_WATER = 0x8000000000L;
    private static final byte DEFAULT_START_ZOOM_LEVEL = 12;
    private static final int INDEX_CACHE_SIZE = 64;
    private static final String INVALID_FIRST_WAY_OFFSET = "invalid first way offset: ";
    private static final int POI_FEATURE_ELEVATION = 32;
    private static final int POI_FEATURE_HOUSE_NUMBER = 64;
    private static final int POI_FEATURE_NAME = 128;
    private static final int POI_LAYER_BITMASK = 240;
    private static final int POI_LAYER_SHIFT = 4;
    private static final int POI_NUMBER_OF_TAGS_BITMASK = 15;
    private static final byte SIGNATURE_LENGTH_BLOCK = 32;
    private static final byte SIGNATURE_LENGTH_POI = 32;
    private static final byte SIGNATURE_LENGTH_WAY = 32;
    private static final String TAG_KEY_ELE = "ele";
    private static final String TAG_KEY_HOUSE_NUMBER = "addr:housenumber";
    private static final String TAG_KEY_NAME = "name";
    private static final String TAG_KEY_REF = "ref";
    private static final int WAY_FEATURE_DATA_BLOCKS_BYTE = 8;
    private static final int WAY_FEATURE_DOUBLE_DELTA_ENCODING = 4;
    private static final int WAY_FEATURE_HOUSE_NUMBER = 64;
    private static final int WAY_FEATURE_LABEL_POSITION = 16;
    private static final int WAY_FEATURE_NAME = 128;
    private static final int WAY_FEATURE_REF = 32;
    private static final int WAY_LAYER_BITMASK = 240;
    private static final int WAY_LAYER_SHIFT = 4;
    private static final int WAY_NUMBER_OF_TAGS_BITMASK = 15;
    public static boolean wayFilterEnabled = true;
    public static int wayFilterDistance = 20;
    private final IndexCache databaseIndexCache;
    private final long fileSize;
    private final FileChannel inputChannel;
    private final MapFileHeader mapFileHeader;
    private final long timestamp;
    private byte zoomLevelMin = 0;
    private byte zoomLevelMax = (byte)127;

    private MapFile() {
        this.databaseIndexCache = null;
        this.fileSize = 0L;
        this.inputChannel = null;
        this.mapFileHeader = null;
        this.timestamp = System.currentTimeMillis();
    }

    public MapFile(File mapFile) {
        this(mapFile, null);
    }

    public MapFile(File mapFile, String language) {
        super(language);
        if (mapFile == null) {
            throw new MapFileException("mapFile must not be null");
        }
        try {
            if (!mapFile.exists()) {
                throw new MapFileException("file does not exist: " + mapFile);
            }
            if (!mapFile.isFile()) {
                throw new MapFileException("not a file: " + mapFile);
            }
            if (!mapFile.canRead()) {
                throw new MapFileException("cannot read file: " + mapFile);
            }
            FileInputStream fis = new FileInputStream(mapFile);
            this.inputChannel = fis.getChannel();
            this.fileSize = this.inputChannel.size();
            ReadBuffer readBuffer = new ReadBuffer(this.inputChannel);
            this.mapFileHeader = new MapFileHeader();
            this.mapFileHeader.readHeader(readBuffer, this.fileSize);
            this.databaseIndexCache = new IndexCache(this.inputChannel, 64);
            this.timestamp = mapFile.lastModified();
        }
        catch (Exception e) {
            this.closeFileChannel();
            throw new MapFileException(e.getMessage());
        }
    }

    public MapFile(FileInputStream mapFileInputStream) {
        this(mapFileInputStream, null);
    }

    public MapFile(FileInputStream mapFileInputStream, String language) {
        this(mapFileInputStream, System.currentTimeMillis(), language);
    }

    public MapFile(FileInputStream mapFileInputStream, long lastModified, String language) {
        super(language);
        if (mapFileInputStream == null) {
            throw new MapFileException("mapFileInputStream must not be null");
        }
        try {
            this.inputChannel = mapFileInputStream.getChannel();
            this.fileSize = this.inputChannel.size();
            ReadBuffer readBuffer = new ReadBuffer(this.inputChannel);
            this.mapFileHeader = new MapFileHeader();
            this.mapFileHeader.readHeader(readBuffer, this.fileSize);
            this.databaseIndexCache = new IndexCache(this.inputChannel, 64);
            this.timestamp = lastModified;
        }
        catch (Exception e) {
            this.closeFileChannel();
            throw new MapFileException(e.getMessage());
        }
    }

    public MapFile(FileChannel mapFileChannel) {
        this(mapFileChannel, null);
    }

    public MapFile(FileChannel mapFileChannel, String language) {
        this(mapFileChannel, System.currentTimeMillis(), language);
    }

    public MapFile(FileChannel mapFileChannel, long lastModified, String language) {
        super(language);
        if (mapFileChannel == null) {
            throw new MapFileException("mapFileChannel must not be null");
        }
        try {
            this.inputChannel = mapFileChannel;
            this.fileSize = this.inputChannel.size();
            ReadBuffer readBuffer = new ReadBuffer(this.inputChannel);
            this.mapFileHeader = new MapFileHeader();
            this.mapFileHeader.readHeader(readBuffer, this.fileSize);
            this.databaseIndexCache = new IndexCache(this.inputChannel, 64);
            this.timestamp = lastModified;
        }
        catch (Exception e) {
            this.closeFileChannel();
            throw new MapFileException(e.getMessage());
        }
    }

    public MapFile(String mapPath) {
        this(mapPath, null);
    }

    public MapFile(String mapPath, String language) {
        this(new File(mapPath), language);
    }

    public BoundingBox boundingBox() {
        return this.getMapFileInfo().boundingBox;
    }

    public void close() {
        this.closeFileChannel();
    }

    private void closeFileChannel() {
        try {
            if (this.databaseIndexCache != null) {
                this.databaseIndexCache.destroy();
            }
            if (this.inputChannel != null) {
                this.inputChannel.close();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void decodeWayNodesDoubleDelta(LatLong[] waySegment, double tileLatitude, double tileLongitude, ReadBuffer readBuffer) {
        double wayNodeLatitude = tileLatitude + LatLongUtils.microdegreesToDegrees((int)readBuffer.readSignedInt());
        double wayNodeLongitude = tileLongitude + LatLongUtils.microdegreesToDegrees((int)readBuffer.readSignedInt());
        waySegment[0] = new LatLong(wayNodeLatitude, wayNodeLongitude);
        double previousSingleDeltaLatitude = 0.0;
        double previousSingleDeltaLongitude = 0.0;
        for (int wayNodesIndex = 1; wayNodesIndex < waySegment.length; ++wayNodesIndex) {
            double doubleDeltaLatitude = LatLongUtils.microdegreesToDegrees((int)readBuffer.readSignedInt());
            double doubleDeltaLongitude = LatLongUtils.microdegreesToDegrees((int)readBuffer.readSignedInt());
            double singleDeltaLatitude = doubleDeltaLatitude + previousSingleDeltaLatitude;
            double singleDeltaLongitude = doubleDeltaLongitude + previousSingleDeltaLongitude;
            wayNodeLatitude += singleDeltaLatitude;
            if ((wayNodeLongitude += singleDeltaLongitude) < -180.0 && -180.0 - wayNodeLongitude < 0.001) {
                wayNodeLongitude = -180.0;
            } else if (wayNodeLongitude > 180.0 && wayNodeLongitude - 180.0 < 0.001) {
                wayNodeLongitude = 180.0;
            }
            waySegment[wayNodesIndex] = new LatLong(wayNodeLatitude, wayNodeLongitude);
            previousSingleDeltaLatitude = singleDeltaLatitude;
            previousSingleDeltaLongitude = singleDeltaLongitude;
        }
    }

    private void decodeWayNodesSingleDelta(LatLong[] waySegment, double tileLatitude, double tileLongitude, ReadBuffer readBuffer) {
        double wayNodeLatitude = tileLatitude + LatLongUtils.microdegreesToDegrees((int)readBuffer.readSignedInt());
        double wayNodeLongitude = tileLongitude + LatLongUtils.microdegreesToDegrees((int)readBuffer.readSignedInt());
        waySegment[0] = new LatLong(wayNodeLatitude, wayNodeLongitude);
        for (int wayNodesIndex = 1; wayNodesIndex < waySegment.length; ++wayNodesIndex) {
            wayNodeLatitude += LatLongUtils.microdegreesToDegrees((int)readBuffer.readSignedInt());
            if ((wayNodeLongitude += LatLongUtils.microdegreesToDegrees((int)readBuffer.readSignedInt())) < -180.0 && -180.0 - wayNodeLongitude < 0.001) {
                wayNodeLongitude = -180.0;
            } else if (wayNodeLongitude > 180.0 && wayNodeLongitude - 180.0 < 0.001) {
                wayNodeLongitude = 180.0;
            }
            waySegment[wayNodesIndex] = new LatLong(wayNodeLatitude, wayNodeLongitude);
        }
    }

    public long getDataTimestamp(Tile tile) {
        return this.timestamp;
    }

    public MapFileHeader getMapFileHeader() {
        return this.mapFileHeader;
    }

    public MapFileInfo getMapFileInfo() {
        return this.mapFileHeader.getMapFileInfo();
    }

    public String[] getMapLanguages() {
        String languagesPreference = this.getMapFileInfo().languagesPreference;
        if (languagesPreference != null && !languagesPreference.trim().isEmpty()) {
            return languagesPreference.split(",");
        }
        return null;
    }

    private PoiWayBundle processBlock(QueryParameters queryParameters, SubFileParameter subFileParameter, BoundingBox boundingBox, double tileLatitude, double tileLongitude, Selector selector, ReadBuffer readBuffer) {
        List<Object> ways;
        if (!this.processBlockSignature(readBuffer)) {
            return null;
        }
        int[][] zoomTable = this.readZoomTable(subFileParameter, readBuffer);
        int zoomTableRow = queryParameters.queryZoomLevel - subFileParameter.zoomLevelMin;
        int poisOnQueryZoomLevel = zoomTable[zoomTableRow][0];
        int waysOnQueryZoomLevel = zoomTable[zoomTableRow][1];
        int firstWayOffset = readBuffer.readUnsignedInt();
        if (firstWayOffset < 0) {
            LOGGER.warning(INVALID_FIRST_WAY_OFFSET + firstWayOffset);
            return null;
        }
        if ((firstWayOffset += readBuffer.getBufferPosition()) > readBuffer.getBufferSize()) {
            LOGGER.warning(INVALID_FIRST_WAY_OFFSET + firstWayOffset);
            return null;
        }
        boolean filterRequired = queryParameters.queryZoomLevel > subFileParameter.baseZoomLevel;
        List<PointOfInterest> pois = this.processPOIs(tileLatitude, tileLongitude, poisOnQueryZoomLevel, boundingBox, filterRequired, readBuffer);
        if (pois == null) {
            return null;
        }
        if (Selector.POIS == selector) {
            ways = Collections.emptyList();
        } else {
            if (readBuffer.getBufferPosition() > firstWayOffset) {
                LOGGER.warning("invalid buffer position: " + readBuffer.getBufferPosition());
                return null;
            }
            readBuffer.setBufferPosition(firstWayOffset);
            ways = this.processWays(queryParameters, waysOnQueryZoomLevel, boundingBox, filterRequired, tileLatitude, tileLongitude, selector, readBuffer);
            if (ways == null) {
                return null;
            }
        }
        return new PoiWayBundle(pois, ways);
    }

    private boolean processBlockSignature(ReadBuffer readBuffer) {
        String signatureBlock;
        if (this.mapFileHeader.getMapFileInfo().debugFile && !(signatureBlock = readBuffer.readUTF8EncodedString(32)).startsWith("###TileStart")) {
            LOGGER.warning("invalid block signature: " + signatureBlock);
            return false;
        }
        return true;
    }

    private MapReadResult processBlocks(QueryParameters queryParameters, SubFileParameter subFileParameter, BoundingBox boundingBox, Selector selector) throws IOException {
        boolean queryIsWater = true;
        boolean queryReadWaterInfo = false;
        MapReadResult mapFileReadResult = new MapReadResult();
        for (long row = queryParameters.fromBlockY; row <= queryParameters.toBlockY; ++row) {
            for (long column = queryParameters.fromBlockX; column <= queryParameters.toBlockX; ++column) {
                long nextBlockPointer;
                long currentBlockPointer;
                long blockNumber = row * subFileParameter.blocksWidth + column;
                long currentBlockIndexEntry = this.databaseIndexCache.getIndexEntry(subFileParameter, blockNumber);
                if (queryIsWater) {
                    queryIsWater &= (currentBlockIndexEntry & 0x8000000000L) != 0L;
                    queryReadWaterInfo = true;
                }
                if ((currentBlockPointer = currentBlockIndexEntry & 0x7FFFFFFFFFL) < 1L || currentBlockPointer > subFileParameter.subFileSize) {
                    LOGGER.warning("invalid current block pointer: " + currentBlockPointer);
                    LOGGER.warning("subFileSize: " + subFileParameter.subFileSize);
                    return null;
                }
                if (blockNumber + 1L == subFileParameter.numberOfBlocks) {
                    nextBlockPointer = subFileParameter.subFileSize;
                } else {
                    nextBlockPointer = this.databaseIndexCache.getIndexEntry(subFileParameter, blockNumber + 1L) & 0x7FFFFFFFFFL;
                    if (nextBlockPointer > subFileParameter.subFileSize) {
                        LOGGER.warning("invalid next block pointer: " + nextBlockPointer);
                        LOGGER.warning("sub-file size: " + subFileParameter.subFileSize);
                        return null;
                    }
                }
                int currentBlockSize = (int)(nextBlockPointer - currentBlockPointer);
                if (currentBlockSize < 0) {
                    LOGGER.warning("current block size must not be negative: " + currentBlockSize);
                    return null;
                }
                if (currentBlockSize == 0) continue;
                if (currentBlockSize > Parameters.MAXIMUM_BUFFER_SIZE) {
                    LOGGER.warning("current block size too large: " + currentBlockSize);
                    continue;
                }
                if (currentBlockPointer + (long)currentBlockSize > this.fileSize) {
                    LOGGER.warning("current block largher than file size: " + currentBlockSize);
                    return null;
                }
                ReadBuffer readBuffer = new ReadBuffer(this.inputChannel);
                if (!readBuffer.readFromFile(subFileParameter.startAddress + currentBlockPointer, currentBlockSize)) {
                    LOGGER.warning("reading current block has failed: " + currentBlockSize);
                    return null;
                }
                double tileLatitude = MercatorProjection.tileYToLatitude((long)(subFileParameter.boundaryTileTop + row), (byte)subFileParameter.baseZoomLevel);
                double tileLongitude = MercatorProjection.tileXToLongitude((long)(subFileParameter.boundaryTileLeft + column), (byte)subFileParameter.baseZoomLevel);
                try {
                    PoiWayBundle poiWayBundle = this.processBlock(queryParameters, subFileParameter, boundingBox, tileLatitude, tileLongitude, selector, readBuffer);
                    if (poiWayBundle == null) continue;
                    mapFileReadResult.add(poiWayBundle);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        if (!queryIsWater || queryReadWaterInfo) {
            // empty if block
        }
        return mapFileReadResult;
    }

    private List<PointOfInterest> processPOIs(double tileLatitude, double tileLongitude, int numberOfPois, BoundingBox boundingBox, boolean filterRequired, ReadBuffer readBuffer) {
        ArrayList<PointOfInterest> pois = new ArrayList<PointOfInterest>();
        Tag[] poiTags = this.mapFileHeader.getMapFileInfo().poiTags;
        for (int elementCounter = numberOfPois; elementCounter != 0; --elementCounter) {
            boolean featureElevation;
            String signaturePoi;
            if (this.mapFileHeader.getMapFileInfo().debugFile && !(signaturePoi = readBuffer.readUTF8EncodedString(32)).startsWith("***POIStart")) {
                LOGGER.warning("invalid POI signature: " + signaturePoi);
                return null;
            }
            double latitude = tileLatitude + LatLongUtils.microdegreesToDegrees((int)readBuffer.readSignedInt());
            double longitude = tileLongitude + LatLongUtils.microdegreesToDegrees((int)readBuffer.readSignedInt());
            byte specialByte = readBuffer.readByte();
            byte layer = (byte)((specialByte & 0xF0) >>> 4);
            byte numberOfTags = (byte)(specialByte & 0xF);
            List<Tag> tags = readBuffer.readTags(poiTags, numberOfTags);
            if (tags == null) {
                return null;
            }
            byte featureByte = readBuffer.readByte();
            boolean featureName = (featureByte & 0x80) != 0;
            boolean featureHouseNumber = (featureByte & 0x40) != 0;
            boolean bl = featureElevation = (featureByte & 0x20) != 0;
            if (featureName) {
                tags.add(new Tag(TAG_KEY_NAME, this.extractLocalized(readBuffer.readUTF8EncodedString())));
            }
            if (featureHouseNumber) {
                tags.add(new Tag(TAG_KEY_HOUSE_NUMBER, readBuffer.readUTF8EncodedString()));
            }
            if (featureElevation) {
                tags.add(new Tag(TAG_KEY_ELE, Integer.toString(readBuffer.readSignedInt())));
            }
            LatLong position = new LatLong(latitude, longitude);
            if (filterRequired && !boundingBox.contains(position)) continue;
            pois.add(new PointOfInterest(layer, tags, position));
        }
        return pois;
    }

    private LatLong[][] processWayDataBlock(double tileLatitude, double tileLongitude, boolean doubleDeltaEncoding, ReadBuffer readBuffer) {
        int numberOfWayCoordinateBlocks = readBuffer.readUnsignedInt();
        if (numberOfWayCoordinateBlocks < 1 || numberOfWayCoordinateBlocks > Short.MAX_VALUE) {
            LOGGER.warning("invalid number of way coordinate blocks: " + numberOfWayCoordinateBlocks);
            return null;
        }
        LatLong[][] wayCoordinates = new LatLong[numberOfWayCoordinateBlocks][];
        for (int coordinateBlock = 0; coordinateBlock < numberOfWayCoordinateBlocks; ++coordinateBlock) {
            int numberOfWayNodes = readBuffer.readUnsignedInt();
            if (numberOfWayNodes < 2 || numberOfWayNodes > Short.MAX_VALUE) {
                LOGGER.warning("invalid number of way nodes: " + numberOfWayNodes);
                return null;
            }
            LatLong[] waySegment = new LatLong[numberOfWayNodes];
            if (doubleDeltaEncoding) {
                this.decodeWayNodesDoubleDelta(waySegment, tileLatitude, tileLongitude, readBuffer);
            } else {
                this.decodeWayNodesSingleDelta(waySegment, tileLatitude, tileLongitude, readBuffer);
            }
            wayCoordinates[coordinateBlock] = waySegment;
        }
        return wayCoordinates;
    }

    private List<Way> processWays(QueryParameters queryParameters, int numberOfWays, BoundingBox boundingBox, boolean filterRequired, double tileLatitude, double tileLongitude, Selector selector, ReadBuffer readBuffer) {
        ArrayList<Way> ways = new ArrayList<Way>();
        Tag[] wayTags = this.mapFileHeader.getMapFileInfo().wayTags;
        BoundingBox wayFilterBbox = boundingBox.extendMeters(wayFilterDistance);
        for (int elementCounter = numberOfWays; elementCounter != 0; --elementCounter) {
            int wayDataBlocks;
            boolean featureWayDoubleDeltaEncoding;
            String signatureWay;
            if (this.mapFileHeader.getMapFileInfo().debugFile && !(signatureWay = readBuffer.readUTF8EncodedString(32)).startsWith("---WayStart")) {
                LOGGER.warning("invalid way signature: " + signatureWay);
                return null;
            }
            int wayDataSize = readBuffer.readUnsignedInt();
            if (wayDataSize < 0) {
                LOGGER.warning("invalid way data size: " + wayDataSize);
                return null;
            }
            if (queryParameters.useTileBitmask) {
                int tileBitmask = readBuffer.readShort();
                if ((queryParameters.queryTileBitmask & tileBitmask) == 0) {
                    readBuffer.skipBytes(wayDataSize - 2);
                    continue;
                }
            } else {
                readBuffer.skipBytes(2);
            }
            byte specialByte = readBuffer.readByte();
            byte layer = (byte)((specialByte & 0xF0) >>> 4);
            byte numberOfTags = (byte)(specialByte & 0xF);
            List<Tag> tags = readBuffer.readTags(wayTags, numberOfTags);
            if (tags == null) {
                return null;
            }
            byte featureByte = readBuffer.readByte();
            boolean featureName = (featureByte & 0x80) != 0;
            boolean featureHouseNumber = (featureByte & 0x40) != 0;
            boolean featureRef = (featureByte & 0x20) != 0;
            boolean featureLabelPosition = (featureByte & 0x10) != 0;
            boolean featureWayDataBlocksByte = (featureByte & 8) != 0;
            boolean bl = featureWayDoubleDeltaEncoding = (featureByte & 4) != 0;
            if (featureName) {
                tags.add(new Tag(TAG_KEY_NAME, this.extractLocalized(readBuffer.readUTF8EncodedString())));
            }
            if (featureHouseNumber) {
                tags.add(new Tag(TAG_KEY_HOUSE_NUMBER, readBuffer.readUTF8EncodedString()));
            }
            if (featureRef) {
                tags.add(new Tag(TAG_KEY_REF, readBuffer.readUTF8EncodedString()));
            }
            int[] labelPosition = null;
            if (featureLabelPosition) {
                labelPosition = this.readOptionalLabelPosition(readBuffer);
            }
            if ((wayDataBlocks = this.readOptionalWayDataBlocksByte(featureWayDataBlocksByte, readBuffer)) < 1) {
                LOGGER.warning("invalid number of way data blocks: " + wayDataBlocks);
                return null;
            }
            for (int wayDataBlock = 0; wayDataBlock < wayDataBlocks; ++wayDataBlock) {
                LatLong[][] wayNodes = this.processWayDataBlock(tileLatitude, tileLongitude, featureWayDoubleDeltaEncoding, readBuffer);
                if (wayNodes == null || filterRequired && wayFilterEnabled && !wayFilterBbox.intersectsArea(wayNodes) || Selector.ALL != selector && !featureName && !featureHouseNumber && !featureRef && !this.wayAsLabelTagFilter(tags)) continue;
                LatLong labelLatLong = null;
                if (labelPosition != null) {
                    labelLatLong = new LatLong(wayNodes[0][0].latitude + LatLongUtils.microdegreesToDegrees((int)labelPosition[1]), wayNodes[0][0].longitude + LatLongUtils.microdegreesToDegrees((int)labelPosition[0]));
                }
                ways.add(new Way(layer, tags, wayNodes, labelLatLong));
            }
        }
        return ways;
    }

    public MapReadResult readLabels(Tile tile) {
        return this.readMapData(tile, tile, Selector.LABELS);
    }

    public MapReadResult readLabels(Tile upperLeft, Tile lowerRight) {
        return this.readMapData(upperLeft, lowerRight, Selector.LABELS);
    }

    public MapReadResult readMapData(Tile tile) {
        return this.readMapData(tile, tile, Selector.ALL);
    }

    public MapReadResult readMapData(Tile upperLeft, Tile lowerRight) {
        return this.readMapData(upperLeft, lowerRight, Selector.ALL);
    }

    private MapReadResult readMapData(Tile upperLeft, Tile lowerRight, Selector selector) {
        if (upperLeft.tileX > lowerRight.tileX || upperLeft.tileY > lowerRight.tileY) {
            new IllegalArgumentException("upperLeft tile must be above and left of lowerRight tile");
        }
        try {
            QueryParameters queryParameters = new QueryParameters();
            queryParameters.queryZoomLevel = this.mapFileHeader.getQueryZoomLevel(upperLeft.zoomLevel);
            SubFileParameter subFileParameter = this.mapFileHeader.getSubFileParameter(queryParameters.queryZoomLevel);
            if (subFileParameter == null) {
                LOGGER.warning("no sub-file for zoom level: " + queryParameters.queryZoomLevel);
                return null;
            }
            queryParameters.calculateBaseTiles(upperLeft, lowerRight, subFileParameter);
            queryParameters.calculateBlocks(subFileParameter);
            return this.processBlocks(queryParameters, subFileParameter, Tile.getBoundingBox((Tile)upperLeft, (Tile)lowerRight), selector);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    private int[] readOptionalLabelPosition(ReadBuffer readBuffer) {
        int[] labelPosition = new int[2];
        labelPosition[1] = readBuffer.readSignedInt();
        labelPosition[0] = readBuffer.readSignedInt();
        return labelPosition;
    }

    private int readOptionalWayDataBlocksByte(boolean featureWayDataBlocksByte, ReadBuffer readBuffer) {
        if (featureWayDataBlocksByte) {
            return readBuffer.readUnsignedInt();
        }
        return 1;
    }

    public MapReadResult readPoiData(Tile tile) {
        return this.readMapData(tile, tile, Selector.POIS);
    }

    public MapReadResult readPoiData(Tile upperLeft, Tile lowerRight) {
        return this.readMapData(upperLeft, lowerRight, Selector.POIS);
    }

    private int[][] readZoomTable(SubFileParameter subFileParameter, ReadBuffer readBuffer) {
        int rows = subFileParameter.zoomLevelMax - subFileParameter.zoomLevelMin + 1;
        int[][] zoomTable = new int[rows][2];
        int cumulatedNumberOfPois = 0;
        int cumulatedNumberOfWays = 0;
        for (int row = 0; row < rows; ++row) {
            zoomTable[row][0] = cumulatedNumberOfPois += readBuffer.readUnsignedInt();
            zoomTable[row][1] = cumulatedNumberOfWays += readBuffer.readUnsignedInt();
        }
        return zoomTable;
    }

    public void restrictToZoomRange(byte minZoom, byte maxZoom) {
        this.zoomLevelMax = maxZoom;
        this.zoomLevelMin = minZoom;
    }

    public LatLong startPosition() {
        if (null != this.getMapFileInfo().startPosition) {
            return this.getMapFileInfo().startPosition;
        }
        return this.getMapFileInfo().boundingBox.getCenterPoint();
    }

    public Byte startZoomLevel() {
        if (null != this.getMapFileInfo().startZoomLevel) {
            return this.getMapFileInfo().startZoomLevel;
        }
        return (byte)12;
    }

    public boolean supportsTile(Tile tile) {
        return tile.getBoundingBox().intersects(this.getMapFileInfo().boundingBox) && tile.zoomLevel >= this.zoomLevelMin && tile.zoomLevel <= this.zoomLevelMax;
    }

    private static enum Selector {
        ALL,
        POIS,
        LABELS;

    }
}

