/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.reader.header;

import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.util.LatLongUtils;
import org.mapsforge.map.reader.ReadBuffer;
import org.mapsforge.map.reader.header.MapFileException;
import org.mapsforge.map.reader.header.MapFileInfoBuilder;

final class OptionalFields {
    private static final int HEADER_BITMASK_COMMENT = 8;
    private static final int HEADER_BITMASK_CREATED_BY = 4;
    private static final int HEADER_BITMASK_DEBUG = 128;
    private static final int HEADER_BITMASK_LANGUAGES_PREFERENCE = 16;
    private static final int HEADER_BITMASK_START_POSITION = 64;
    private static final int HEADER_BITMASK_START_ZOOM_LEVEL = 32;
    private static final int START_ZOOM_LEVEL_MAX = 22;
    String comment;
    String createdBy;
    final boolean hasComment;
    final boolean hasCreatedBy;
    final boolean hasLanguagesPreference;
    final boolean hasStartPosition;
    final boolean hasStartZoomLevel;
    final boolean isDebugFile;
    String languagesPreference;
    LatLong startPosition;
    Byte startZoomLevel;

    static void readOptionalFields(ReadBuffer readBuffer, MapFileInfoBuilder mapFileInfoBuilder) {
        OptionalFields optionalFields;
        mapFileInfoBuilder.optionalFields = optionalFields = new OptionalFields(readBuffer.readByte());
        optionalFields.readOptionalFields(readBuffer);
    }

    private OptionalFields(byte flags) {
        this.isDebugFile = (flags & 0x80) != 0;
        this.hasStartPosition = (flags & 0x40) != 0;
        this.hasStartZoomLevel = (flags & 0x20) != 0;
        this.hasLanguagesPreference = (flags & 0x10) != 0;
        this.hasComment = (flags & 8) != 0;
        this.hasCreatedBy = (flags & 4) != 0;
    }

    private void readLanguagesPreference(ReadBuffer readBuffer) {
        if (this.hasLanguagesPreference) {
            this.languagesPreference = readBuffer.readUTF8EncodedString();
        }
    }

    private void readMapStartPosition(ReadBuffer readBuffer) {
        if (this.hasStartPosition) {
            double mapStartLatitude = LatLongUtils.microdegreesToDegrees((int)readBuffer.readInt());
            double mapStartLongitude = LatLongUtils.microdegreesToDegrees((int)readBuffer.readInt());
            try {
                this.startPosition = new LatLong(mapStartLatitude, mapStartLongitude);
            }
            catch (IllegalArgumentException e) {
                throw new MapFileException(e.getMessage());
            }
        }
    }

    private void readMapStartZoomLevel(ReadBuffer readBuffer) {
        if (this.hasStartZoomLevel) {
            byte mapStartZoomLevel = readBuffer.readByte();
            if (mapStartZoomLevel < 0 || mapStartZoomLevel > 22) {
                throw new MapFileException("invalid map start zoom level: " + mapStartZoomLevel);
            }
            this.startZoomLevel = mapStartZoomLevel;
        }
    }

    private void readOptionalFields(ReadBuffer readBuffer) {
        this.readMapStartPosition(readBuffer);
        this.readMapStartZoomLevel(readBuffer);
        this.readLanguagesPreference(readBuffer);
        if (this.hasComment) {
            this.comment = readBuffer.readUTF8EncodedString();
        }
        if (this.hasCreatedBy) {
            this.createdBy = readBuffer.readUTF8EncodedString();
        }
    }
}

