/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.reader.header;

import org.mapsforge.core.util.MercatorProjection;
import org.mapsforge.map.reader.header.SubFileParameterBuilder;

public class SubFileParameter {
    public static final byte BYTES_PER_INDEX_ENTRY = 5;
    public final byte baseZoomLevel;
    public final long blocksHeight;
    public final long blocksWidth;
    public final long boundaryTileBottom;
    public final long boundaryTileLeft;
    public final long boundaryTileRight;
    public final long boundaryTileTop;
    public final long indexEndAddress;
    public final long indexStartAddress;
    public final long numberOfBlocks;
    public final long startAddress;
    public final long subFileSize;
    public final byte zoomLevelMax;
    public final byte zoomLevelMin;
    private final int hashCodeValue;

    SubFileParameter(SubFileParameterBuilder subFileParameterBuilder) {
        this.startAddress = subFileParameterBuilder.startAddress;
        this.indexStartAddress = subFileParameterBuilder.indexStartAddress;
        this.subFileSize = subFileParameterBuilder.subFileSize;
        this.baseZoomLevel = subFileParameterBuilder.baseZoomLevel;
        this.zoomLevelMin = subFileParameterBuilder.zoomLevelMin;
        this.zoomLevelMax = subFileParameterBuilder.zoomLevelMax;
        this.hashCodeValue = this.calculateHashCode();
        this.boundaryTileBottom = MercatorProjection.latitudeToTileY((double)subFileParameterBuilder.boundingBox.minLatitude, (byte)this.baseZoomLevel);
        this.boundaryTileLeft = MercatorProjection.longitudeToTileX((double)subFileParameterBuilder.boundingBox.minLongitude, (byte)this.baseZoomLevel);
        this.boundaryTileTop = MercatorProjection.latitudeToTileY((double)subFileParameterBuilder.boundingBox.maxLatitude, (byte)this.baseZoomLevel);
        this.boundaryTileRight = MercatorProjection.longitudeToTileX((double)subFileParameterBuilder.boundingBox.maxLongitude, (byte)this.baseZoomLevel);
        this.blocksWidth = this.boundaryTileRight - this.boundaryTileLeft + 1L;
        this.blocksHeight = this.boundaryTileBottom - this.boundaryTileTop + 1L;
        this.numberOfBlocks = this.blocksWidth * this.blocksHeight;
        this.indexEndAddress = this.indexStartAddress + this.numberOfBlocks * 5L;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SubFileParameter)) {
            return false;
        }
        SubFileParameter other = (SubFileParameter)obj;
        if (this.startAddress != other.startAddress) {
            return false;
        }
        if (this.subFileSize != other.subFileSize) {
            return false;
        }
        return this.baseZoomLevel == other.baseZoomLevel;
    }

    public int hashCode() {
        return this.hashCodeValue;
    }

    private int calculateHashCode() {
        int result = 7;
        result = 31 * result + (int)(this.startAddress ^ this.startAddress >>> 32);
        result = 31 * result + (int)(this.subFileSize ^ this.subFileSize >>> 32);
        result = 31 * result + this.baseZoomLevel;
        return result;
    }
}

