/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.renderer;

import org.mapsforge.core.model.Point;

class RendererUtils {
    private static final double ANGLE_LIMIT = 170.0;
    private static final double ANGLE_LIMIT_COS = Math.cos(Math.toRadians(170.0));

    static Point[] parallelPath(Point[] p, double dy) {
        int k;
        int n = p.length - 1;
        Point[] u = new Point[n];
        Point[] h = new Point[p.length];
        for (k = 0; k < n; ++k) {
            double c = p[k + 1].x - p[k].x;
            double s = p[k + 1].y - p[k].y;
            double l = Math.sqrt(c * c + s * s);
            u[k] = l == 0.0 ? new Point(0.0, 0.0) : new Point(c / l, s / l);
            if (k == 0 || !(u[k].x * u[k - 1].x + u[k].y * u[k - 1].y < ANGLE_LIMIT_COS)) continue;
            return p;
        }
        h[0] = new Point(p[0].x - dy * u[0].y, p[0].y + dy * u[0].x);
        for (k = 1; k < n; ++k) {
            double l = dy / (1.0 + u[k].x * u[k - 1].x + u[k].y * u[k - 1].y);
            h[k] = new Point(p[k].x - l * (u[k].y + u[k - 1].y), p[k].y + l * (u[k].x + u[k - 1].x));
        }
        h[n] = new Point(p[n].x - dy * u[n - 1].y, p[n].y + dy * u[n - 1].x);
        return h;
    }

    private RendererUtils() {
        throw new IllegalStateException();
    }
}

