/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.renderer;

import java.util.Collections;
import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.Display;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.graphics.Position;
import org.mapsforge.core.mapelements.MapElementContainer;
import org.mapsforge.core.mapelements.SymbolContainer;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Rectangle;
import org.mapsforge.core.model.Tag;
import org.mapsforge.core.model.Tile;
import org.mapsforge.core.util.MercatorProjection;
import org.mapsforge.map.datastore.MapDataStore;
import org.mapsforge.map.datastore.MapReadResult;
import org.mapsforge.map.datastore.PointOfInterest;
import org.mapsforge.map.datastore.Way;
import org.mapsforge.map.layer.hills.HillsRenderConfig;
import org.mapsforge.map.layer.renderer.CircleContainer;
import org.mapsforge.map.layer.renderer.PolylineContainer;
import org.mapsforge.map.layer.renderer.ShapePaintContainer;
import org.mapsforge.map.layer.renderer.WayDecorator;
import org.mapsforge.map.rendertheme.RenderCallback;
import org.mapsforge.map.rendertheme.RenderContext;

public class StandardRenderer
implements RenderCallback {
    private static final Byte DEFAULT_START_ZOOM_LEVEL = 12;
    private static final Tag TAG_NATURAL_WATER = new Tag("natural", "water");
    private static final byte ZOOM_MAX = 22;
    public final GraphicFactory graphicFactory;
    public final HillsRenderConfig hillsRenderConfig;
    public final MapDataStore mapDataStore;
    private final boolean renderLabels;

    public StandardRenderer(MapDataStore mapDataStore, GraphicFactory graphicFactory, boolean renderLabels) {
        this(mapDataStore, graphicFactory, renderLabels, null);
    }

    public StandardRenderer(MapDataStore mapDataStore, GraphicFactory graphicFactory, boolean renderLabels, HillsRenderConfig hillsRenderConfig) {
        this.mapDataStore = mapDataStore;
        this.graphicFactory = graphicFactory;
        this.renderLabels = renderLabels;
        this.hillsRenderConfig = hillsRenderConfig;
    }

    public LatLong getStartPosition() {
        if (this.mapDataStore != null) {
            return this.mapDataStore.startPosition();
        }
        return null;
    }

    public Byte getStartZoomLevel() {
        if (this.mapDataStore != null && null != this.mapDataStore.startZoomLevel()) {
            return this.mapDataStore.startZoomLevel();
        }
        return DEFAULT_START_ZOOM_LEVEL;
    }

    public byte getZoomLevelMax() {
        return 22;
    }

    @Override
    public void renderArea(RenderContext renderContext, Paint fill, Paint stroke, int level, PolylineContainer way) {
        renderContext.addToCurrentDrawingLayer(level, new ShapePaintContainer(way, stroke));
        renderContext.addToCurrentDrawingLayer(level, new ShapePaintContainer(way, fill));
    }

    @Override
    public void renderAreaCaption(RenderContext renderContext, Display display, int priority, String caption, float horizontalOffset, float verticalOffset, Paint fill, Paint stroke, Position position, int maxTextWidth, PolylineContainer way) {
        if (this.renderLabels) {
            Point centerPoint = way.getCenterAbsolute().offset((double)horizontalOffset, (double)verticalOffset);
            renderContext.labels.add((MapElementContainer)this.graphicFactory.createPointTextContainer(centerPoint, display, priority, caption, fill, stroke, null, position, maxTextWidth));
        }
    }

    @Override
    public void renderAreaSymbol(RenderContext renderContext, Display display, int priority, Bitmap symbol, PolylineContainer way) {
        if (this.renderLabels) {
            Point centerPosition = way.getCenterAbsolute();
            renderContext.labels.add((MapElementContainer)new SymbolContainer(centerPosition, display, priority, null, symbol));
        }
    }

    @Override
    public void renderPointOfInterestCaption(RenderContext renderContext, Display display, int priority, String caption, float horizontalOffset, float verticalOffset, Paint fill, Paint stroke, Position position, int maxTextWidth, PointOfInterest poi) {
        if (this.renderLabels) {
            Point poiPosition = MercatorProjection.getPixelAbsolute((LatLong)poi.position, (long)renderContext.rendererJob.tile.mapSize);
            renderContext.labels.add((MapElementContainer)this.graphicFactory.createPointTextContainer(poiPosition.offset((double)horizontalOffset, (double)verticalOffset), display, priority, caption, fill, stroke, null, position, maxTextWidth));
        }
    }

    @Override
    public void renderPointOfInterestCircle(RenderContext renderContext, float radius, Paint fill, Paint stroke, int level, PointOfInterest poi) {
        Point poiPosition = MercatorProjection.getPixelRelativeToTile((LatLong)poi.position, (Tile)renderContext.rendererJob.tile);
        renderContext.addToCurrentDrawingLayer(level, new ShapePaintContainer(new CircleContainer(poiPosition, radius), stroke));
        renderContext.addToCurrentDrawingLayer(level, new ShapePaintContainer(new CircleContainer(poiPosition, radius), fill));
    }

    @Override
    public void renderPointOfInterestSymbol(RenderContext renderContext, Display display, int priority, Rectangle boundary, Bitmap symbol, PointOfInterest poi) {
        if (this.renderLabels) {
            Point poiPosition = MercatorProjection.getPixelAbsolute((LatLong)poi.position, (long)renderContext.rendererJob.tile.mapSize);
            renderContext.labels.add((MapElementContainer)new SymbolContainer(poiPosition, display, priority, boundary, symbol));
        }
    }

    @Override
    public void renderWay(RenderContext renderContext, Paint stroke, float dy, int level, PolylineContainer way) {
        renderContext.addToCurrentDrawingLayer(level, new ShapePaintContainer(way, stroke, dy));
    }

    @Override
    public void renderWaySymbol(RenderContext renderContext, Display display, int priority, Bitmap symbol, float dy, Rectangle boundary, boolean repeat, float repeatGap, float repeatStart, boolean rotate, PolylineContainer way) {
        if (this.renderLabels) {
            WayDecorator.renderSymbol(symbol, display, priority, dy, boundary, repeat, repeatGap, repeatStart, rotate, way.getCoordinatesAbsolute(), renderContext.labels);
        }
    }

    @Override
    public void renderWayText(RenderContext renderContext, Display display, int priority, String textKey, float dy, Paint fill, Paint stroke, boolean repeat, float repeatGap, float repeatStart, boolean rotate, PolylineContainer way) {
        if (this.renderLabels) {
            WayDecorator.renderText(this.graphicFactory, way.getUpperLeft(), way.getLowerRight(), textKey, display, priority, dy, fill, stroke, repeat, repeatGap, repeatStart, rotate, way.getCoordinatesAbsolute(), renderContext.labels);
        }
    }

    boolean renderBitmap(RenderContext renderContext) {
        return !renderContext.renderTheme.hasMapBackgroundOutside() || this.mapDataStore.supportsTile(renderContext.rendererJob.tile);
    }

    protected void renderPointOfInterest(RenderContext renderContext, PointOfInterest pointOfInterest) {
        renderContext.setDrawingLayers(pointOfInterest.layer);
        renderContext.renderTheme.matchNode(this, renderContext, pointOfInterest);
    }

    protected void renderWaterBackground(RenderContext renderContext) {
        renderContext.setDrawingLayers((byte)0);
        Point[] coordinates = StandardRenderer.getTilePixelCoordinates(renderContext.rendererJob.tile.tileSize);
        Point tileOrigin = renderContext.rendererJob.tile.getOrigin();
        for (int i = 0; i < coordinates.length; ++i) {
            coordinates[i] = coordinates[i].offset(tileOrigin.x, tileOrigin.y);
        }
        PolylineContainer way = new PolylineContainer(coordinates, renderContext.rendererJob.tile, renderContext.rendererJob.tile, Collections.singletonList(TAG_NATURAL_WATER));
        renderContext.renderTheme.matchClosedWay(this, renderContext, way);
    }

    protected void renderWay(RenderContext renderContext, PolylineContainer way) {
        renderContext.setDrawingLayers(way.getLayer());
        if (way.isClosedWay()) {
            renderContext.renderTheme.matchClosedWay(this, renderContext, way);
        } else {
            renderContext.renderTheme.matchLinearWay(this, renderContext, way);
        }
    }

    protected void processReadMapData(RenderContext renderContext, MapReadResult mapReadResult) {
        if (mapReadResult == null) {
            return;
        }
        for (PointOfInterest pointOfInterest : mapReadResult.pointOfInterests) {
            this.renderPointOfInterest(renderContext, pointOfInterest);
        }
        for (Way way : mapReadResult.ways) {
            this.renderWay(renderContext, new PolylineContainer(way, renderContext.rendererJob.tile, renderContext.rendererJob.tile));
        }
        if (mapReadResult.isWater) {
            this.renderWaterBackground(renderContext);
        }
    }

    private static Point[] getTilePixelCoordinates(int tileSize) {
        Point[] result;
        result = new Point[]{new Point(0.0, 0.0), new Point((double)tileSize, 0.0), new Point((double)tileSize, (double)tileSize), new Point(0.0, (double)tileSize), result[0]};
        return result;
    }
}

