/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.download.tilesource;

import java.util.Arrays;
import java.util.Random;
import org.mapsforge.map.layer.download.tilesource.TileSource;

public abstract class AbstractTileSource
implements TileSource {
    private static final int TIMEOUT_CONNECT = 5000;
    private static final int TIMEOUT_READ = 10000;
    protected String apiKey;
    protected String authorization;
    protected long defaultTimeToLive = 86400000L;
    protected boolean followRedirects = true;
    protected final String[] hostNames;
    protected String keyName = "key";
    protected final int port;
    protected final Random random = new Random();
    protected String referer;
    protected int timeoutConnect = 5000;
    protected int timeoutRead = 10000;
    protected String userAgent;

    protected AbstractTileSource(String[] hostNames, int port) {
        if (hostNames == null || hostNames.length == 0) {
            throw new IllegalArgumentException("no host names specified");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("invalid port number: " + port);
        }
        for (String hostname : hostNames) {
            if (!hostname.isEmpty()) continue;
            throw new IllegalArgumentException("empty host name in host name list");
        }
        this.hostNames = hostNames;
        this.port = port;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractTileSource)) {
            return false;
        }
        AbstractTileSource other = (AbstractTileSource)obj;
        if (!Arrays.equals(this.hostNames, other.hostNames)) {
            return false;
        }
        return this.port == other.port;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    @Override
    public String getAuthorization() {
        return this.authorization;
    }

    @Override
    public long getDefaultTimeToLive() {
        return this.defaultTimeToLive;
    }

    protected String getHostName() {
        return this.hostNames[this.random.nextInt(this.hostNames.length)];
    }

    public String getKeyName() {
        return this.keyName;
    }

    @Override
    public String getReferer() {
        return this.referer;
    }

    @Override
    public int getTimeoutConnect() {
        return this.timeoutConnect;
    }

    @Override
    public int getTimeoutRead() {
        return this.timeoutRead;
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.hostNames);
        result = 31 * result + this.port;
        return result;
    }

    @Override
    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setAuthorization(String authorization) {
        this.authorization = authorization;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    public void setTimeoutConnect(int timeoutConnect) {
        this.timeoutConnect = timeoutConnect;
    }

    public void setTimeoutRead(int timeoutRead) {
        this.timeoutRead = timeoutRead;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }
}

