/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.hills;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.mapsforge.map.layer.hills.HgtCache;
import org.mapsforge.map.layer.hills.ShadingAlgorithm;

public abstract class AbsShadingAlgorithmDefaults
implements ShadingAlgorithm {
    private static final Logger LOGGER = Logger.getLogger(AbsShadingAlgorithmDefaults.class.getName());

    protected abstract byte[] convert(ByteBuffer var1, int var2, int var3, int var4, HgtCache.HgtFileInfo var5) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ShadingAlgorithm.RawShadingResult transformToByteBuffer(HgtCache.HgtFileInfo source, int padding) {
        int axisLength = this.getAxisLenght(source);
        int rowLen = axisLength + 1;
        InputStream stream = null;
        AbstractInterruptibleChannel channel = null;
        try {
            ByteBuffer map = null;
            File file = source.getFile();
            String nameLowerCase = file.getName().toLowerCase();
            if (nameLowerCase.endsWith(".zip")) {
                ZipEntry entry;
                ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
                String expectedNameLC = nameLowerCase.substring(0, nameLowerCase.length() - 4) + ".hgt";
                while (null != (entry = zipInputStream.getNextEntry())) {
                    int read;
                    if (!expectedNameLC.equals(entry.getName().toLowerCase())) continue;
                    map = ByteBuffer.allocate((int)entry.getSize());
                    int done = 0;
                    for (int todo = (int)entry.getSize(); todo > 0; todo -= read) {
                        read = zipInputStream.read(map.array(), done, todo);
                        if (read == 0) {
                            LOGGER.log(Level.SEVERE, "failed to read entire .hgt in " + file.getName() + " " + done + " of " + todo + " done");
                            ShadingAlgorithm.RawShadingResult rawShadingResult = null;
                            return rawShadingResult;
                        }
                        done += read;
                    }
                    map.order(ByteOrder.BIG_ENDIAN);
                    break;
                }
                if (map == null) {
                    LOGGER.log(Level.SEVERE, "no matching .hgt in " + file.getName());
                    ShadingAlgorithm.RawShadingResult rawShadingResult = null;
                    return rawShadingResult;
                }
            } else {
                FileInputStream fileInputStream = new FileInputStream(file);
                channel = fileInputStream.getChannel();
                stream = fileInputStream;
                map = ((FileChannel)channel).map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
                map.order(ByteOrder.BIG_ENDIAN);
            }
            byte[] bytes = this.convert(map, axisLength, rowLen, padding, source);
            ShadingAlgorithm.RawShadingResult rawShadingResult = new ShadingAlgorithm.RawShadingResult(bytes, axisLength, axisLength, padding);
            return rawShadingResult;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            ShadingAlgorithm.RawShadingResult rawShadingResult = null;
            return rawShadingResult;
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

