/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.datastore;

import java.util.ArrayList;
import java.util.List;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.Tile;
import org.mapsforge.map.datastore.MapDataStore;
import org.mapsforge.map.datastore.MapReadResult;

public class MultiMapDataStore
extends MapDataStore {
    private BoundingBox boundingBox;
    private final DataPolicy dataPolicy;
    private final List<MapDataStore> mapDatabases;
    private LatLong startPosition;
    private byte startZoomLevel;

    public MultiMapDataStore(DataPolicy dataPolicy) {
        this.dataPolicy = dataPolicy;
        this.mapDatabases = new ArrayList<MapDataStore>();
    }

    public void addMapDataStore(MapDataStore mapDataStore, boolean useStartZoomLevel, boolean useStartPosition) {
        if (this.mapDatabases.contains(mapDataStore)) {
            throw new IllegalArgumentException("Duplicate map database");
        }
        this.mapDatabases.add(mapDataStore);
        if (useStartZoomLevel) {
            this.startZoomLevel = mapDataStore.startZoomLevel();
        }
        if (useStartPosition) {
            this.startPosition = mapDataStore.startPosition();
        }
        this.boundingBox = null == this.boundingBox ? mapDataStore.boundingBox() : this.boundingBox.extendBoundingBox(mapDataStore.boundingBox());
    }

    @Override
    public BoundingBox boundingBox() {
        return this.boundingBox;
    }

    @Override
    public void close() {
        for (MapDataStore mdb : this.mapDatabases) {
            mdb.close();
        }
    }

    @Override
    public long getDataTimestamp(Tile tile) {
        switch (this.dataPolicy) {
            case RETURN_FIRST: {
                for (MapDataStore mdb : this.mapDatabases) {
                    if (!mdb.supportsTile(tile)) continue;
                    return mdb.getDataTimestamp(tile);
                }
                return 0L;
            }
            case RETURN_ALL: 
            case DEDUPLICATE: {
                long result = 0L;
                for (MapDataStore mdb : this.mapDatabases) {
                    if (!mdb.supportsTile(tile)) continue;
                    result = Math.max(result, mdb.getDataTimestamp(tile));
                }
                return result;
            }
        }
        throw new IllegalStateException("Invalid data policy for multi map database");
    }

    @Override
    public MapReadResult readLabels(Tile tile) {
        switch (this.dataPolicy) {
            case RETURN_FIRST: {
                for (MapDataStore mdb : this.mapDatabases) {
                    if (!mdb.supportsTile(tile)) continue;
                    return mdb.readLabels(tile);
                }
                return null;
            }
            case RETURN_ALL: {
                return this.readLabels(tile, false);
            }
            case DEDUPLICATE: {
                return this.readLabels(tile, true);
            }
        }
        throw new IllegalStateException("Invalid data policy for multi map database");
    }

    private MapReadResult readLabels(Tile tile, boolean deduplicate) {
        MapReadResult mapReadResult = new MapReadResult();
        for (MapDataStore mdb : this.mapDatabases) {
            boolean isWater;
            MapReadResult result;
            if (!mdb.supportsTile(tile) || (result = mdb.readLabels(tile)) == null) continue;
            mapReadResult.isWater = isWater = mapReadResult.isWater & result.isWater;
            mapReadResult.add(result, deduplicate);
        }
        return mapReadResult;
    }

    @Override
    public MapReadResult readLabels(Tile upperLeft, Tile lowerRight) {
        switch (this.dataPolicy) {
            case RETURN_FIRST: {
                for (MapDataStore mdb : this.mapDatabases) {
                    if (!mdb.supportsTile(upperLeft)) continue;
                    return mdb.readLabels(upperLeft, lowerRight);
                }
                return null;
            }
            case RETURN_ALL: {
                return this.readLabels(upperLeft, lowerRight, false);
            }
            case DEDUPLICATE: {
                return this.readLabels(upperLeft, lowerRight, true);
            }
        }
        throw new IllegalStateException("Invalid data policy for multi map database");
    }

    private MapReadResult readLabels(Tile upperLeft, Tile lowerRight, boolean deduplicate) {
        MapReadResult mapReadResult = new MapReadResult();
        for (MapDataStore mdb : this.mapDatabases) {
            boolean isWater;
            MapReadResult result;
            if (!mdb.supportsTile(upperLeft) || (result = mdb.readLabels(upperLeft, lowerRight)) == null) continue;
            mapReadResult.isWater = isWater = mapReadResult.isWater & result.isWater;
            mapReadResult.add(result, deduplicate);
        }
        return mapReadResult;
    }

    @Override
    public MapReadResult readMapData(Tile tile) {
        switch (this.dataPolicy) {
            case RETURN_FIRST: {
                for (MapDataStore mdb : this.mapDatabases) {
                    if (!mdb.supportsTile(tile)) continue;
                    return mdb.readMapData(tile);
                }
                return null;
            }
            case RETURN_ALL: {
                return this.readMapData(tile, false);
            }
            case DEDUPLICATE: {
                return this.readMapData(tile, true);
            }
        }
        throw new IllegalStateException("Invalid data policy for multi map database");
    }

    private MapReadResult readMapData(Tile tile, boolean deduplicate) {
        MapReadResult mapReadResult = new MapReadResult();
        for (MapDataStore mdb : this.mapDatabases) {
            boolean isWater;
            MapReadResult result;
            if (!mdb.supportsTile(tile) || (result = mdb.readMapData(tile)) == null) continue;
            mapReadResult.isWater = isWater = mapReadResult.isWater & result.isWater;
            mapReadResult.add(result, deduplicate);
        }
        return mapReadResult;
    }

    @Override
    public MapReadResult readMapData(Tile upperLeft, Tile lowerRight) {
        switch (this.dataPolicy) {
            case RETURN_FIRST: {
                for (MapDataStore mdb : this.mapDatabases) {
                    if (!mdb.supportsTile(upperLeft)) continue;
                    return mdb.readMapData(upperLeft, lowerRight);
                }
                return null;
            }
            case RETURN_ALL: {
                return this.readMapData(upperLeft, lowerRight, false);
            }
            case DEDUPLICATE: {
                return this.readMapData(upperLeft, lowerRight, true);
            }
        }
        throw new IllegalStateException("Invalid data policy for multi map database");
    }

    private MapReadResult readMapData(Tile upperLeft, Tile lowerRight, boolean deduplicate) {
        MapReadResult mapReadResult = new MapReadResult();
        for (MapDataStore mdb : this.mapDatabases) {
            boolean isWater;
            MapReadResult result;
            if (!mdb.supportsTile(upperLeft) || (result = mdb.readMapData(upperLeft, lowerRight)) == null) continue;
            mapReadResult.isWater = isWater = mapReadResult.isWater & result.isWater;
            mapReadResult.add(result, deduplicate);
        }
        return mapReadResult;
    }

    @Override
    public MapReadResult readPoiData(Tile tile) {
        switch (this.dataPolicy) {
            case RETURN_FIRST: {
                for (MapDataStore mdb : this.mapDatabases) {
                    if (!mdb.supportsTile(tile)) continue;
                    return mdb.readPoiData(tile);
                }
                return null;
            }
            case RETURN_ALL: {
                return this.readPoiData(tile, false);
            }
            case DEDUPLICATE: {
                return this.readPoiData(tile, true);
            }
        }
        throw new IllegalStateException("Invalid data policy for multi map database");
    }

    private MapReadResult readPoiData(Tile tile, boolean deduplicate) {
        MapReadResult mapReadResult = new MapReadResult();
        for (MapDataStore mdb : this.mapDatabases) {
            boolean isWater;
            MapReadResult result;
            if (!mdb.supportsTile(tile) || (result = mdb.readPoiData(tile)) == null) continue;
            mapReadResult.isWater = isWater = mapReadResult.isWater & result.isWater;
            mapReadResult.add(result, deduplicate);
        }
        return mapReadResult;
    }

    @Override
    public MapReadResult readPoiData(Tile upperLeft, Tile lowerRight) {
        switch (this.dataPolicy) {
            case RETURN_FIRST: {
                for (MapDataStore mdb : this.mapDatabases) {
                    if (!mdb.supportsTile(upperLeft)) continue;
                    return mdb.readPoiData(upperLeft, lowerRight);
                }
                return null;
            }
            case RETURN_ALL: {
                return this.readPoiData(upperLeft, lowerRight, false);
            }
            case DEDUPLICATE: {
                return this.readPoiData(upperLeft, lowerRight, true);
            }
        }
        throw new IllegalStateException("Invalid data policy for multi map database");
    }

    private MapReadResult readPoiData(Tile upperLeft, Tile lowerRight, boolean deduplicate) {
        MapReadResult mapReadResult = new MapReadResult();
        for (MapDataStore mdb : this.mapDatabases) {
            boolean isWater;
            MapReadResult result;
            if (!mdb.supportsTile(upperLeft) || (result = mdb.readPoiData(upperLeft, lowerRight)) == null) continue;
            mapReadResult.isWater = isWater = mapReadResult.isWater & result.isWater;
            mapReadResult.add(result, deduplicate);
        }
        return mapReadResult;
    }

    public void setStartPosition(LatLong startPosition) {
        this.startPosition = startPosition;
    }

    public void setStartZoomLevel(byte startZoomLevel) {
        this.startZoomLevel = startZoomLevel;
    }

    @Override
    public LatLong startPosition() {
        if (null != this.startPosition) {
            return this.startPosition;
        }
        if (null != this.boundingBox) {
            return this.boundingBox.getCenterPoint();
        }
        return null;
    }

    @Override
    public Byte startZoomLevel() {
        return this.startZoomLevel;
    }

    @Override
    public boolean supportsTile(Tile tile) {
        for (MapDataStore mdb : this.mapDatabases) {
            if (!mdb.supportsTile(tile)) continue;
            return true;
        }
        return false;
    }

    public static enum DataPolicy {
        RETURN_FIRST,
        RETURN_ALL,
        DEDUPLICATE;

    }
}

