/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.hills;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mapsforge.map.layer.hills.HgtCache;
import org.mapsforge.map.layer.hills.ShadingAlgorithm;

public abstract class AbsShadingAlgorithmDefaults
implements ShadingAlgorithm {
    private static final Logger LOGGER = Logger.getLogger(AbsShadingAlgorithmDefaults.class.getName());

    protected abstract byte[] convert(ByteBuffer var1, int var2, int var3, int var4, HgtCache.HgtFileInfo var5) throws IOException;

    @Override
    public ShadingAlgorithm.RawShadingResult transformToByteBuffer(HgtCache.HgtFileInfo source, int padding) {
        int axisLength = this.getAxisLenght(source);
        int rowLen = axisLength + 1;
        try {
            ByteBuffer map = source.getFile().asByteBuffer();
            byte[] bytes = this.convert(map, axisLength, rowLen, padding, source);
            return new ShadingAlgorithm.RawShadingResult(bytes, axisLength, axisLength, padding);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }
}

