/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.hills;

import java.util.concurrent.ExecutionException;
import org.mapsforge.core.graphics.HillshadingBitmap;
import org.mapsforge.map.layer.hills.ShadeTileSource;

public class HillsRenderConfig {
    private ShadeTileSource tileSource;
    private float maginuteScaleFactor = 1.0f;

    public HillsRenderConfig(ShadeTileSource tileSource) {
        this.tileSource = tileSource;
    }

    public HillsRenderConfig indexOnThread() {
        ShadeTileSource cache = this.tileSource;
        if (cache != null) {
            cache.applyConfiguration(true);
        }
        return this;
    }

    public HillshadingBitmap getShadingTile(int latitudeOfSouthWestCorner, int longituedOfSouthWestCorner, double pxPerLat, double pxPerLng) throws ExecutionException, InterruptedException {
        ShadeTileSource tileSource = this.tileSource;
        if (tileSource == null) {
            return null;
        }
        HillshadingBitmap ret = tileSource.getHillshadingBitmap(latitudeOfSouthWestCorner, longituedOfSouthWestCorner, pxPerLat, pxPerLng);
        if (ret == null && Math.abs(longituedOfSouthWestCorner) > 178) {
            int eastInt = longituedOfSouthWestCorner > 0 ? longituedOfSouthWestCorner - 180 : longituedOfSouthWestCorner + 180;
            ret = tileSource.getHillshadingBitmap(latitudeOfSouthWestCorner, eastInt, pxPerLat, pxPerLng);
        }
        return ret;
    }

    public float getMaginuteScaleFactor() {
        return this.maginuteScaleFactor;
    }

    public void setMaginuteScaleFactor(float maginuteScaleFactor) {
        this.maginuteScaleFactor = maginuteScaleFactor;
    }

    public ShadeTileSource getTileSource() {
        return this.tileSource;
    }

    public void setTileSource(ShadeTileSource tileSource) {
        this.tileSource = tileSource;
    }
}

