/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.overlay;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.FillRule;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.graphics.Path;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.util.LatLongUtils;
import org.mapsforge.core.util.MercatorProjection;
import org.mapsforge.map.layer.Layer;

public class Polygon
extends Layer {
    private BoundingBox boundingBox;
    private final GraphicFactory graphicFactory;
    private final boolean keepAligned;
    private final List<LatLong> latLongs = new CopyOnWriteArrayList<LatLong>();
    private List<List<LatLong>> holes;
    private Paint paintFill;
    private Paint paintStroke;

    public Polygon(Paint paintFill, Paint paintStroke, GraphicFactory graphicFactory) {
        this(paintFill, paintStroke, graphicFactory, false);
    }

    public Polygon(Paint paintFill, Paint paintStroke, GraphicFactory graphicFactory, boolean keepAligned) {
        this.keepAligned = keepAligned;
        this.paintFill = paintFill;
        this.paintStroke = paintStroke;
        this.graphicFactory = graphicFactory;
    }

    public synchronized void addPoint(LatLong point) {
        this.latLongs.add(point);
        this.updatePoints();
    }

    public synchronized void addPoints(List<LatLong> points) {
        this.latLongs.addAll(points);
        this.updatePoints();
    }

    public synchronized void addHole(List<LatLong> holePoints) {
        if (this.holes == null) {
            this.holes = new CopyOnWriteArrayList<List<LatLong>>();
        }
        this.holes.add(new CopyOnWriteArrayList<LatLong>(holePoints));
    }

    public synchronized void clear() {
        this.latLongs.clear();
        if (this.holes != null) {
            this.holes.clear();
        }
        this.updatePoints();
    }

    public synchronized boolean contains(LatLong tapLatLong) {
        boolean contains = LatLongUtils.contains(this.latLongs, (LatLong)tapLatLong);
        if (this.holes == null || !contains) {
            return contains;
        }
        for (List<LatLong> hole : this.holes) {
            if (!LatLongUtils.contains(hole, (LatLong)tapLatLong)) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized void draw(BoundingBox boundingBox, byte zoomLevel, Canvas canvas, Point topLeftPoint) {
        if (this.latLongs.size() < 2 || this.paintStroke == null && this.paintFill == null) {
            return;
        }
        if (this.boundingBox != null && !this.boundingBox.intersects(boundingBox)) {
            return;
        }
        Path path = this.graphicFactory.createPath();
        long mapSize = MercatorProjection.getMapSize((byte)zoomLevel, (int)this.displayModel.getTileSize());
        Polygon.addToPath(path, this.latLongs, mapSize, topLeftPoint);
        if (this.holes != null && !this.holes.isEmpty()) {
            path.setFillRule(FillRule.EVEN_ODD);
            for (List<LatLong> hole : this.holes) {
                Polygon.addToPath(path, hole, mapSize, topLeftPoint);
            }
        }
        if (this.paintStroke != null) {
            if (this.keepAligned) {
                this.paintStroke.setBitmapShaderShift(topLeftPoint);
            }
            canvas.drawPath(path, this.paintStroke);
        }
        if (this.paintFill != null) {
            if (this.keepAligned) {
                this.paintFill.setBitmapShaderShift(topLeftPoint);
            }
            canvas.drawPath(path, this.paintFill);
        }
    }

    private static void addToPath(Path path, List<LatLong> points, long mapSize, Point topLeftPoint) {
        Iterator<LatLong> iterator = points.iterator();
        LatLong latLong = iterator.next();
        float x = (float)(MercatorProjection.longitudeToPixelX((double)latLong.longitude, (long)mapSize) - topLeftPoint.x);
        float y = (float)(MercatorProjection.latitudeToPixelY((double)latLong.latitude, (long)mapSize) - topLeftPoint.y);
        path.moveTo(x, y);
        while (iterator.hasNext()) {
            latLong = iterator.next();
            x = (float)(MercatorProjection.longitudeToPixelX((double)latLong.longitude, (long)mapSize) - topLeftPoint.x);
            y = (float)(MercatorProjection.latitudeToPixelY((double)latLong.latitude, (long)mapSize) - topLeftPoint.y);
            path.lineTo(x, y);
        }
        path.close();
    }

    public List<LatLong> getLatLongs() {
        return this.latLongs;
    }

    public synchronized Paint getPaintFill() {
        return this.paintFill;
    }

    public synchronized Paint getPaintStroke() {
        return this.paintStroke;
    }

    public boolean isKeepAligned() {
        return this.keepAligned;
    }

    public synchronized void setPaintFill(Paint paintFill) {
        this.paintFill = paintFill;
    }

    public synchronized void setPaintStroke(Paint paintStroke) {
        this.paintStroke = paintStroke;
    }

    public synchronized void setPoints(List<LatLong> points) {
        this.latLongs.clear();
        this.latLongs.addAll(points);
        this.updatePoints();
    }

    private void updatePoints() {
        this.boundingBox = this.latLongs.isEmpty() ? null : new BoundingBox(this.latLongs);
    }
}

