/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.rendertheme;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.mapsforge.core.util.IOUtils;
import org.mapsforge.map.rendertheme.XmlThemeResourceProvider;

public class ZipXmlThemeResourceProvider
implements XmlThemeResourceProvider {
    private final Map<String, byte[]> files = new HashMap<String, byte[]>();
    private final List<String> xmlThemes = new ArrayList<String>();

    public ZipXmlThemeResourceProvider(ZipInputStream zipInputStream) throws IOException {
        this(zipInputStream, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipXmlThemeResourceProvider(ZipInputStream zipInputStream, int maxResourceSizeToCache) throws IOException {
        if (zipInputStream == null) {
            return;
        }
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory() || zipEntry.getSize() > (long)maxResourceSizeToCache) continue;
                byte[] entry = ZipXmlThemeResourceProvider.streamToBytes(zipInputStream, (int)zipEntry.getSize());
                String fileName = ZipXmlThemeResourceProvider.zipEntryName(zipEntry.getName());
                this.files.put(fileName, entry);
                if (!ZipXmlThemeResourceProvider.isXmlTheme(fileName)) continue;
                this.xmlThemes.add(fileName);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)zipInputStream);
        }
    }

    @Override
    public InputStream createInputStream(String relativePath, String source) {
        String sourceKey = source;
        if (sourceKey.startsWith("file:")) {
            sourceKey = sourceKey.substring("file:".length());
        }
        if (sourceKey.startsWith("/")) {
            sourceKey = sourceKey.substring(1);
        }
        if (relativePath != null) {
            if (relativePath.startsWith("/")) {
                relativePath = relativePath.substring(1);
            }
            if (relativePath.endsWith("/")) {
                relativePath = relativePath.substring(0, relativePath.length() - 1);
            }
            String string = sourceKey = relativePath.isEmpty() ? sourceKey : relativePath + "/" + sourceKey;
        }
        if (this.files.containsKey(sourceKey)) {
            return new ByteArrayInputStream(this.files.get(sourceKey));
        }
        return null;
    }

    public int getCount() {
        return this.files.size();
    }

    public List<String> getXmlThemes() {
        return this.xmlThemes;
    }

    private static boolean isXmlTheme(String fileName) {
        return fileName.toLowerCase(Locale.ROOT).endsWith(".xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> scanXmlThemes(ZipInputStream zipInputStream) throws IOException {
        if (zipInputStream == null) {
            return Collections.emptyList();
        }
        ArrayList<String> xmlThemes = new ArrayList<String>();
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String fileName;
                if (zipEntry.isDirectory() || !ZipXmlThemeResourceProvider.isXmlTheme(fileName = ZipXmlThemeResourceProvider.zipEntryName(zipEntry.getName()))) continue;
                xmlThemes.add(fileName);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)zipInputStream);
        }
        return xmlThemes;
    }

    private static byte[] streamToBytes(InputStream in, int size) throws IOException {
        int count;
        byte[] bytes = new byte[size];
        int offset = 0;
        while ((count = in.read(bytes, offset, size)) > 0) {
            size -= count;
            offset += count;
        }
        return bytes;
    }

    private static String zipEntryName(String name) {
        if (name.startsWith("/")) {
            return name.substring(1);
        }
        return name;
    }
}

