/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.util;

import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.Dimension;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.MapPosition;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.util.MercatorProjection;

public final class MapPositionUtil {
    public static BoundingBox getBoundingBox(MapPosition mapPosition, Dimension canvasDimension, int tileSize) {
        long mapSize = MercatorProjection.getMapSize((byte)mapPosition.zoomLevel, (int)tileSize);
        double pixelX = MercatorProjection.longitudeToPixelX((double)mapPosition.latLong.longitude, (long)mapSize);
        double pixelY = MercatorProjection.latitudeToPixelY((double)mapPosition.latLong.latitude, (long)mapSize);
        int halfCanvasWidth = canvasDimension.width / 2;
        int halfCanvasHeight = canvasDimension.height / 2;
        double pixelXMin = Math.max(0.0, pixelX - (double)halfCanvasWidth);
        double pixelYMin = Math.max(0.0, pixelY - (double)halfCanvasHeight);
        double pixelXMax = Math.min((double)mapSize, pixelX + (double)halfCanvasWidth);
        double pixelYMax = Math.min((double)mapSize, pixelY + (double)halfCanvasHeight);
        double minLatitude = MercatorProjection.pixelYToLatitude((double)pixelYMax, (long)mapSize);
        double minLongitude = MercatorProjection.pixelXToLongitude((double)pixelXMin, (long)mapSize);
        double maxLatitude = MercatorProjection.pixelYToLatitude((double)pixelYMin, (long)mapSize);
        double maxLongitude = MercatorProjection.pixelXToLongitude((double)pixelXMax, (long)mapSize);
        return new BoundingBox(minLatitude, minLongitude, maxLatitude, maxLongitude);
    }

    public static Point getTopLeftPoint(MapPosition mapPosition, Dimension canvasDimension, int tileSize) {
        LatLong centerPoint = mapPosition.latLong;
        int halfCanvasWidth = canvasDimension.width / 2;
        int halfCanvasHeight = canvasDimension.height / 2;
        long mapSize = MercatorProjection.getMapSize((byte)mapPosition.zoomLevel, (int)tileSize);
        double pixelX = Math.round(MercatorProjection.longitudeToPixelX((double)centerPoint.longitude, (long)mapSize));
        double pixelY = Math.round(MercatorProjection.latitudeToPixelY((double)centerPoint.latitude, (long)mapSize));
        return new Point((double)((long)pixelX - (long)halfCanvasWidth), (double)((long)pixelY - (long)halfCanvasHeight));
    }

    private MapPositionUtil() {
        throw new IllegalStateException();
    }
}

