/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.datastore;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mapsforge.map.datastore.PoiWayBundle;
import org.mapsforge.map.datastore.PointOfInterest;
import org.mapsforge.map.datastore.Way;

public class MapReadResult {
    private final Set<Integer> hashPois = new HashSet<Integer>();
    private final Set<Integer> hashWays = new HashSet<Integer>();
    public boolean isWater;
    public List<PointOfInterest> pointOfInterests = new ArrayList<PointOfInterest>();
    public List<Way> ways = new ArrayList<Way>();

    public void add(PoiWayBundle poiWayBundle) {
        this.pointOfInterests.addAll(poiWayBundle.pois);
        this.ways.addAll(poiWayBundle.ways);
    }

    public void add(MapReadResult other, boolean deduplicate) {
        if (deduplicate) {
            for (PointOfInterest poi : other.pointOfInterests) {
                if (!this.hashPois.add(poi.hashCode())) continue;
                this.pointOfInterests.add(poi);
            }
            for (Way way : other.ways) {
                if (!this.hashWays.add(way.hashCode())) continue;
                this.ways.add(way);
            }
        } else {
            this.pointOfInterests.addAll(other.pointOfInterests);
            this.ways.addAll(other.ways);
        }
    }
}

