/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.hills;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.mapsforge.core.util.IOUtils;
import org.mapsforge.map.layer.hills.AbsShadingAlgorithmDefaults;
import org.mapsforge.map.layer.hills.DemFile;

public class DemFileFS
implements DemFile {
    private static final Logger LOGGER = Logger.getLogger(AbsShadingAlgorithmDefaults.class.getName());
    private final File file;

    public DemFileFS(File file) {
        this.file = file;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public InputStream openInputStream() throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer tryZippedSingleHgt(String name, InputStream inputStream) throws IOException {
        ByteBuffer byteBuffer;
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry entry;
            zipInputStream = new ZipInputStream(inputStream);
            String nameLowerCase = name.toLowerCase();
            String expectedNameLC = nameLowerCase.substring(0, nameLowerCase.length() - 4) + ".hgt";
            while (null != (entry = zipInputStream.getNextEntry())) {
                if (!expectedNameLC.equals(entry.getName().toLowerCase())) continue;
                int todo = (int)entry.getSize();
                byteBuffer = DemFileFS.streamAsByteBuffer(name, zipInputStream, todo);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zipInputStream);
            throw throwable;
        }
        {
            IOUtils.closeQuietly((Closeable)zipInputStream);
            return byteBuffer;
        }
        IOUtils.closeQuietly((Closeable)zipInputStream);
        return null;
    }

    public static ByteBuffer streamAsByteBuffer(String name, InputStream stream, int todo) throws IOException {
        ByteBuffer map = ByteBuffer.allocate(todo);
        int done = 0;
        while (todo > 0) {
            int read = stream.read(map.array(), done, todo);
            if (read == 0) {
                LOGGER.log(Level.SEVERE, "failed to read entire .hgt in " + name + " " + done + " of " + todo + " done");
                return null;
            }
            done += read;
            todo -= read;
        }
        map.order(ByteOrder.BIG_ENDIAN);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer asByteBuffer() throws IOException {
        FileInputStream stream;
        FileChannel channel;
        block3: {
            ByteBuffer byteBuffer;
            channel = null;
            stream = null;
            try {
                String nameLowerCase = this.file.getName().toLowerCase();
                if (!nameLowerCase.endsWith(".zip")) break block3;
                byteBuffer = DemFileFS.tryZippedSingleHgt(this.file.getName(), new FileInputStream(this.file));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(channel);
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)channel);
            IOUtils.closeQuietly((Closeable)stream);
            return byteBuffer;
        }
        FileInputStream fileInputStream = new FileInputStream(this.file);
        channel = fileInputStream.getChannel();
        stream = fileInputStream;
        MappedByteBuffer map = channel.map(FileChannel.MapMode.READ_ONLY, 0L, this.file.length());
        map.order(ByteOrder.BIG_ENDIAN);
        MappedByteBuffer mappedByteBuffer = map;
        IOUtils.closeQuietly((Closeable)channel);
        IOUtils.closeQuietly((Closeable)stream);
        return mappedByteBuffer;
    }
}

