/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.hills;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.mapsforge.map.layer.hills.AbsShadingAlgorithmDefaults;
import org.mapsforge.map.layer.hills.HgtCache;

public class SimpleShadingAlgorithm
extends AbsShadingAlgorithmDefaults {
    private static final Logger LOGGER = Logger.getLogger(SimpleShadingAlgorithm.class.getName());
    public final double linearity;
    public final double scale;
    private byte[] lookup;
    private int lookupOffset;

    public SimpleShadingAlgorithm() {
        this(0.1, 0.666);
    }

    public SimpleShadingAlgorithm(double linearity, double scale) {
        this.linearity = Math.min(1.0, Math.max(0.0, linearity));
        this.scale = Math.max(0.0, scale);
    }

    private static short readNext(ByteBuffer din, short fallback) throws IOException {
        short read = din.getShort();
        if (read == Short.MIN_VALUE) {
            return fallback;
        }
        return read;
    }

    protected double exaggerate(double in) {
        double x = in * this.scale;
        x = Math.max(-128.0, Math.min(127.0, x));
        double ret = Math.sin(1.5707963267948966 * Math.sin(1.5707963267948966 * Math.sin(1.5707963267948966 * x / 128.0))) * 128.0 * (1.0 - this.linearity) + x * this.linearity;
        return ret;
    }

    @Override
    public int getAxisLenght(HgtCache.HgtFileInfo source) {
        long size = source.getSize();
        long elements = size / 2L;
        int rowLen = (int)Math.ceil(Math.sqrt(elements));
        if ((long)(rowLen * rowLen * 2) != size) {
            return 0;
        }
        return rowLen - 1;
    }

    @Override
    protected byte[] convert(ByteBuffer din, int axisLength, int rowLen, int padding, HgtCache.HgtFileInfo fileInfo) throws IOException {
        short[] ringbuffer = new short[rowLen];
        byte[] bytes = new byte[(axisLength + 2 * padding) * (axisLength + 2 * padding)];
        byte[] lookup = this.lookup;
        if (lookup == null) {
            this.fillLookup();
            lookup = this.lookup;
        }
        int outidx = (axisLength + 2 * padding) * padding + padding;
        int rbcur = 0;
        short last = 0;
        for (int col = 0; col < rowLen; ++col) {
            last = SimpleShadingAlgorithm.readNext(din, last);
            ringbuffer[rbcur++] = last;
        }
        for (int line = 1; line <= axisLength; ++line) {
            if (rbcur >= rowLen) {
                rbcur = 0;
            }
            short nw = ringbuffer[rbcur];
            short sw = SimpleShadingAlgorithm.readNext(din, nw);
            ringbuffer[rbcur++] = sw;
            for (int col = 1; col <= axisLength; ++col) {
                short ne = ringbuffer[rbcur];
                short se = SimpleShadingAlgorithm.readNext(din, ne);
                ringbuffer[rbcur++] = se;
                int noso = -(se - ne + (sw - nw));
                int eawe = -(ne - nw + (se - sw));
                noso = this.exaggerate(lookup, noso);
                eawe = this.exaggerate(lookup, eawe);
                int zeroIsFlat = noso + eawe;
                int intVal = Math.min(255, Math.max(0, zeroIsFlat + 127));
                int shade = intVal & 0xFF;
                bytes[outidx++] = (byte)shade;
                nw = ne;
                sw = se;
            }
            outidx += 2 * padding;
        }
        return bytes;
    }

    private byte exaggerate(byte[] lookup, int x) {
        return lookup[Math.max(0, Math.min(lookup.length - 1, x + this.lookupOffset))];
    }

    private void fillLookup() {
        double exaggerated;
        int highest;
        double exaggerate;
        double exaggerated2;
        int lowest;
        for (lowest = 0; lowest > -1024 && !((exaggerated2 = (double)Math.round(exaggerate = this.exaggerate(lowest))) <= -128.0) && !(exaggerated2 >= 127.0); --lowest) {
        }
        for (highest = 0; highest < 1024 && !((exaggerated = (double)Math.round(this.exaggerate(highest))) <= -128.0) && !(exaggerated >= 127.0); ++highest) {
        }
        int size = 1 + highest - lowest;
        byte[] nextLookup = new byte[size];
        int in = lowest;
        for (int i = 0; i < size; ++i) {
            byte exaggerated3;
            nextLookup[i] = exaggerated3 = (byte)Math.round(this.exaggerate(in));
            ++in;
        }
        this.lookup = nextLookup;
        this.lookupOffset = -lowest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleShadingAlgorithm that = (SimpleShadingAlgorithm)o;
        if (Double.compare(that.linearity, this.linearity) != 0) {
            return false;
        }
        return Double.compare(that.scale, this.scale) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.linearity);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.scale);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "SimpleShadingAlgorithm{linearity=" + this.linearity + ", scale=" + this.scale + '}';
    }
}

