/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.rendertheme.renderinstruction;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.Display;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.Position;
import org.mapsforge.core.graphics.SymbolOrientation;
import org.mapsforge.core.model.Rectangle;
import org.mapsforge.map.datastore.PointOfInterest;
import org.mapsforge.map.layer.renderer.PolylineContainer;
import org.mapsforge.map.model.DisplayModel;
import org.mapsforge.map.rendertheme.RenderCallback;
import org.mapsforge.map.rendertheme.RenderContext;
import org.mapsforge.map.rendertheme.XmlThemeResourceProvider;
import org.mapsforge.map.rendertheme.XmlUtils;
import org.mapsforge.map.rendertheme.renderinstruction.RenderInstruction;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LineSymbol
extends RenderInstruction {
    private static final float REPEAT_GAP_DEFAULT = 200.0f;
    private static final float REPEAT_START_DEFAULT = 30.0f;
    private Bitmap bitmap;
    private boolean bitmapInvalid;
    private Display display;
    private float dy;
    private final Map<Byte, Float> dyScaled;
    private Position position;
    private int priority;
    private final String relativePathPrefix;
    private boolean repeat;
    private float repeatGap;
    private float repeatStart;
    private final XmlThemeResourceProvider resourceProvider;
    private RenderInstruction.Scale scale = RenderInstruction.Scale.STROKE;
    private String src;
    private SymbolOrientation symbolOrientation;

    public LineSymbol(GraphicFactory graphicFactory, DisplayModel displayModel, String elementName, XmlPullParser pullParser, String relativePathPrefix, XmlThemeResourceProvider resourceProvider) throws IOException, XmlPullParserException {
        super(graphicFactory, displayModel);
        this.display = Display.IFSPACE;
        this.relativePathPrefix = relativePathPrefix;
        this.resourceProvider = resourceProvider;
        this.dyScaled = new HashMap<Byte, Float>();
        this.position = Position.BELOW_RIGHT;
        this.symbolOrientation = SymbolOrientation.LEFT;
        this.extractValues(elementName, pullParser);
    }

    @Override
    public void destroy() {
        if (this.bitmap != null) {
            this.bitmap.decrementRefCount();
        }
    }

    private void extractValues(String elementName, XmlPullParser pullParser) throws IOException, XmlPullParserException {
        this.repeatGap = 200.0f * this.displayModel.getScaleFactor();
        this.repeatStart = 30.0f * this.displayModel.getScaleFactor();
        for (int i = 0; i < pullParser.getAttributeCount(); ++i) {
            String name = pullParser.getAttributeName(i);
            String value = pullParser.getAttributeValue(i);
            if ("src".equals(name)) {
                this.src = value;
                continue;
            }
            if ("align-center".equals(name)) {
                boolean alignCenter = Boolean.parseBoolean(value);
                if (!alignCenter) continue;
                this.position = Position.CENTER;
                continue;
            }
            if ("cat".equals(name)) {
                this.category = value;
                continue;
            }
            if ("display".equals(name)) {
                this.display = Display.fromString((String)value);
                continue;
            }
            if ("dy".equals(name)) {
                this.dy = Float.parseFloat(value) * this.displayModel.getScaleFactor();
                continue;
            }
            if ("priority".equals(name)) {
                this.priority = Integer.parseInt(value);
                continue;
            }
            if ("repeat".equals(name)) {
                this.repeat = Boolean.parseBoolean(value);
                continue;
            }
            if ("repeat-gap".equals(name)) {
                this.repeatGap = Float.parseFloat(value) * this.displayModel.getScaleFactor();
                continue;
            }
            if ("repeat-start".equals(name)) {
                this.repeatStart = Float.parseFloat(value) * this.displayModel.getScaleFactor();
                continue;
            }
            if ("rotate".equals(name)) {
                if (Boolean.parseBoolean(value)) continue;
                this.symbolOrientation = SymbolOrientation.UP;
                continue;
            }
            if ("scale".equals(name)) {
                this.scale = this.scaleFromValue(value);
                continue;
            }
            if ("symbol-height".equals(name)) {
                this.height = (float)XmlUtils.parseNonNegativeInteger(name, value) * this.displayModel.getScaleFactor();
                continue;
            }
            if ("symbol-orientation".equals(name)) {
                this.symbolOrientation = SymbolOrientation.fromString((String)value);
                continue;
            }
            if ("symbol-percent".equals(name)) {
                this.percent = XmlUtils.parseNonNegativeInteger(name, value);
                continue;
            }
            if ("symbol-scaling".equals(name)) continue;
            if ("symbol-width".equals(name)) {
                this.width = (float)XmlUtils.parseNonNegativeInteger(name, value) * this.displayModel.getScaleFactor();
                continue;
            }
            if ("position".equals(name)) {
                this.position = Position.fromString((String)value);
                continue;
            }
            XmlUtils.logUnknownAttribute(elementName, name, value, i);
        }
    }

    @Override
    public void renderNode(RenderCallback renderCallback, RenderContext renderContext, PointOfInterest poi) {
    }

    @Override
    public void renderWay(RenderCallback renderCallback, RenderContext renderContext, PolylineContainer way) {
        Float dyScale;
        if (Display.NEVER == this.display) {
            return;
        }
        if (this.bitmap == null && !this.bitmapInvalid) {
            try {
                this.bitmap = this.createBitmap(this.relativePathPrefix, this.src, this.resourceProvider);
            }
            catch (IOException ioException) {
                this.bitmapInvalid = true;
            }
        }
        if ((dyScale = this.dyScaled.get(renderContext.rendererJob.tile.zoomLevel)) == null) {
            dyScale = Float.valueOf(this.dy);
        }
        if (this.bitmap != null) {
            Rectangle boundary = this.computeBoundary(this.bitmap.getWidth(), this.bitmap.getHeight(), this.position);
            renderCallback.renderWaySymbol(renderContext, this.display, this.priority, this.bitmap, dyScale.floatValue(), boundary, this.repeat, this.repeatGap, this.repeatStart, this.symbolOrientation, way);
        }
    }

    @Override
    public void scaleStrokeWidth(float scaleFactor, byte zoomLevel) {
        if (this.scale == RenderInstruction.Scale.NONE) {
            scaleFactor = 1.0f;
        }
        this.dyScaled.put(zoomLevel, Float.valueOf(this.dy * scaleFactor));
    }

    @Override
    public void scaleTextSize(float scaleFactor, byte zoomLevel) {
    }
}

