/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.scalebar;

import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.Cap;
import org.mapsforge.core.graphics.Color;
import org.mapsforge.core.graphics.FontFamily;
import org.mapsforge.core.graphics.FontStyle;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.graphics.Style;
import org.mapsforge.map.model.DisplayModel;
import org.mapsforge.map.model.IMapViewPosition;
import org.mapsforge.map.model.MapViewDimension;
import org.mapsforge.map.scalebar.DistanceUnitAdapter;
import org.mapsforge.map.scalebar.ImperialUnitAdapter;
import org.mapsforge.map.scalebar.MapScaleBar;

public class DefaultMapScaleBar
extends MapScaleBar {
    public static int BITMAP_HEIGHT = 40;
    public static int BITMAP_WIDTH = 120;
    public static final int DEFAULT_HORIZONTAL_MARGIN = 5;
    public static final int DEFAULT_VERTICAL_MARGIN = 0;
    public static final int SCALE_BAR_MARGIN = 10;
    public static final float STROKE_EXTERNAL = 4.0f;
    public static final float STROKE_INTERNAL = 2.0f;
    public static final int TEXT_MARGIN = 1;
    private ScaleBarMode scaleBarMode;
    private DistanceUnitAdapter secondaryDistanceUnitAdapter;
    protected final Paint paintScaleBar;
    protected final Paint paintScaleBarStroke;
    protected final Paint paintScaleText;
    protected final Paint paintScaleTextStroke;

    public DefaultMapScaleBar(IMapViewPosition mapViewPosition, MapViewDimension mapViewDimension, GraphicFactory graphicFactory, DisplayModel displayModel) {
        this(mapViewPosition, mapViewDimension, graphicFactory, displayModel, displayModel.getScaleFactor());
    }

    public DefaultMapScaleBar(IMapViewPosition mapViewPosition, MapViewDimension mapViewDimension, GraphicFactory graphicFactory, DisplayModel displayModel, float scale) {
        super(mapViewPosition, mapViewDimension, displayModel, graphicFactory, (int)((float)BITMAP_WIDTH * scale), (int)((float)BITMAP_HEIGHT * scale), scale);
        this.setMarginHorizontal((int)(5.0f * scale));
        this.setMarginVertical((int)(0.0f * scale));
        this.scaleBarMode = ScaleBarMode.BOTH;
        this.secondaryDistanceUnitAdapter = ImperialUnitAdapter.INSTANCE;
        this.paintScaleBar = this.createScaleBarPaint(Color.BLACK, 2.0f, Style.FILL);
        this.paintScaleBarStroke = this.createScaleBarPaint(Color.WHITE, 4.0f, Style.STROKE);
        this.paintScaleText = this.createTextPaint(Color.BLACK, 0.0f, Style.FILL);
        this.paintScaleTextStroke = this.createTextPaint(Color.WHITE, 2.0f, Style.STROKE);
    }

    public void setColor(int color) {
        this.paintScaleBar.setColor(color);
        this.paintScaleText.setColor(color);
    }

    public DistanceUnitAdapter getSecondaryDistanceUnitAdapter() {
        return this.secondaryDistanceUnitAdapter;
    }

    public void setSecondaryDistanceUnitAdapter(DistanceUnitAdapter distanceUnitAdapter) {
        if (distanceUnitAdapter == null) {
            throw new IllegalArgumentException("adapter must not be null");
        }
        this.secondaryDistanceUnitAdapter = distanceUnitAdapter;
        this.redrawNeeded = true;
    }

    public ScaleBarMode getScaleBarMode() {
        return this.scaleBarMode;
    }

    public void setScaleBarMode(ScaleBarMode scaleBarMode) {
        this.scaleBarMode = scaleBarMode;
        this.redrawNeeded = true;
    }

    private Paint createScaleBarPaint(Color color, float strokeWidth, Style style) {
        Paint paint = this.graphicFactory.createPaint();
        paint.setColor(color);
        paint.setStrokeWidth(strokeWidth * this.scale);
        paint.setStyle(style);
        paint.setStrokeCap(Cap.ROUND);
        return paint;
    }

    private Paint createTextPaint(Color color, float strokeWidth, Style style) {
        Paint paint = this.graphicFactory.createPaint();
        paint.setColor(color);
        paint.setStrokeWidth(strokeWidth * this.scale);
        paint.setStyle(style);
        paint.setTypeface(FontFamily.DEFAULT, FontStyle.BOLD);
        paint.setTextSize(12.0f * this.scale);
        return paint;
    }

    @Override
    protected void redraw(Canvas canvas) {
        canvas.fillColor(Color.TRANSPARENT);
        MapScaleBar.ScaleBarLengthAndValue lengthAndValue = this.calculateScaleBarLengthAndValue();
        MapScaleBar.ScaleBarLengthAndValue lengthAndValue2 = this.scaleBarMode == ScaleBarMode.BOTH ? this.calculateScaleBarLengthAndValue(this.secondaryDistanceUnitAdapter) : new MapScaleBar.ScaleBarLengthAndValue(0, 0);
        this.drawScaleBar(canvas, lengthAndValue.scaleBarLength, lengthAndValue2.scaleBarLength, this.paintScaleBarStroke, this.scale);
        this.drawScaleBar(canvas, lengthAndValue.scaleBarLength, lengthAndValue2.scaleBarLength, this.paintScaleBar, this.scale);
        String scaleText1 = this.distanceUnitAdapter.getScaleText(lengthAndValue.scaleBarValue);
        String scaleText2 = this.scaleBarMode == ScaleBarMode.BOTH ? this.secondaryDistanceUnitAdapter.getScaleText(lengthAndValue2.scaleBarValue) : "";
        this.drawScaleText(canvas, scaleText1, scaleText2, this.paintScaleTextStroke, this.scale);
        this.drawScaleText(canvas, scaleText1, scaleText2, this.paintScaleText, this.scale);
    }

    protected void drawScaleBar(Canvas canvas, int scaleBarLength1, int scaleBarLength2, Paint paint, float scale) {
        int maxScaleBarLength = Math.max(scaleBarLength1, scaleBarLength2);
        switch (this.scaleBarPosition) {
            case BOTTOM_CENTER: {
                if (scaleBarLength2 == 0) {
                    canvas.drawLine(Math.round((float)(canvas.getWidth() - maxScaleBarLength) * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale), Math.round((float)(canvas.getWidth() + maxScaleBarLength) * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                    canvas.drawLine(Math.round((float)(canvas.getWidth() - maxScaleBarLength) * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), Math.round((float)(canvas.getWidth() - maxScaleBarLength) * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                    canvas.drawLine(Math.round((float)(canvas.getWidth() + maxScaleBarLength) * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), Math.round((float)(canvas.getWidth() + maxScaleBarLength) * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                    break;
                }
                canvas.drawLine(Math.round(4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), Math.round(4.0f * scale * 0.5f + (float)maxScaleBarLength), Math.round((float)canvas.getHeight() * 0.5f), paint);
                canvas.drawLine(Math.round(4.0f * scale * 0.5f), Math.round(10.0f * scale), Math.round(4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                canvas.drawLine(Math.round(4.0f * scale * 0.5f + (float)scaleBarLength1), Math.round(10.0f * scale), Math.round(4.0f * scale * 0.5f + (float)scaleBarLength1), Math.round((float)canvas.getHeight() * 0.5f), paint);
                canvas.drawLine(Math.round(4.0f * scale * 0.5f + (float)scaleBarLength2), Math.round((float)canvas.getHeight() * 0.5f), Math.round(4.0f * scale * 0.5f + (float)scaleBarLength2), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                break;
            }
            case BOTTOM_LEFT: {
                if (scaleBarLength2 == 0) {
                    canvas.drawLine(Math.round(4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale), Math.round(4.0f * scale * 0.5f + (float)maxScaleBarLength), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                    canvas.drawLine(Math.round(4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), Math.round(4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                    canvas.drawLine(Math.round(4.0f * scale * 0.5f + (float)maxScaleBarLength), Math.round((float)canvas.getHeight() * 0.5f), Math.round(4.0f * scale * 0.5f + (float)maxScaleBarLength), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                    break;
                }
                canvas.drawLine(Math.round(4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), Math.round(4.0f * scale * 0.5f + (float)maxScaleBarLength), Math.round((float)canvas.getHeight() * 0.5f), paint);
                canvas.drawLine(Math.round(4.0f * scale * 0.5f), Math.round(10.0f * scale), Math.round(4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                canvas.drawLine(Math.round(4.0f * scale * 0.5f + (float)scaleBarLength1), Math.round(10.0f * scale), Math.round(4.0f * scale * 0.5f + (float)scaleBarLength1), Math.round((float)canvas.getHeight() * 0.5f), paint);
                canvas.drawLine(Math.round(4.0f * scale * 0.5f + (float)scaleBarLength2), Math.round((float)canvas.getHeight() * 0.5f), Math.round(4.0f * scale * 0.5f + (float)scaleBarLength2), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                break;
            }
            case BOTTOM_RIGHT: {
                if (scaleBarLength2 == 0) {
                    canvas.drawLine(Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)maxScaleBarLength), Math.round((float)canvas.getHeight() - 10.0f * scale), Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                    canvas.drawLine(Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                    canvas.drawLine(Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)maxScaleBarLength), Math.round((float)canvas.getHeight() * 0.5f), Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)maxScaleBarLength), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                    break;
                }
                canvas.drawLine(Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)maxScaleBarLength), Math.round((float)canvas.getHeight() * 0.5f), paint);
                canvas.drawLine(Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f), Math.round(10.0f * scale), Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                canvas.drawLine(Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)scaleBarLength1), Math.round(10.0f * scale), Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)scaleBarLength1), Math.round((float)canvas.getHeight() * 0.5f), paint);
                canvas.drawLine(Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)scaleBarLength2), Math.round((float)canvas.getHeight() * 0.5f), Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)scaleBarLength2), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                break;
            }
            case TOP_CENTER: {
                if (scaleBarLength2 == 0) {
                    canvas.drawLine(Math.round((float)(canvas.getWidth() - maxScaleBarLength) * 0.5f), Math.round(10.0f * scale), Math.round((float)(canvas.getWidth() + maxScaleBarLength) * 0.5f), Math.round(10.0f * scale), paint);
                    canvas.drawLine(Math.round((float)(canvas.getWidth() - maxScaleBarLength) * 0.5f), Math.round(10.0f * scale), Math.round((float)(canvas.getWidth() - maxScaleBarLength) * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), paint);
                    canvas.drawLine(Math.round((float)(canvas.getWidth() + maxScaleBarLength) * 0.5f), Math.round(10.0f * scale), Math.round((float)(canvas.getWidth() + maxScaleBarLength) * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), paint);
                    break;
                }
                canvas.drawLine(Math.round(4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), Math.round(4.0f * scale * 0.5f + (float)maxScaleBarLength), Math.round((float)canvas.getHeight() * 0.5f), paint);
                canvas.drawLine(Math.round(4.0f * scale * 0.5f), Math.round(10.0f * scale), Math.round(4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                canvas.drawLine(Math.round(4.0f * scale * 0.5f + (float)scaleBarLength1), Math.round(10.0f * scale), Math.round(4.0f * scale * 0.5f + (float)scaleBarLength1), Math.round((float)canvas.getHeight() * 0.5f), paint);
                canvas.drawLine(Math.round(4.0f * scale * 0.5f + (float)scaleBarLength2), Math.round((float)canvas.getHeight() * 0.5f), Math.round(4.0f * scale * 0.5f + (float)scaleBarLength2), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                break;
            }
            case TOP_LEFT: {
                if (scaleBarLength2 == 0) {
                    canvas.drawLine(Math.round(4.0f * scale * 0.5f), Math.round(10.0f * scale), Math.round(4.0f * scale * 0.5f + (float)maxScaleBarLength), Math.round(10.0f * scale), paint);
                    canvas.drawLine(Math.round(4.0f * scale * 0.5f), Math.round(10.0f * scale), Math.round(4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), paint);
                    canvas.drawLine(Math.round(4.0f * scale * 0.5f + (float)maxScaleBarLength), Math.round(10.0f * scale), Math.round(4.0f * scale * 0.5f + (float)maxScaleBarLength), Math.round((float)canvas.getHeight() * 0.5f), paint);
                    break;
                }
                canvas.drawLine(Math.round(4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), Math.round(4.0f * scale * 0.5f + (float)maxScaleBarLength), Math.round((float)canvas.getHeight() * 0.5f), paint);
                canvas.drawLine(Math.round(4.0f * scale * 0.5f), Math.round(10.0f * scale), Math.round(4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                canvas.drawLine(Math.round(4.0f * scale * 0.5f + (float)scaleBarLength1), Math.round(10.0f * scale), Math.round(4.0f * scale * 0.5f + (float)scaleBarLength1), Math.round((float)canvas.getHeight() * 0.5f), paint);
                canvas.drawLine(Math.round(4.0f * scale * 0.5f + (float)scaleBarLength2), Math.round((float)canvas.getHeight() * 0.5f), Math.round(4.0f * scale * 0.5f + (float)scaleBarLength2), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                break;
            }
            case TOP_RIGHT: {
                if (scaleBarLength2 == 0) {
                    canvas.drawLine(Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)maxScaleBarLength), Math.round(10.0f * scale), Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f), Math.round(10.0f * scale), paint);
                    canvas.drawLine(Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f), Math.round(10.0f * scale), Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), paint);
                    canvas.drawLine(Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)maxScaleBarLength), Math.round(10.0f * scale), Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)maxScaleBarLength), Math.round((float)canvas.getHeight() * 0.5f), paint);
                    break;
                }
                canvas.drawLine(Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() * 0.5f), Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)maxScaleBarLength), Math.round((float)canvas.getHeight() * 0.5f), paint);
                canvas.drawLine(Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f), Math.round(10.0f * scale), Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
                canvas.drawLine(Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)scaleBarLength1), Math.round(10.0f * scale), Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)scaleBarLength1), Math.round((float)canvas.getHeight() * 0.5f), paint);
                canvas.drawLine(Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)scaleBarLength2), Math.round((float)canvas.getHeight() * 0.5f), Math.round((float)canvas.getWidth() - 4.0f * scale * 0.5f - (float)scaleBarLength2), Math.round((float)canvas.getHeight() - 10.0f * scale), paint);
            }
        }
    }

    protected void drawScaleText(Canvas canvas, String scaleText1, String scaleText2, Paint paint, float scale) {
        switch (this.scaleBarPosition) {
            case BOTTOM_CENTER: {
                if (scaleText2.length() == 0) {
                    canvas.drawText(scaleText1, Math.round((float)(canvas.getWidth() - this.paintScaleTextStroke.getTextWidth(scaleText1)) * 0.5f), Math.round((float)canvas.getHeight() - 10.0f * scale - 4.0f * scale * 0.5f - 1.0f * scale), paint);
                    break;
                }
                canvas.drawText(scaleText1, Math.round(4.0f * scale + 1.0f * scale), Math.round((float)canvas.getHeight() * 0.5f - 4.0f * scale * 0.5f - 1.0f * scale), paint);
                canvas.drawText(scaleText2, Math.round(4.0f * scale + 1.0f * scale), Math.round((float)canvas.getHeight() * 0.5f + 4.0f * scale * 0.5f + 1.0f * scale + (float)this.paintScaleTextStroke.getTextHeight(scaleText2)), paint);
                break;
            }
            case BOTTOM_LEFT: {
                if (scaleText2.length() == 0) {
                    canvas.drawText(scaleText1, Math.round(4.0f * scale + 1.0f * scale), Math.round((float)canvas.getHeight() - 10.0f * scale - 4.0f * scale * 0.5f - 1.0f * scale), paint);
                    break;
                }
                canvas.drawText(scaleText1, Math.round(4.0f * scale + 1.0f * scale), Math.round((float)canvas.getHeight() * 0.5f - 4.0f * scale * 0.5f - 1.0f * scale), paint);
                canvas.drawText(scaleText2, Math.round(4.0f * scale + 1.0f * scale), Math.round((float)canvas.getHeight() * 0.5f + 4.0f * scale * 0.5f + 1.0f * scale + (float)this.paintScaleTextStroke.getTextHeight(scaleText2)), paint);
                break;
            }
            case BOTTOM_RIGHT: {
                if (scaleText2.length() == 0) {
                    canvas.drawText(scaleText1, Math.round((float)canvas.getWidth() - 4.0f * scale - 1.0f * scale - (float)this.paintScaleTextStroke.getTextWidth(scaleText1)), Math.round((float)canvas.getHeight() - 10.0f * scale - 4.0f * scale * 0.5f - 1.0f * scale), paint);
                    break;
                }
                canvas.drawText(scaleText1, Math.round((float)canvas.getWidth() - 4.0f * scale - 1.0f * scale - (float)this.paintScaleTextStroke.getTextWidth(scaleText1)), Math.round((float)canvas.getHeight() * 0.5f - 4.0f * scale * 0.5f - 1.0f * scale), paint);
                canvas.drawText(scaleText2, Math.round((float)canvas.getWidth() - 4.0f * scale - 1.0f * scale - (float)this.paintScaleTextStroke.getTextWidth(scaleText2)), Math.round((float)canvas.getHeight() * 0.5f + 4.0f * scale * 0.5f + 1.0f * scale + (float)this.paintScaleTextStroke.getTextHeight(scaleText2)), paint);
                break;
            }
            case TOP_CENTER: {
                if (scaleText2.length() == 0) {
                    canvas.drawText(scaleText1, Math.round((float)(canvas.getWidth() - this.paintScaleTextStroke.getTextWidth(scaleText1)) * 0.5f), Math.round(10.0f * scale + 4.0f * scale * 0.5f + 1.0f * scale + (float)this.paintScaleTextStroke.getTextHeight(scaleText1)), paint);
                    break;
                }
                canvas.drawText(scaleText1, Math.round(4.0f * scale + 1.0f * scale), Math.round((float)canvas.getHeight() * 0.5f - 4.0f * scale * 0.5f - 1.0f * scale), paint);
                canvas.drawText(scaleText2, Math.round(4.0f * scale + 1.0f * scale), Math.round((float)canvas.getHeight() * 0.5f + 4.0f * scale * 0.5f + 1.0f * scale + (float)this.paintScaleTextStroke.getTextHeight(scaleText2)), paint);
                break;
            }
            case TOP_LEFT: {
                if (scaleText2.length() == 0) {
                    canvas.drawText(scaleText1, Math.round(4.0f * scale + 1.0f * scale), Math.round(10.0f * scale + 4.0f * scale * 0.5f + 1.0f * scale + (float)this.paintScaleTextStroke.getTextHeight(scaleText1)), paint);
                    break;
                }
                canvas.drawText(scaleText1, Math.round(4.0f * scale + 1.0f * scale), Math.round((float)canvas.getHeight() * 0.5f - 4.0f * scale * 0.5f - 1.0f * scale), paint);
                canvas.drawText(scaleText2, Math.round(4.0f * scale + 1.0f * scale), Math.round((float)canvas.getHeight() * 0.5f + 4.0f * scale * 0.5f + 1.0f * scale + (float)this.paintScaleTextStroke.getTextHeight(scaleText2)), paint);
                break;
            }
            case TOP_RIGHT: {
                if (scaleText2.length() == 0) {
                    canvas.drawText(scaleText1, Math.round((float)canvas.getWidth() - 4.0f * scale - 1.0f * scale - (float)this.paintScaleTextStroke.getTextWidth(scaleText1)), Math.round(10.0f * scale + 4.0f * scale * 0.5f + 1.0f * scale + (float)this.paintScaleTextStroke.getTextHeight(scaleText1)), paint);
                    break;
                }
                canvas.drawText(scaleText1, Math.round((float)canvas.getWidth() - 4.0f * scale - 1.0f * scale - (float)this.paintScaleTextStroke.getTextWidth(scaleText1)), Math.round((float)canvas.getHeight() * 0.5f - 4.0f * scale * 0.5f - 1.0f * scale), paint);
                canvas.drawText(scaleText2, Math.round((float)canvas.getWidth() - 4.0f * scale - 1.0f * scale - (float)this.paintScaleTextStroke.getTextWidth(scaleText2)), Math.round((float)canvas.getHeight() * 0.5f + 4.0f * scale * 0.5f + 1.0f * scale + (float)this.paintScaleTextStroke.getTextHeight(scaleText2)), paint);
            }
        }
    }

    public static enum ScaleBarMode {
        BOTH,
        SINGLE;

    }
}

