/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.view;

import java.util.logging.Logger;
import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.model.Dimension;

class FrameBufferBitmapHA3 {
    private static final Logger LOGGER = Logger.getLogger(FrameBufferBitmapHA3.class.getName());
    private Bitmap bitmap = null;
    private BitmapRequest bitmapRequest = null;
    private final Object bitmapRequestSync = new Object();
    private final Lock frameLock = new Lock();

    FrameBufferBitmapHA3() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void create(GraphicFactory factory, Dimension dimension, int color, boolean isTransparent) {
        Lock lock = this.frameLock;
        synchronized (lock) {
            if (!this.frameLock.isHardLocked()) {
                Object object = this.bitmapRequestSync;
                synchronized (object) {
                    this.bitmapRequest = new BitmapRequest(factory, dimension, color, isTransparent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBitmapIfRequested() {
        Object object = this.bitmapRequestSync;
        synchronized (object) {
            if (this.bitmapRequest != null) {
                this.destroyBitmap();
                this.bitmap = this.bitmapRequest.create();
                this.bitmapRequest = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        Lock lock = this.frameLock;
        synchronized (lock) {
            if (this.bitmap != null) {
                this.destroyBitmap();
                this.frameLock.hardLock();
            }
        }
    }

    private void destroyBitmap() {
        if (this.bitmap != null) {
            this.bitmap.decrementRefCount();
            this.bitmap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bitmap lock() {
        Lock lock = this.frameLock;
        synchronized (lock) {
            if (this.frameLock.isUnlocked()) {
                this.createBitmapIfRequested();
                if (this.bitmap != null) {
                    this.frameLock.lock();
                }
            }
            return this.bitmap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release() {
        Lock lock = this.frameLock;
        synchronized (lock) {
            this.frameLock.unlock();
        }
    }

    static void swap(FrameBufferBitmapHA3 a, FrameBufferBitmapHA3 b) {
        Bitmap t = a.bitmap;
        a.bitmap = b.bitmap;
        b.bitmap = t;
        BitmapRequest r = a.bitmapRequest;
        a.bitmapRequest = b.bitmapRequest;
        b.bitmapRequest = r;
    }

    private static class BitmapRequest {
        private final GraphicFactory factory;
        private final Dimension dimension;
        private final int color;
        private final boolean isTransparent;

        BitmapRequest(GraphicFactory factory, Dimension dimension, int color, boolean isTransparent) {
            this.factory = factory;
            this.dimension = dimension;
            this.color = color;
            this.isTransparent = isTransparent;
        }

        Bitmap create() {
            if (this.dimension.width > 0 && this.dimension.height > 0) {
                Bitmap bitmap = this.factory.createBitmap(this.dimension.width, this.dimension.height, this.isTransparent);
                bitmap.setBackgroundColor(this.color);
                return bitmap;
            }
            return null;
        }
    }

    static class Lock {
        private static final int HARD_LOCKED = -1;
        private static final int SOFT_LOCKED = 1;
        private static final int UNLOCKED = 0;
        private int state = 0;

        Lock() {
        }

        synchronized void hardLock() {
            this.state = -1;
            this.notifyAll();
        }

        synchronized boolean isHardLocked() {
            return this.state == -1;
        }

        synchronized boolean isSoftLocked() {
            return this.state == 1;
        }

        synchronized boolean isUnlocked() {
            return this.state == 0;
        }

        synchronized void lock() {
            if (this.state == 0) {
                this.state = 1;
            }
        }

        synchronized void unlock() {
            if (this.state == 1) {
                this.state = 0;
            }
            this.notifyAll();
        }

        synchronized void waitUntilUnlocked() {
            try {
                while (this.state == 1) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                LOGGER.fine("Frame buffer interrupted");
            }
        }
    }
}

