/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.view;

import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.GraphicContext;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.Matrix;
import org.mapsforge.core.model.Dimension;
import org.mapsforge.core.model.MapPosition;
import org.mapsforge.core.model.Point;
import org.mapsforge.map.model.DisplayModel;
import org.mapsforge.map.model.FrameBufferModel;
import org.mapsforge.map.view.FrameBuffer;
import org.mapsforge.map.view.FrameBufferBitmapHA3;

public class FrameBufferHA3
extends FrameBuffer {
    private static final boolean IS_TRANSPARENT = false;
    private final FrameBufferBitmapHA3 lmBitmap = new FrameBufferBitmapHA3();
    private final FrameBufferBitmapHA3 odBitmap = new FrameBufferBitmapHA3();
    private Dimension dimension;
    private final DisplayModel displayModel;
    private final FrameBufferModel frameBufferModel;
    private final GraphicFactory graphicFactory;
    private final Matrix matrix;
    private final FrameBufferBitmapHA3.Lock framesLock = new FrameBufferBitmapHA3.Lock();
    private MapPosition lmMapPosition;

    public FrameBufferHA3(FrameBufferModel frameBufferModel, DisplayModel displayModel, GraphicFactory graphicFactory) {
        this.frameBufferModel = frameBufferModel;
        this.displayModel = displayModel;
        this.graphicFactory = graphicFactory;
        this.matrix = graphicFactory.createMatrix();
        this.framesLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustMatrix(float diffX, float diffY, float scaleFactor, Dimension mapViewDimension, float pivotDistanceX, float pivotDistanceY) {
        Matrix matrix = this.matrix;
        synchronized (matrix) {
            if (this.dimension == null) {
                return;
            }
            this.matrix.reset();
            this.centerFrameBufferToMapView(mapViewDimension);
            if (pivotDistanceX == 0.0f && pivotDistanceY == 0.0f) {
                this.matrix.translate(diffX, diffY);
            }
            this.scale(scaleFactor, pivotDistanceX, pivotDistanceY);
        }
    }

    private void centerFrameBufferToMapView(Dimension mapViewDimension) {
        float dx = (float)(this.dimension.width - mapViewDimension.width) / -2.0f;
        float dy = (float)(this.dimension.height - mapViewDimension.height) / -2.0f;
        this.matrix.translate(dx, dy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void destroy() {
        FrameBufferBitmapHA3.Lock lock = this.framesLock;
        synchronized (lock) {
            this.odBitmap.destroy();
            this.lmBitmap.destroy();
            this.framesLock.hardLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(GraphicContext graphicContext) {
        graphicContext.fillColor(this.displayModel.getBackgroundColor());
        this.swapBitmaps();
        Matrix matrix = this.matrix;
        synchronized (matrix) {
            Bitmap b = this.odBitmap.lock();
            if (b != null) {
                graphicContext.drawBitmap(b, this.matrix);
            }
        }
        this.odBitmap.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void frameFinished(MapPosition framePosition) {
        FrameBufferBitmapHA3.Lock lock = this.framesLock;
        synchronized (lock) {
            this.lmMapPosition = framePosition;
            this.lmBitmap.release();
            this.framesLock.lock();
        }
    }

    @Override
    public synchronized Dimension getDimension() {
        return this.dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap getDrawingBitmap() {
        FrameBufferBitmapHA3.Lock lock = this.framesLock;
        synchronized (lock) {
            this.framesLock.waitUntilUnlocked();
            Bitmap b = this.lmBitmap.lock();
            if (b != null) {
                b.setBackgroundColor(this.displayModel.getBackgroundColor());
            }
            return b;
        }
    }

    private void scale(float scaleFactor, float pivotDistanceX, float pivotDistanceY) {
        if (scaleFactor != 1.0f) {
            Point center = this.dimension.getCenter();
            float pivotX = (float)((double)pivotDistanceX + center.x);
            float pivotY = (float)((double)pivotDistanceY + center.y);
            this.matrix.scale(scaleFactor, scaleFactor, pivotX, pivotY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDimension(Dimension dimension) {
        Object object = this.matrix;
        synchronized (object) {
            if (this.dimension != null && this.dimension.equals((Object)dimension)) {
                return;
            }
            this.dimension = dimension;
        }
        object = this.framesLock;
        synchronized (object) {
            this.odBitmap.create(this.graphicFactory, dimension, this.displayModel.getBackgroundColor(), false);
            this.lmBitmap.create(this.graphicFactory, dimension, this.displayModel.getBackgroundColor(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swapBitmaps() {
        FrameBufferBitmapHA3.Lock lock = this.framesLock;
        synchronized (lock) {
            if (this.framesLock.isSoftLocked()) {
                FrameBufferBitmapHA3.swap(this.odBitmap, this.lmBitmap);
                this.frameBufferModel.setMapPosition(this.lmMapPosition);
                this.framesLock.unlock();
            }
        }
    }
}

