/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.gdx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import java.util.Arrays;
import org.oscim.event.MotionEvent;
import org.oscim.map.Map;

public class MotionHandler
extends MotionEvent
implements InputProcessor {
    private final Map mMap;
    int mPointerDown;
    long mDownTime;
    int mType;
    int mPointer;
    int mCurX;
    int mCurY;
    int[] mPointerX = new int[10];
    int[] mPointerY = new int[10];
    long mTime = System.currentTimeMillis();

    public MotionHandler(Map map) {
        this.mMap = map;
    }

    public int getAction() {
        return this.mType;
    }

    public float getX() {
        return this.mCurX;
    }

    public float getY() {
        return this.mCurY;
    }

    public float getX(int idx) {
        if (idx >= 10) {
            return 0.0f;
        }
        return this.mPointerX[idx];
    }

    public float getY(int idx) {
        if (idx >= 10) {
            return 0.0f;
        }
        return this.mPointerY[idx];
    }

    public int getPointerCount() {
        return this.mPointerDown;
    }

    public MotionEvent copy() {
        MotionHandler handler = new MotionHandler(this.mMap);
        handler.mPointerDown = this.mPointerDown;
        handler.mDownTime = this.mDownTime;
        handler.mType = this.mType;
        handler.mPointer = this.mPointer;
        handler.mCurX = this.mCurX;
        handler.mCurY = this.mCurY;
        handler.mPointerX = Arrays.copyOf(this.mPointerX, 10);
        handler.mPointerY = Arrays.copyOf(this.mPointerY, 10);
        handler.mTime = this.mTime;
        return handler;
    }

    public void recycle() {
    }

    public long getTime() {
        return (long)((double)this.mTime / 1000000.0);
    }

    public boolean keyDown(int keycode) {
        return false;
    }

    public boolean keyUp(int keycode) {
        return false;
    }

    public boolean keyTyped(char character) {
        return false;
    }

    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        if (pointer >= 10) {
            return true;
        }
        if (button != 0) {
            return false;
        }
        this.mTime = Gdx.input.getCurrentEventTime();
        if (this.mPointerDown++ == 0) {
            this.mDownTime = this.getTime();
            this.mType = 0;
        } else {
            this.mType = 5;
        }
        this.mPointerX[pointer] = this.mCurX = screenX;
        this.mPointerY[pointer] = this.mCurY = screenY;
        this.mPointer = pointer;
        this.mMap.input.fire(null, (Object)this);
        return true;
    }

    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        if (pointer >= 10) {
            return true;
        }
        if (button != 0) {
            return false;
        }
        if (this.mPointerDown == 0) {
            return true;
        }
        this.mTime = Gdx.input.getCurrentEventTime();
        this.mType = --this.mPointerDown == 0 ? 1 : 6;
        this.mPointerX[pointer] = this.mCurX = screenX;
        this.mPointerY[pointer] = this.mCurY = screenY;
        this.mPointer = pointer;
        this.mMap.input.fire(null, (Object)this);
        return true;
    }

    public boolean touchDragged(int screenX, int screenY, int pointer) {
        if (pointer >= 10) {
            return true;
        }
        this.mTime = Gdx.input.getCurrentEventTime();
        this.mType = 2;
        this.mPointerX[pointer] = this.mCurX = screenX;
        this.mPointerY[pointer] = this.mCurY = screenY;
        this.mPointer = pointer;
        this.mMap.input.fire(null, (Object)this);
        return true;
    }

    public boolean mouseMoved(int screenX, int screenY) {
        this.mTime = Gdx.input.getCurrentEventTime();
        this.mType = 2;
        this.mPointerX[0] = this.mCurX = screenX;
        this.mPointerY[0] = this.mCurY = screenY;
        this.mPointer = 0;
        this.mMap.input.fire(null, (Object)this);
        return true;
    }

    public boolean scrolled(float amountX, float amountY) {
        this.mTime = Gdx.input.getCurrentEventTime();
        return false;
    }
}

