/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.extensions.spring.converter;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.mapstruct.extensions.spring.converter.ConversionServiceAdapterDescriptor;

public class ConversionServiceAdapterGenerator {
    private static final String CONVERSION_SERVICE_PACKAGE_NAME = "org.springframework.core.convert";
    private static final String CONVERSION_SERVICE_CLASS_NAME = "ConversionService";
    private static final String CONVERSION_SERVICE_FIELD_NAME = "conversionService";
    private static final String QUALIFIER_ANNOTATION_PACKAGE_NAME = "org.springframework.beans.factory.annotation";
    private static final String QUALIFIER_ANNOTATION_CLASSS_NAME = "Qualifier";
    private static final String LAZY_ANNOTATION_PACKAGE_NAME = "org.springframework.context.annotation";
    private static final String LAZY_ANNOTATION_CLASS_NAME = "Lazy";
    private final Clock clock;

    public ConversionServiceAdapterGenerator(Clock clock) {
        this.clock = clock;
    }

    public void writeConversionServiceAdapter(ConversionServiceAdapterDescriptor descriptor, Writer out) {
        try {
            JavaFile.builder((String)descriptor.getAdapterClassName().packageName(), (TypeSpec)this.createConversionServiceTypeSpec(descriptor)).build().writeTo((Appendable)out);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private TypeSpec createConversionServiceTypeSpec(ConversionServiceAdapterDescriptor descriptor) {
        FieldSpec conversionServiceFieldSpec = ConversionServiceAdapterGenerator.buildConversionServiceFieldSpec();
        TypeSpec.Builder adapterClassTypeSpec = TypeSpec.classBuilder((ClassName)descriptor.getAdapterClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        Optional.ofNullable(this.buildGeneratedAnnotationSpec(descriptor)).ifPresent(arg_0 -> ((TypeSpec.Builder)adapterClassTypeSpec).addAnnotation(arg_0));
        return adapterClassTypeSpec.addAnnotation(ClassName.get((String)"org.springframework.stereotype", (String)"Component", (String[])new String[0])).addField(conversionServiceFieldSpec).addMethod(ConversionServiceAdapterGenerator.buildConstructorSpec(descriptor, conversionServiceFieldSpec)).addMethods(ConversionServiceAdapterGenerator.buildMappingMethods(descriptor, conversionServiceFieldSpec)).build();
    }

    private static MethodSpec buildConstructorSpec(ConversionServiceAdapterDescriptor descriptor, FieldSpec conversionServiceFieldSpec) {
        ParameterSpec constructorParameterSpec = ConversionServiceAdapterGenerator.buildConstructorParameterSpec(descriptor, conversionServiceFieldSpec);
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(constructorParameterSpec).addStatement("this.$N = $N", new Object[]{conversionServiceFieldSpec, constructorParameterSpec}).build();
    }

    private static ParameterSpec buildConstructorParameterSpec(ConversionServiceAdapterDescriptor descriptor, FieldSpec conversionServiceFieldSpec) {
        ParameterSpec.Builder parameterBuilder = ParameterSpec.builder((TypeName)conversionServiceFieldSpec.type, (String)conversionServiceFieldSpec.name, (Modifier[])new Modifier[]{Modifier.FINAL});
        if (StringUtils.isNotEmpty((CharSequence)descriptor.getConversionServiceBeanName())) {
            parameterBuilder.addAnnotation(ConversionServiceAdapterGenerator.buildQualifierAnnotation(descriptor));
        }
        if (Boolean.TRUE.equals(descriptor.isLazyAnnotatedConversionServiceBean())) {
            parameterBuilder.addAnnotation(ConversionServiceAdapterGenerator.buildLazyAnnotation());
        }
        return parameterBuilder.build();
    }

    private static AnnotationSpec buildQualifierAnnotation(ConversionServiceAdapterDescriptor descriptor) {
        return AnnotationSpec.builder((ClassName)ClassName.get((String)QUALIFIER_ANNOTATION_PACKAGE_NAME, (String)QUALIFIER_ANNOTATION_CLASSS_NAME, (String[])new String[0])).addMember("value", "$S", new Object[]{descriptor.getConversionServiceBeanName()}).build();
    }

    private static AnnotationSpec buildLazyAnnotation() {
        return AnnotationSpec.builder((ClassName)ClassName.get((String)LAZY_ANNOTATION_PACKAGE_NAME, (String)LAZY_ANNOTATION_CLASS_NAME, (String[])new String[0])).build();
    }

    private static String simpleName(TypeName typeName) {
        TypeName rawType = ConversionServiceAdapterGenerator.rawType(typeName);
        if (rawType instanceof ArrayTypeName) {
            return ConversionServiceAdapterGenerator.arraySimpleName((ArrayTypeName)rawType);
        }
        if (rawType instanceof ClassName) {
            return ((ClassName)rawType).simpleName();
        }
        return String.valueOf(typeName);
    }

    private static String arraySimpleName(ArrayTypeName arrayTypeName) {
        return "ArrayOf" + (arrayTypeName.componentType instanceof ArrayTypeName ? ConversionServiceAdapterGenerator.arraySimpleName((ArrayTypeName)arrayTypeName.componentType) : arrayTypeName.componentType);
    }

    private static TypeName rawType(TypeName typeName) {
        if (typeName instanceof ParameterizedTypeName) {
            return ((ParameterizedTypeName)typeName).rawType;
        }
        return typeName;
    }

    private static Iterable<MethodSpec> buildMappingMethods(ConversionServiceAdapterDescriptor descriptor, FieldSpec injectedConversionServiceFieldSpec) {
        return descriptor.getFromToMappings().stream().map(sourceTargetPair -> ConversionServiceAdapterGenerator.toMappingMethodSpec(injectedConversionServiceFieldSpec, (Pair<TypeName, TypeName>)sourceTargetPair)).collect(Collectors.toList());
    }

    private static MethodSpec toMappingMethodSpec(FieldSpec injectedConversionServiceFieldSpec, Pair<TypeName, TypeName> sourceTargetPair) {
        ParameterSpec sourceParameterSpec = ConversionServiceAdapterGenerator.buildSourceParameterSpec((TypeName)sourceTargetPair.getLeft());
        return MethodSpec.methodBuilder((String)String.format("map%sTo%s", ConversionServiceAdapterGenerator.simpleName((TypeName)sourceTargetPair.getLeft()), ConversionServiceAdapterGenerator.simpleName((TypeName)sourceTargetPair.getRight()))).addParameter(sourceParameterSpec).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)sourceTargetPair.getRight()).addStatement("return $N.convert($N, $T.class)", new Object[]{injectedConversionServiceFieldSpec, sourceParameterSpec, ConversionServiceAdapterGenerator.rawType((TypeName)sourceTargetPair.getRight())}).build();
    }

    private static ParameterSpec buildSourceParameterSpec(TypeName sourceClassName) {
        return ParameterSpec.builder((TypeName)sourceClassName, (String)"source", (Modifier[])new Modifier[]{Modifier.FINAL}).build();
    }

    private static FieldSpec buildConversionServiceFieldSpec() {
        return FieldSpec.builder((TypeName)ClassName.get((String)CONVERSION_SERVICE_PACKAGE_NAME, (String)CONVERSION_SERVICE_CLASS_NAME, (String[])new String[0]), (String)CONVERSION_SERVICE_FIELD_NAME, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    private AnnotationSpec buildGeneratedAnnotationSpec(ConversionServiceAdapterDescriptor descriptor) {
        AnnotationSpec.Builder builder = descriptor.isSourceVersionAtLeast9() && ConversionServiceAdapterGenerator.isTypeAvailable(descriptor, "javax.annotation.processing.Generated") ? AnnotationSpec.builder((ClassName)ClassName.get((String)"javax.annotation.processing", (String)"Generated", (String[])new String[0])) : (ConversionServiceAdapterGenerator.isTypeAvailable(descriptor, "javax.annotation.Generated") ? AnnotationSpec.builder((ClassName)ClassName.get((String)"javax.annotation", (String)"Generated", (String[])new String[0])) : null);
        return Optional.ofNullable(builder).map(build -> build.addMember("value", "$S", new Object[]{ConversionServiceAdapterGenerator.class.getName()})).map(build -> build.addMember("date", "$S", new Object[]{DateTimeFormatter.ISO_INSTANT.format(ZonedDateTime.now(this.clock))})).map(AnnotationSpec.Builder::build).orElse(null);
    }

    private static boolean isTypeAvailable(ConversionServiceAdapterDescriptor descriptor, String name) {
        return descriptor.getElementUtils().getTypeElement(name) != null;
    }
}

