/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.extensions.spring.converter;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.Collection;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.Diagnostic;

public class TypeNameUtils {
    private TypeNameUtils() {
    }

    private static String simpleName(TypeName typeName) {
        TypeName rawType = TypeNameUtils.rawType(typeName);
        if (rawType instanceof ArrayTypeName) {
            return TypeNameUtils.arraySimpleName((ArrayTypeName)rawType);
        }
        if (rawType instanceof ClassName) {
            return ((ClassName)rawType).simpleName();
        }
        return String.valueOf(typeName);
    }

    private static String arraySimpleName(ArrayTypeName arrayTypeName) {
        return "ArrayOf" + (arrayTypeName.componentType instanceof ArrayTypeName ? TypeNameUtils.arraySimpleName((ArrayTypeName)arrayTypeName.componentType) : arrayTypeName.componentType);
    }

    public static TypeName rawType(TypeName typeName) {
        if (typeName instanceof ParameterizedTypeName) {
            return ((ParameterizedTypeName)typeName).rawType;
        }
        return typeName;
    }

    private static String collectionOfName(ProcessingEnvironment processingEnvironment, ParameterizedTypeName parameterizedTypeName) {
        if (TypeNameUtils.isCollectionWithGenericParameter(processingEnvironment, parameterizedTypeName)) {
            return TypeNameUtils.simpleName((TypeName)parameterizedTypeName) + "Of" + TypeNameUtils.collectionOfNameIfApplicable(processingEnvironment, (TypeName)parameterizedTypeName.typeArguments.iterator().next());
        }
        return TypeNameUtils.simpleName((TypeName)parameterizedTypeName);
    }

    public static boolean isCollectionWithGenericParameter(ProcessingEnvironment processingEnvironment, ParameterizedTypeName parameterizedTypeName) {
        return parameterizedTypeName.typeArguments != null && !parameterizedTypeName.typeArguments.isEmpty() && TypeNameUtils.isCollection(processingEnvironment, parameterizedTypeName);
    }

    private static boolean isCollection(ProcessingEnvironment processingEnvironment, ParameterizedTypeName parameterizedTypeName) {
        try {
            return Collection.class.isAssignableFrom(Class.forName(parameterizedTypeName.rawType.canonicalName()));
        }
        catch (ClassNotFoundException e) {
            processingEnvironment.getMessager().printMessage(Diagnostic.Kind.WARNING, "Caught ClassNotFoundException when trying to resolve parameterized type: " + e.getMessage());
            return false;
        }
    }

    public static String collectionOfNameIfApplicable(ProcessingEnvironment processingEnvironment, TypeName typeName) {
        if (typeName instanceof ParameterizedTypeName) {
            return TypeNameUtils.collectionOfName(processingEnvironment, (ParameterizedTypeName)typeName);
        }
        return TypeNameUtils.simpleName(typeName);
    }
}

