package org.mapstruct.ap.prism;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.type.TypeMirror;
import net.java.dev.hickory.prism.internal.*;
import java.util.HashMap;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
/** A Prism representing an {@code @org.mapstruct.Mapper} annotation. 
  */ 
public class MapperPrism {
    /** store prism value of uses */
    private List<TypeMirror> _uses;

    /** store prism value of imports */
    private List<TypeMirror> _imports;

    /** store prism value of unmappedTargetPolicy */
    private String _unmappedTargetPolicy;

    /** store prism value of componentModel */
    private String _componentModel;

    /** store prism value of config */
    private TypeMirror _config;

    /** store prism value of collectionMappingStrategy */
    private String _collectionMappingStrategy;

    /** store prism value of nullValueMappingStrategy */
    private String _nullValueMappingStrategy;

    /**
      * An instance of the Values inner class whose
      * methods return the AnnotationValues used to build this prism. 
      * Primarily intended to support using Messager.
      */
    public final Values values;
    /** Return a prism representing the {@code @org.mapstruct.Mapper} annotation on 'e'. 
      * similar to {@code e.getAnnotation(org.mapstruct.Mapper.class)} except that 
      * an instance of this class rather than an instance of {@code org.mapstruct.Mapper}
      * is returned.
      */
    public static MapperPrism getInstanceOn(Element e) {
        AnnotationMirror m = getMirror("org.mapstruct.Mapper",e);
        if(m == null) return null;
        return getInstance(m);
   }

    /** Return a prism of the {@code @org.mapstruct.Mapper} annotation whose mirror is mirror. 
      */
    public static MapperPrism getInstance(AnnotationMirror mirror) {
        return new MapperPrism(mirror);
    }

    private MapperPrism(AnnotationMirror mirror) {
        for(ExecutableElement key : mirror.getElementValues().keySet()) {
            memberValues.put(key.getSimpleName().toString(),mirror.getElementValues().get(key));
        }
        for(ExecutableElement member : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            defaults.put(member.getSimpleName().toString(),member.getDefaultValue());
        }
        _uses = getArrayValues("uses",TypeMirror.class);
        _imports = getArrayValues("imports",TypeMirror.class);
        VariableElement unmappedTargetPolicyMirror = getValue("unmappedTargetPolicy",VariableElement.class);
        valid = valid && unmappedTargetPolicyMirror != null;
        _unmappedTargetPolicy = unmappedTargetPolicyMirror == null ? null : unmappedTargetPolicyMirror.getSimpleName().toString();
        _componentModel = getValue("componentModel",String.class);
        _config = getValue("config",TypeMirror.class);
        VariableElement collectionMappingStrategyMirror = getValue("collectionMappingStrategy",VariableElement.class);
        valid = valid && collectionMappingStrategyMirror != null;
        _collectionMappingStrategy = collectionMappingStrategyMirror == null ? null : collectionMappingStrategyMirror.getSimpleName().toString();
        VariableElement nullValueMappingStrategyMirror = getValue("nullValueMappingStrategy",VariableElement.class);
        valid = valid && nullValueMappingStrategyMirror != null;
        _nullValueMappingStrategy = nullValueMappingStrategyMirror == null ? null : nullValueMappingStrategyMirror.getSimpleName().toString();
        this.values = new Values(memberValues);
        this.mirror = mirror;
        this.isValid = valid;
    }

    /** 
      * Returns a List<TypeMirror> representing the value of the {@code uses()} member of the Annotation.
      * @see org.mapstruct.Mapper#uses()
      */ 
    public List<TypeMirror> uses() { return _uses; }

    /** 
      * Returns a List<TypeMirror> representing the value of the {@code imports()} member of the Annotation.
      * @see org.mapstruct.Mapper#imports()
      */ 
    public List<TypeMirror> imports() { return _imports; }

    /** 
      * Returns a String representing the value of the {@code org.mapstruct.ReportingPolicy unmappedTargetPolicy()} member of the Annotation.
      * @see org.mapstruct.Mapper#unmappedTargetPolicy()
      */ 
    public String unmappedTargetPolicy() { return _unmappedTargetPolicy; }

    /** 
      * Returns a String representing the value of the {@code java.lang.String componentModel()} member of the Annotation.
      * @see org.mapstruct.Mapper#componentModel()
      */ 
    public String componentModel() { return _componentModel; }

    /** 
      * Returns a TypeMirror representing the value of the {@code java.lang.Class<?> config()} member of the Annotation.
      * @see org.mapstruct.Mapper#config()
      */ 
    public TypeMirror config() { return _config; }

    /** 
      * Returns a String representing the value of the {@code org.mapstruct.CollectionMappingStrategy collectionMappingStrategy()} member of the Annotation.
      * @see org.mapstruct.Mapper#collectionMappingStrategy()
      */ 
    public String collectionMappingStrategy() { return _collectionMappingStrategy; }

    /** 
      * Returns a String representing the value of the {@code org.mapstruct.NullValueMappingStrategy nullValueMappingStrategy()} member of the Annotation.
      * @see org.mapstruct.Mapper#nullValueMappingStrategy()
      */ 
    public String nullValueMappingStrategy() { return _nullValueMappingStrategy; }

    /**
      * Determine whether the underlying AnnotationMirror has no errors.
      * True if the underlying AnnotationMirror has no errors.
      * When true is returned, none of the methods will return null.
      * When false is returned, a least one member will either return null, or another
      * prism that is not valid.
      */
    public final boolean isValid;
    
    /**
      * The underlying AnnotationMirror of the annotation
      * represented by this Prism. 
      * Primarily intended to support using Messager.
      */
    public final AnnotationMirror mirror;
    /**
      * A class whose members corespond to those of org.mapstruct.Mapper
      * but which each return the AnnotationValue corresponding to
      * that member in the model of the annotations. Returns null for
      * defaulted members. Used for Messager, so default values are not useful.
      */
    public static class Values {
       private Map<String,AnnotationValue> values;
       private Values(Map<String,AnnotationValue> values) {
           this.values = values;
       }    
       /** Return the AnnotationValue corresponding to the uses() 
         * member of the annotation, or null when the default value is implied.
         */
       public AnnotationValue uses(){ return values.get("uses");}
       /** Return the AnnotationValue corresponding to the imports() 
         * member of the annotation, or null when the default value is implied.
         */
       public AnnotationValue imports(){ return values.get("imports");}
       /** Return the AnnotationValue corresponding to the unmappedTargetPolicy() 
         * member of the annotation, or null when the default value is implied.
         */
       public AnnotationValue unmappedTargetPolicy(){ return values.get("unmappedTargetPolicy");}
       /** Return the AnnotationValue corresponding to the componentModel() 
         * member of the annotation, or null when the default value is implied.
         */
       public AnnotationValue componentModel(){ return values.get("componentModel");}
       /** Return the AnnotationValue corresponding to the config() 
         * member of the annotation, or null when the default value is implied.
         */
       public AnnotationValue config(){ return values.get("config");}
       /** Return the AnnotationValue corresponding to the collectionMappingStrategy() 
         * member of the annotation, or null when the default value is implied.
         */
       public AnnotationValue collectionMappingStrategy(){ return values.get("collectionMappingStrategy");}
       /** Return the AnnotationValue corresponding to the nullValueMappingStrategy() 
         * member of the annotation, or null when the default value is implied.
         */
       public AnnotationValue nullValueMappingStrategy(){ return values.get("nullValueMappingStrategy");}
    }
    private Map<String,AnnotationValue> defaults = new HashMap<String,AnnotationValue>(10);
    private Map<String,AnnotationValue> memberValues = new HashMap<String,AnnotationValue>(10);
    private boolean valid = true;

    private <T> T getValue(String name, Class<T> clazz) {
        T result = MapperPrism.getValue(memberValues,defaults,name,clazz);
        if(result == null) valid = false;
        return result;
    } 

    private <T> List<T> getArrayValues(String name, final Class<T> clazz) {
        List<T> result = MapperPrism.getArrayValues(memberValues,defaults,name,clazz);
        if(result == null) valid = false;
        return result;
    }
    private static AnnotationMirror getMirror(String fqn, Element target) {
        for (AnnotationMirror m :target.getAnnotationMirrors()) {
            CharSequence mfqn = ((TypeElement)m.getAnnotationType().asElement()).getQualifiedName();
            if(fqn.contentEquals(mfqn)) return m;
        }
        return null;
    }
    private static <T> T getValue(Map<String,AnnotationValue> memberValues, Map<String,AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if(av == null) av = defaults.get(name);
        if(av == null) {
            return null;
        }
        if(clazz.isInstance(av.getValue())) return clazz.cast(av.getValue());
        return null;
    }
    private static <T> List<T> getArrayValues(Map<String,AnnotationValue> memberValues, Map<String,AnnotationValue> defaults, String name, final Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if(av == null) av = defaults.get(name);
        if(av == null) {
            return null;
        }
        if(av.getValue() instanceof List) {
            List<T> result = new ArrayList<T>();
            for(AnnotationValue v : getValueAsList(av)) {
                if(clazz.isInstance(v.getValue())) {
                    result.add(clazz.cast(v.getValue()));
                } else{
                    return null;
                }
            }
            return result;
        } else {
            return null;
        }
    }
    @SuppressWarnings("unchecked")
    private static List<AnnotationValue> getValueAsList(AnnotationValue av) {
        return (List<AnnotationValue>)av.getValue();
    }
}
