/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.conversion;

import java.math.BigDecimal;
import java.util.Set;
import org.mapstruct.ap.conversion.SimpleConversion;
import org.mapstruct.ap.model.common.ConversionContext;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.util.Collections;
import org.mapstruct.ap.util.NativeTypes;

public class BigDecimalToWrapperConversion
extends SimpleConversion {
    private final Class<?> targetType;

    public BigDecimalToWrapperConversion(Class<?> targetType) {
        if (targetType.isPrimitive()) {
            throw new IllegalArgumentException(targetType + " is a primitive type.");
        }
        this.targetType = NativeTypes.getPrimitiveType(targetType);
    }

    @Override
    public String getToExpression(ConversionContext conversionContext) {
        return "<SOURCE>." + this.targetType.getName() + "Value()";
    }

    @Override
    public String getFromExpression(ConversionContext conversionContext) {
        return "BigDecimal.valueOf( <SOURCE> )";
    }

    @Override
    protected Set<Type> getFromConversionImportTypes(ConversionContext conversionContext) {
        return Collections.asSet(conversionContext.getTypeFactory().getType(BigDecimal.class));
    }
}

