/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model;

import java.util.ArrayList;
import java.util.List;
import javax.tools.Diagnostic;
import org.mapstruct.ap.model.MappingBuilderContext;
import org.mapstruct.ap.model.MappingMethod;
import org.mapstruct.ap.model.common.Parameter;
import org.mapstruct.ap.model.source.EnumMapping;
import org.mapstruct.ap.model.source.Mapping;
import org.mapstruct.ap.model.source.Method;
import org.mapstruct.ap.model.source.SourceMethod;
import org.mapstruct.ap.util.Strings;

public class EnumMappingMethod
extends MappingMethod {
    private final List<EnumMapping> enumMappings;

    private EnumMappingMethod(Method method, List<EnumMapping> enumMappings) {
        super(method);
        this.enumMappings = enumMappings;
    }

    public List<EnumMapping> getEnumMappings() {
        return this.enumMappings;
    }

    public Parameter getSourceParameter() {
        return this.getParameters().iterator().next();
    }

    public static class Builder {
        private SourceMethod method;
        private MappingBuilderContext ctx;

        public Builder mappingContext(MappingBuilderContext mappingContext) {
            this.ctx = mappingContext;
            return this;
        }

        public Builder souceMethod(SourceMethod sourceMethod) {
            this.method = sourceMethod;
            return this;
        }

        public EnumMappingMethod build() {
            if (!this.reportErrorIfMappedEnumConstantsDontExist(this.method) || !this.reportErrorIfSourceEnumConstantsWithoutCorrespondingTargetConstantAreNotMapped(this.method)) {
                return null;
            }
            ArrayList<EnumMapping> enumMappings = new ArrayList<EnumMapping>();
            List<String> sourceEnumConstants = this.method.getSourceParameters().iterator().next().getType().getEnumConstants();
            for (String enumConstant : sourceEnumConstants) {
                List<Mapping> mappedConstants = this.method.getMappingBySourcePropertyName(enumConstant);
                if (mappedConstants.isEmpty()) {
                    enumMappings.add(new EnumMapping(enumConstant, enumConstant));
                    continue;
                }
                if (mappedConstants.size() == 1) {
                    enumMappings.add(new EnumMapping(enumConstant, mappedConstants.iterator().next().getTargetName()));
                    continue;
                }
                ArrayList<String> targetConstants = new ArrayList<String>(mappedConstants.size());
                for (Mapping mapping : mappedConstants) {
                    targetConstants.add(mapping.getTargetName());
                }
                this.ctx.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("One enum constant must not be mapped to more than one target constant, but constant %s is mapped to %s.", enumConstant, Strings.join(targetConstants, ", ")), this.method.getExecutable());
            }
            return new EnumMappingMethod(this.method, enumMappings);
        }

        private boolean reportErrorIfMappedEnumConstantsDontExist(SourceMethod method) {
            List<String> sourceEnumConstants = method.getSourceParameters().iterator().next().getType().getEnumConstants();
            List<String> targetEnumConstants = method.getReturnType().getEnumConstants();
            boolean foundIncorrectMapping = false;
            for (List<Mapping> mappedConstants : method.getMappings().values()) {
                for (Mapping mappedConstant : mappedConstants) {
                    if (mappedConstant.getSourceName() == null) {
                        this.ctx.getMessager().printMessage(Diagnostic.Kind.ERROR, "A source constant must be specified for mappings of an enum mapping method.", method.getExecutable(), mappedConstant.getMirror());
                        foundIncorrectMapping = true;
                    } else if (!sourceEnumConstants.contains(mappedConstant.getSourceName())) {
                        this.ctx.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Constant %s doesn't exist in enum type %s.", mappedConstant.getSourceName(), method.getSourceParameters().iterator().next().getType()), method.getExecutable(), mappedConstant.getMirror(), mappedConstant.getSourceAnnotationValue());
                        foundIncorrectMapping = true;
                    }
                    if (mappedConstant.getTargetName() == null) {
                        this.ctx.getMessager().printMessage(Diagnostic.Kind.ERROR, "A target constant must be specified for mappings of an enum mapping method.", method.getExecutable(), mappedConstant.getMirror());
                        foundIncorrectMapping = true;
                        continue;
                    }
                    if (targetEnumConstants.contains(mappedConstant.getTargetName())) continue;
                    this.ctx.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Constant %s doesn't exist in enum type %s.", mappedConstant.getTargetName(), method.getReturnType()), method.getExecutable(), mappedConstant.getMirror(), mappedConstant.getTargetAnnotationValue());
                    foundIncorrectMapping = true;
                }
            }
            return !foundIncorrectMapping;
        }

        private boolean reportErrorIfSourceEnumConstantsWithoutCorrespondingTargetConstantAreNotMapped(SourceMethod method) {
            List<String> sourceEnumConstants = method.getSourceParameters().iterator().next().getType().getEnumConstants();
            List<String> targetEnumConstants = method.getReturnType().getEnumConstants();
            ArrayList<String> unmappedSourceEnumConstants = new ArrayList<String>();
            for (String sourceEnumConstant : sourceEnumConstants) {
                if (targetEnumConstants.contains(sourceEnumConstant) || !method.getMappingBySourcePropertyName(sourceEnumConstant).isEmpty()) continue;
                unmappedSourceEnumConstants.add(sourceEnumConstant);
            }
            if (!unmappedSourceEnumConstants.isEmpty()) {
                this.ctx.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("The following constants from the source enum have no corresponding constant in the target enum and must be be mapped via @Mapping: %s", Strings.join(unmappedSourceEnumConstants, ", ")), method.getExecutable());
            }
            return unmappedSourceEnumConstants.isEmpty();
        }
    }
}

