/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model;

import java.util.List;
import java.util.Set;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.mapstruct.ap.model.AssignmentFactory;
import org.mapstruct.ap.model.MappingBuilderContext;
import org.mapstruct.ap.model.MappingMethod;
import org.mapstruct.ap.model.MethodReference;
import org.mapstruct.ap.model.assignment.Assignment;
import org.mapstruct.ap.model.assignment.LocalVarWrapper;
import org.mapstruct.ap.model.common.Parameter;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.model.common.TypeFactory;
import org.mapstruct.ap.model.source.Method;
import org.mapstruct.ap.prism.NullValueMappingPrism;
import org.mapstruct.ap.util.MapperConfig;
import org.mapstruct.ap.util.Strings;

public class MapMappingMethod
extends MappingMethod {
    private final Assignment keyAssignment;
    private final Assignment valueAssignment;
    private final MethodReference factoryMethod;
    private final boolean overridden;
    private final boolean mapNullToDefault;
    private final TypeFactory typeFactory;

    private MapMappingMethod(Method method, Assignment keyAssignment, Assignment valueAssignment, MethodReference factoryMethod, boolean mapNullToDefault, TypeFactory typeFactory) {
        super(method);
        this.keyAssignment = keyAssignment;
        this.valueAssignment = valueAssignment;
        this.factoryMethod = factoryMethod;
        this.overridden = method.overridesMethod();
        this.mapNullToDefault = mapNullToDefault;
        this.typeFactory = typeFactory;
    }

    public Parameter getSourceParameter() {
        for (Parameter parameter : this.getParameters()) {
            if (parameter.isMappingTarget()) continue;
            return parameter;
        }
        throw new IllegalStateException("Method " + this + " has no source parameter.");
    }

    public Assignment getKeyAssignment() {
        return this.keyAssignment;
    }

    public Assignment getValueAssignment() {
        return this.valueAssignment;
    }

    @Override
    public Set<Type> getImportTypes() {
        Set<Type> types = super.getImportTypes();
        if (this.keyAssignment != null) {
            types.addAll(this.keyAssignment.getImportTypes());
        }
        if (this.valueAssignment != null) {
            types.addAll(this.valueAssignment.getImportTypes());
        }
        return types;
    }

    public String getKeyVariableName() {
        return Strings.getSaveVariableName("key", this.getParameterNames());
    }

    public String getValueVariableName() {
        return Strings.getSaveVariableName("value", this.getParameterNames());
    }

    public String getEntryVariableName() {
        return Strings.getSaveVariableName("entry", this.getParameterNames());
    }

    public MethodReference getFactoryMethod() {
        return this.factoryMethod;
    }

    public boolean isMapNullToDefault() {
        return this.mapNullToDefault;
    }

    public boolean isOverridden() {
        return this.overridden;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getResultType() == null ? 0 : this.getResultType().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapMappingMethod other = (MapMappingMethod)obj;
        if (!this.getResultType().equals(other.getResultType())) {
            return false;
        }
        if (this.getSourceParameters().size() != other.getSourceParameters().size()) {
            return false;
        }
        for (int i = 0; i < this.getSourceParameters().size(); ++i) {
            if (this.getSourceParameters().get(i).getType().getTypeParameters().get(0).equals(other.getSourceParameters().get(i).getType().getTypeParameters().get(0))) continue;
            return false;
        }
        return true;
    }

    public static class Builder {
        private String keyDateFormat;
        private String valueDateFormat;
        private List<TypeMirror> keyQualifiers;
        private List<TypeMirror> valueQualifiers;
        private Method method;
        private MappingBuilderContext ctx;

        public Builder mappingContext(MappingBuilderContext mappingContext) {
            this.ctx = mappingContext;
            return this;
        }

        public Builder method(Method sourceMethod) {
            this.method = sourceMethod;
            return this;
        }

        public Builder keyDateFormat(String keyDateFormat) {
            this.keyDateFormat = keyDateFormat;
            return this;
        }

        public Builder valueDateFormat(String valueDateFormat) {
            this.valueDateFormat = valueDateFormat;
            return this;
        }

        public Builder keyQualifiers(List<TypeMirror> keyQualifiers) {
            this.keyQualifiers = keyQualifiers;
            return this;
        }

        public Builder valueQualifiers(List<TypeMirror> valueQualifiers) {
            this.valueQualifiers = valueQualifiers;
            return this;
        }

        public MapMappingMethod build() {
            List<Type> sourceTypeParams = this.method.getSourceParameters().iterator().next().getType().getTypeParameters();
            List<Type> resultTypeParams = this.method.getResultType().getTypeParameters();
            Type keySourceType = sourceTypeParams.get(0);
            Type keyTargetType = resultTypeParams.get(0);
            Assignment keyAssignment = this.ctx.getMappingResolver().getTargetAssignment(this.method, "map key", keySourceType, keyTargetType, null, this.keyDateFormat, this.keyQualifiers, "entry.getKey()");
            if (keyAssignment == null) {
                String message = String.format("Can't create implementation of method %s. Found no method nor built-in conversion for mapping source key type to target key type.", this.method);
                this.ctx.getMessager().printMessage(Diagnostic.Kind.ERROR, message, this.method.getExecutable());
            }
            Type valueSourceType = sourceTypeParams.get(1);
            Type valueTargetType = resultTypeParams.get(1);
            Assignment valueAssignment = this.ctx.getMappingResolver().getTargetAssignment(this.method, "map value", valueSourceType, valueTargetType, null, this.valueDateFormat, this.valueQualifiers, "entry.getValue()");
            if (valueAssignment == null) {
                String message = String.format("Can't create implementation of method %s. Found no method nor built-in conversion for mapping source value type to target value type.", this.method);
                this.ctx.getMessager().printMessage(Diagnostic.Kind.ERROR, message, this.method.getExecutable());
            }
            NullValueMappingPrism prism = NullValueMappingPrism.getInstanceOn(this.method.getExecutable());
            boolean mapNullToDefault = MapperConfig.getInstanceOn(this.ctx.getMapperTypeElement()).isMapToDefault(prism);
            MethodReference factoryMethod = AssignmentFactory.createFactoryMethod(this.method.getReturnType(), this.ctx);
            keyAssignment = new LocalVarWrapper(keyAssignment, this.method.getThrownTypes());
            valueAssignment = new LocalVarWrapper(valueAssignment, this.method.getThrownTypes());
            return new MapMappingMethod(this.method, keyAssignment, valueAssignment, factoryMethod, mapNullToDefault, this.ctx.getTypeFactory());
        }
    }
}

