/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.processor;

import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.mapstruct.ap.model.common.TypeFactory;
import org.mapstruct.ap.option.Options;
import org.mapstruct.ap.processor.ModelElementProcessor;

public class DefaultModelElementProcessorContext
implements ModelElementProcessor.ProcessorContext {
    private final ProcessingEnvironment processingEnvironment;
    private final DelegatingMessager messager;
    private final Options options;
    private final TypeFactory typeFactory;

    public DefaultModelElementProcessorContext(ProcessingEnvironment processingEnvironment, Options options) {
        this.processingEnvironment = processingEnvironment;
        this.messager = new DelegatingMessager(processingEnvironment.getMessager());
        this.typeFactory = new TypeFactory(processingEnvironment.getElementUtils(), processingEnvironment.getTypeUtils());
        this.options = options;
    }

    @Override
    public Filer getFiler() {
        return this.processingEnvironment.getFiler();
    }

    @Override
    public Types getTypeUtils() {
        return this.processingEnvironment.getTypeUtils();
    }

    @Override
    public Elements getElementUtils() {
        return this.processingEnvironment.getElementUtils();
    }

    @Override
    public TypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public Messager getMessager() {
        return this.messager;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public boolean isErroneous() {
        return this.messager.isErroneous();
    }

    private static class DelegatingMessager
    implements Messager {
        private final Messager delegate;
        private boolean isErroneous = false;

        public DelegatingMessager(Messager delegate) {
            this.delegate = delegate;
        }

        @Override
        public void printMessage(Diagnostic.Kind kind, CharSequence msg) {
            this.delegate.printMessage(kind, msg);
            if (kind == Diagnostic.Kind.ERROR) {
                this.isErroneous = true;
            }
        }

        @Override
        public void printMessage(Diagnostic.Kind kind, CharSequence msg, Element e) {
            this.delegate.printMessage(kind, msg, e);
            if (kind == Diagnostic.Kind.ERROR) {
                this.isErroneous = true;
            }
        }

        @Override
        public void printMessage(Diagnostic.Kind kind, CharSequence msg, Element e, AnnotationMirror a) {
            this.delegate.printMessage(kind, msg, e, a);
            if (kind == Diagnostic.Kind.ERROR) {
                this.isErroneous = true;
            }
        }

        @Override
        public void printMessage(Diagnostic.Kind kind, CharSequence msg, Element e, AnnotationMirror a, AnnotationValue v) {
            this.delegate.printMessage(kind, msg, e, a, v);
            if (kind == Diagnostic.Kind.ERROR) {
                this.isErroneous = true;
            }
        }

        public boolean isErroneous() {
            return this.isErroneous;
        }
    }
}

