/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.processor;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.processing.Messager;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.mapstruct.ap.model.BeanMappingMethod;
import org.mapstruct.ap.model.Decorator;
import org.mapstruct.ap.model.DefaultMapperReference;
import org.mapstruct.ap.model.DelegatingMethod;
import org.mapstruct.ap.model.EnumMappingMethod;
import org.mapstruct.ap.model.IterableMappingMethod;
import org.mapstruct.ap.model.MapMappingMethod;
import org.mapstruct.ap.model.Mapper;
import org.mapstruct.ap.model.MapperReference;
import org.mapstruct.ap.model.MappingBuilderContext;
import org.mapstruct.ap.model.MappingMethod;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.model.common.TypeFactory;
import org.mapstruct.ap.model.source.SourceMethod;
import org.mapstruct.ap.option.Options;
import org.mapstruct.ap.prism.DecoratedWithPrism;
import org.mapstruct.ap.prism.InheritInverseConfigurationPrism;
import org.mapstruct.ap.prism.MapperPrism;
import org.mapstruct.ap.processor.ModelElementProcessor;
import org.mapstruct.ap.processor.creation.MappingResolverImpl;
import org.mapstruct.ap.util.MapperConfig;
import org.mapstruct.ap.util.Strings;

public class MapperCreationProcessor
implements ModelElementProcessor<List<SourceMethod>, Mapper> {
    private Elements elementUtils;
    private Types typeUtils;
    private Messager messager;
    private Options options;
    private TypeFactory typeFactory;
    private MappingBuilderContext mappingContext;

    @Override
    public Mapper process(ModelElementProcessor.ProcessorContext context, TypeElement mapperTypeElement, List<SourceMethod> sourceModel) {
        MappingBuilderContext ctx;
        this.elementUtils = context.getElementUtils();
        this.typeUtils = context.getTypeUtils();
        this.messager = context.getMessager();
        this.options = context.getOptions();
        this.typeFactory = context.getTypeFactory();
        List<MapperReference> mapperReferences = this.initReferencedMappers(mapperTypeElement);
        this.mappingContext = ctx = new MappingBuilderContext(this.typeFactory, this.elementUtils, this.typeUtils, this.messager, this.options, new MappingResolverImpl(context.getMessager(), this.elementUtils, this.typeUtils, this.typeFactory, sourceModel, mapperReferences), mapperTypeElement, sourceModel, mapperReferences);
        return this.getMapper(mapperTypeElement, sourceModel);
    }

    @Override
    public int getPriority() {
        return 1000;
    }

    private List<MapperReference> initReferencedMappers(TypeElement element) {
        LinkedList<MapperReference> result = new LinkedList<MapperReference>();
        LinkedList<String> variableNames = new LinkedList<String>();
        MapperConfig mapperPrism = MapperConfig.getInstanceOn(element);
        for (TypeMirror usedMapper : mapperPrism.uses()) {
            DefaultMapperReference mapperReference = DefaultMapperReference.getInstance(this.typeFactory.getType(usedMapper), MapperPrism.getInstanceOn(this.typeUtils.asElement(usedMapper)) != null, this.typeFactory, variableNames);
            result.add(mapperReference);
            variableNames.add(mapperReference.getVariableName());
        }
        return result;
    }

    private Mapper getMapper(TypeElement element, List<SourceMethod> methods) {
        List<MapperReference> mapperReferences = this.mappingContext.getMapperReferences();
        List<MappingMethod> mappingMethods = this.getMappingMethods(methods);
        mappingMethods.addAll(this.mappingContext.getUsedVirtualMappings());
        mappingMethods.addAll(this.mappingContext.getMappingsToGenerate());
        Mapper mapper = new Mapper.Builder().element(element).mappingMethods(mappingMethods).mapperReferences(mapperReferences).suppressGeneratorTimestamp(this.options.isSuppressGeneratorTimestamp()).decorator(this.getDecorator(element, methods)).typeFactory(this.typeFactory).elementUtils(this.elementUtils).extraImports(this.getExtraImports(element)).build();
        return mapper;
    }

    private Decorator getDecorator(TypeElement element, List<SourceMethod> methods) {
        DecoratedWithPrism decoratorPrism = DecoratedWithPrism.getInstanceOn(element);
        if (decoratorPrism == null) {
            return null;
        }
        TypeElement decoratorElement = (TypeElement)this.typeUtils.asElement(decoratorPrism.value());
        if (!this.typeUtils.isAssignable(decoratorElement.asType(), element.asType())) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Specified decorator type is no subtype of the annotated mapper type.", new Object[0]), element, decoratorPrism.mirror);
        }
        ArrayList<MappingMethod> mappingMethods = new ArrayList<MappingMethod>(methods.size());
        for (SourceMethod mappingMethod : methods) {
            boolean implementationRequired = true;
            for (ExecutableElement method : ElementFilter.methodsIn(decoratorElement.getEnclosedElements())) {
                if (!this.elementUtils.overrides(method, mappingMethod.getExecutable(), decoratorElement)) continue;
                implementationRequired = false;
                break;
            }
            Type declaringMapper = mappingMethod.getDeclaringMapper();
            if (!implementationRequired || declaringMapper != null && !declaringMapper.equals(this.typeFactory.getType(element))) continue;
            mappingMethods.add(new DelegatingMethod(mappingMethod));
        }
        boolean hasDelegateConstructor = false;
        boolean hasDefaultConstructor = false;
        for (ExecutableElement constructor : ElementFilter.constructorsIn(decoratorElement.getEnclosedElements())) {
            if (constructor.getParameters().isEmpty()) {
                hasDefaultConstructor = true;
                continue;
            }
            if (constructor.getParameters().size() != 1 || !this.typeUtils.isAssignable(element.asType(), constructor.getParameters().iterator().next().asType())) continue;
            hasDelegateConstructor = true;
        }
        if (!hasDelegateConstructor && !hasDefaultConstructor) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Specified decorator type has no default constructor nor a constructor with a single parameter accepting the decorated mapper type.", new Object[0]), element, decoratorPrism.mirror);
        }
        return Decorator.getInstance(this.elementUtils, this.typeFactory, element, decoratorPrism, mappingMethods, hasDelegateConstructor, this.options.isSuppressGeneratorTimestamp());
    }

    private SortedSet<Type> getExtraImports(TypeElement element) {
        TreeSet<Type> extraImports = new TreeSet<Type>();
        MapperConfig mapperPrism = MapperConfig.getInstanceOn(element);
        for (TypeMirror extraImport : mapperPrism.imports()) {
            Type type = this.typeFactory.getType(extraImport);
            extraImports.add(type);
        }
        return extraImports;
    }

    private List<MappingMethod> getMappingMethods(List<SourceMethod> methods) {
        ArrayList<MappingMethod> mappingMethods = new ArrayList<MappingMethod>();
        for (SourceMethod method : methods) {
            Object builder;
            if (!method.overridesMethod()) continue;
            SourceMethod inverseMappingMethod = this.getInverseMappingMethod(methods, method);
            boolean hasFactoryMethod = false;
            if (method.isIterableMapping()) {
                IterableMappingMethod iterableMappingMethod;
                builder = new IterableMappingMethod.Builder();
                if (method.getIterableMapping() == null && inverseMappingMethod != null && inverseMappingMethod.getIterableMapping() != null) {
                    method.setIterableMapping(inverseMappingMethod.getIterableMapping());
                }
                String dateFormat = null;
                List<TypeMirror> qualifiers = null;
                if (method.getIterableMapping() != null) {
                    dateFormat = method.getIterableMapping().getDateFormat();
                    qualifiers = method.getIterableMapping().getQualifiers();
                }
                hasFactoryMethod = (iterableMappingMethod = ((IterableMappingMethod.Builder)builder).mappingContext(this.mappingContext).method(method).dateFormat(dateFormat).qualifiers(qualifiers).build()).getFactoryMethod() != null;
                mappingMethods.add(iterableMappingMethod);
            } else if (method.isMapMapping()) {
                MapMappingMethod mapMappingMethod;
                builder = new MapMappingMethod.Builder();
                if (method.getMapMapping() == null && inverseMappingMethod != null && inverseMappingMethod.getMapMapping() != null) {
                    method.setMapMapping(inverseMappingMethod.getMapMapping());
                }
                String keyDateFormat = null;
                String valueDateFormat = null;
                List<TypeMirror> keyQualifiers = null;
                List<TypeMirror> valueQualifiers = null;
                if (method.getMapMapping() != null) {
                    keyDateFormat = method.getMapMapping().getKeyFormat();
                    valueDateFormat = method.getMapMapping().getValueFormat();
                    keyQualifiers = method.getMapMapping().getKeyQualifiers();
                    valueQualifiers = method.getMapMapping().getValueQualifiers();
                }
                hasFactoryMethod = (mapMappingMethod = ((MapMappingMethod.Builder)builder).mappingContext(this.mappingContext).method(method).keyDateFormat(keyDateFormat).valueDateFormat(valueDateFormat).keyQualifiers(keyQualifiers).valueQualifiers(valueQualifiers).build()).getFactoryMethod() != null;
                mappingMethods.add(mapMappingMethod);
            } else if (method.isEnumMapping()) {
                builder = new EnumMappingMethod.Builder();
                method.mergeWithInverseMappings(inverseMappingMethod);
                EnumMappingMethod enumMappingMethod = ((EnumMappingMethod.Builder)builder).mappingContext(this.mappingContext).souceMethod(method).build();
                if (enumMappingMethod != null) {
                    mappingMethods.add(enumMappingMethod);
                }
            } else {
                builder = new BeanMappingMethod.Builder();
                method.mergeWithInverseMappings(inverseMappingMethod);
                BeanMappingMethod beanMappingMethod = ((BeanMappingMethod.Builder)builder).mappingContext(this.mappingContext).souceMethod(method).build();
                if (beanMappingMethod != null) {
                    hasFactoryMethod = beanMappingMethod.getFactoryMethod() != null;
                    mappingMethods.add(beanMappingMethod);
                }
            }
            if (hasFactoryMethod) continue;
            this.reportErrorIfNoImplementationTypeIsRegisteredForInterfaceReturnType(method);
        }
        return mappingMethods;
    }

    private void reportErrorIfNoImplementationTypeIsRegisteredForInterfaceReturnType(SourceMethod method) {
        if (method.getReturnType().getTypeMirror().getKind() != TypeKind.VOID && method.getReturnType().isInterface() && method.getReturnType().getImplementationType() == null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("No implementation type is registered for return type %s.", method.getReturnType()), method.getExecutable());
        }
    }

    private SourceMethod getInverseMappingMethod(List<SourceMethod> rawMethods, SourceMethod method) {
        SourceMethod result = null;
        InheritInverseConfigurationPrism reversePrism = InheritInverseConfigurationPrism.getInstanceOn(method.getExecutable());
        if (reversePrism != null) {
            ArrayList<SourceMethod> candidates = new ArrayList<SourceMethod>();
            for (SourceMethod oneMethod : rawMethods) {
                if (!oneMethod.reverses(method)) continue;
                candidates.add(oneMethod);
            }
            String name = reversePrism.name();
            if (candidates.size() == 1) {
                if (name.isEmpty()) {
                    result = (SourceMethod)candidates.get(0);
                } else if (((SourceMethod)candidates.get(0)).getName().equals(name)) {
                    result = (SourceMethod)candidates.get(0);
                } else {
                    this.reportErrorWhenNonMatchingName((SourceMethod)candidates.get(0), method, reversePrism);
                }
            } else if (candidates.size() > 1) {
                ArrayList<SourceMethod> nameFilteredcandidates = new ArrayList<SourceMethod>();
                for (SourceMethod candidate : candidates) {
                    if (!candidate.getName().equals(name)) continue;
                    nameFilteredcandidates.add(candidate);
                }
                if (nameFilteredcandidates.size() == 1) {
                    result = (SourceMethod)nameFilteredcandidates.get(0);
                } else if (nameFilteredcandidates.size() > 1) {
                    this.reportErrorWhenSeveralNamesMatch(nameFilteredcandidates, method, reversePrism);
                }
                if (result == null) {
                    this.reportErrorWhenAmbigousReverseMapping(candidates, method, reversePrism);
                }
            }
            if (result != null) {
                this.reportErrorIfInverseMethodHasInheritAnnotation(result, method, reversePrism);
            }
        }
        return result;
    }

    private void reportErrorIfInverseMethodHasInheritAnnotation(SourceMethod candidate, SourceMethod method, InheritInverseConfigurationPrism reversePrism) {
        InheritInverseConfigurationPrism candidatePrism = InheritInverseConfigurationPrism.getInstanceOn(candidate.getExecutable());
        if (candidatePrism != null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Resolved inverse mapping method %s() should not carry the @InheritInverseConfiguration annotation itself.", candidate.getName()), method.getExecutable(), reversePrism.mirror);
        }
    }

    private void reportErrorWhenAmbigousReverseMapping(List<SourceMethod> candidates, SourceMethod method, InheritInverseConfigurationPrism reversePrism) {
        ArrayList<String> candidateNames = new ArrayList<String>();
        for (SourceMethod candidate : candidates) {
            candidateNames.add(candidate.getName());
        }
        String name = reversePrism.name();
        if (name.isEmpty()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Several matching inverse methods exist: %s(). Specify a name explicitly.", Strings.join(candidateNames, "(), ")), method.getExecutable(), reversePrism.mirror);
        } else {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("None of the candidates %s() matches given name: \"%s\".", Strings.join(candidateNames, "(), "), name), method.getExecutable(), reversePrism.mirror);
        }
    }

    private void reportErrorWhenSeveralNamesMatch(List<SourceMethod> candidates, SourceMethod method, InheritInverseConfigurationPrism reversePrism) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Given name \"%s\" matches several candidate methods: %s().", reversePrism.name(), Strings.join(candidates, "(), ")), method.getExecutable(), reversePrism.mirror);
    }

    private void reportErrorWhenNonMatchingName(SourceMethod onlyCandidate, SourceMethod method, InheritInverseConfigurationPrism reversePrism) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Given name \"%s\" does not match the only candidate. Did you mean: \"%s\".", reversePrism.name(), onlyCandidate.getName()), method.getExecutable(), reversePrism.mirror);
    }
}

