/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class NativeTypes {
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE_TYPES;
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER_TYPES;

    private NativeTypes() {
    }

    public static Class<?> getWrapperType(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            throw new IllegalArgumentException(clazz + " is no primitive type.");
        }
        return PRIMITIVE_TO_WRAPPER_TYPES.get(clazz);
    }

    public static Class<?> getPrimitiveType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException(clazz + " is no wrapper type.");
        }
        return WRAPPER_TO_PRIMITIVE_TYPES.get(clazz);
    }

    static {
        HashMap<Class<Serializable>, Class<Serializable>> tmp = new HashMap<Class<Serializable>, Class<Serializable>>();
        tmp.put(Byte.class, Byte.TYPE);
        tmp.put(Short.class, Short.TYPE);
        tmp.put(Integer.class, Integer.TYPE);
        tmp.put(Long.class, Long.TYPE);
        tmp.put(Float.class, Float.TYPE);
        tmp.put(Double.class, Double.TYPE);
        tmp.put(Boolean.class, Boolean.TYPE);
        tmp.put(Character.class, Character.TYPE);
        WRAPPER_TO_PRIMITIVE_TYPES = Collections.unmodifiableMap(tmp);
        tmp = new HashMap();
        tmp.put(Byte.TYPE, Byte.class);
        tmp.put(Short.TYPE, Short.class);
        tmp.put(Integer.TYPE, Integer.class);
        tmp.put(Long.TYPE, Long.class);
        tmp.put(Float.TYPE, Float.class);
        tmp.put(Double.TYPE, Double.class);
        tmp.put(Boolean.TYPE, Boolean.class);
        tmp.put(Character.TYPE, Character.class);
        PRIMITIVE_TO_WRAPPER_TYPES = Collections.unmodifiableMap(tmp);
    }
}

