/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.PropertyMapping;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.source.Mapping;
import org.mapstruct.ap.internal.model.source.MappingOptions;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.PropertyEntry;
import org.mapstruct.ap.internal.model.source.SourceReference;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.Extractor;

public class NestedTargetPropertyMappingHolder {
    private static final Extractor<SourceReference, Parameter> SOURCE_PARAM_EXTRACTOR = new Extractor<SourceReference, Parameter>(){

        @Override
        public Parameter apply(SourceReference sourceReference) {
            return sourceReference.getParameter();
        }
    };
    private static final Extractor<SourceReference, PropertyEntry> PROPERTY_EXTRACTOR = new Extractor<SourceReference, PropertyEntry>(){

        @Override
        public PropertyEntry apply(SourceReference sourceReference) {
            return Collections.first(sourceReference.getPropertyEntries());
        }
    };
    private final List<Parameter> processedSourceParameters;
    private final Set<String> handledTargets;
    private final List<PropertyMapping> propertyMappings;
    private final Map<PropertyEntry, List<Mapping>> unprocessedDefinedTarget;

    public NestedTargetPropertyMappingHolder(List<Parameter> processedSourceParameters, Set<String> handledTargets, List<PropertyMapping> propertyMappings, Map<PropertyEntry, List<Mapping>> unprocessedDefinedTarget) {
        this.processedSourceParameters = processedSourceParameters;
        this.handledTargets = handledTargets;
        this.propertyMappings = propertyMappings;
        this.unprocessedDefinedTarget = unprocessedDefinedTarget;
    }

    public List<Parameter> getProcessedSourceParameters() {
        return this.processedSourceParameters;
    }

    public Set<String> getHandledTargets() {
        return this.handledTargets;
    }

    public List<PropertyMapping> getPropertyMappings() {
        return this.propertyMappings;
    }

    public Map<PropertyEntry, List<Mapping>> getUnprocessedDefinedTarget() {
        return this.unprocessedDefinedTarget;
    }

    private static class GroupedSourceReferences {
        private final Map<PropertyEntry, List<Mapping>> groupedBySourceReferences;
        private final List<Mapping> nonNested;
        private final List<Mapping> notProcessedAppliesToAll;

        private GroupedSourceReferences(Map<PropertyEntry, List<Mapping>> groupedBySourceReferences, List<Mapping> nonNested, List<Mapping> notProcessedAppliesToAll) {
            this.groupedBySourceReferences = groupedBySourceReferences;
            this.nonNested = nonNested;
            this.notProcessedAppliesToAll = notProcessedAppliesToAll;
        }
    }

    private static class GroupedTargetReferences {
        private final Map<PropertyEntry, List<Mapping>> poppedTargetReferences;
        private final Map<PropertyEntry, List<Mapping>> singleTargetReferences;

        private GroupedTargetReferences(Map<PropertyEntry, List<Mapping>> poppedTargetReferences, Map<PropertyEntry, List<Mapping>> singleTargetReferences) {
            this.poppedTargetReferences = poppedTargetReferences;
            this.singleTargetReferences = singleTargetReferences;
        }
    }

    private static class GroupedBySourceParameters {
        private final Map<Parameter, List<Mapping>> groupedBySourceParameter;
        private final List<Mapping> notProcessedAppliesToAll;

        private GroupedBySourceParameters(Map<Parameter, List<Mapping>> groupedBySourceParameter, List<Mapping> notProcessedAppliesToAll) {
            this.groupedBySourceParameter = groupedBySourceParameter;
            this.notProcessedAppliesToAll = notProcessedAppliesToAll;
        }
    }

    public static class Builder {
        private Method method;
        private MappingBuilderContext mappingContext;
        private Set<String> existingVariableNames;

        public Builder method(Method method) {
            this.method = method;
            return this;
        }

        public Builder mappingContext(MappingBuilderContext mappingContext) {
            this.mappingContext = mappingContext;
            return this;
        }

        public Builder existingVariableNames(Set<String> existingVariableNames) {
            this.existingVariableNames = existingVariableNames;
            return this;
        }

        public NestedTargetPropertyMappingHolder build() {
            ArrayList<Parameter> processedSourceParameters = new ArrayList<Parameter>();
            HashSet<String> handledTargets = new HashSet<String>();
            ArrayList<PropertyMapping> propertyMappings = new ArrayList<PropertyMapping>();
            GroupedTargetReferences groupedByTP = this.groupByTargetReferences(this.method.getMappingOptions());
            HashMap<PropertyEntry, List<Mapping>> unprocessedDefinedTarget = new HashMap<PropertyEntry, List<Mapping>>();
            for (Map.Entry entryByTP : groupedByTP.poppedTargetReferences.entrySet()) {
                PropertyEntry targetProperty = (PropertyEntry)entryByTP.getKey();
                GroupedBySourceParameters groupedBySourceParam = this.groupBySourceParameter((List)entryByTP.getValue(), (List)groupedByTP.singleTargetReferences.get(targetProperty));
                boolean forceUpdateMethod = groupedBySourceParam.groupedBySourceParameter.keySet().size() > 1;
                unprocessedDefinedTarget.put(targetProperty, groupedBySourceParam.notProcessedAppliesToAll);
                for (Map.Entry entryByParam : groupedBySourceParam.groupedBySourceParameter.entrySet()) {
                    Parameter sourceParameter = (Parameter)entryByParam.getKey();
                    GroupedSourceReferences groupedSourceReferences = this.groupByPoppedSourceReferences((List)entryByParam.getValue(), (List)groupedByTP.singleTargetReferences.get(targetProperty));
                    for (Map.Entry entryBySP : groupedSourceReferences.groupedBySourceReferences.entrySet()) {
                        SourceReference sourceRef;
                        PropertyEntry sourceEntry = (PropertyEntry)entryBySP.getKey();
                        MappingOptions sourceMappingOptions = MappingOptions.forMappingsOnly(this.groupByTargetName((List)entryBySP.getValue()), forceUpdateMethod);
                        PropertyMapping propertyMapping = this.createPropertyMappingForNestedTarget(sourceMappingOptions, targetProperty, sourceRef = new SourceReference.BuilderFromProperty().sourceParameter(sourceParameter).type(sourceEntry.getType()).readAccessor(sourceEntry.getReadAccessor()).presenceChecker(sourceEntry.getPresenceChecker()).name(targetProperty.getName()).build(), forceUpdateMethod);
                        if (propertyMapping != null) {
                            propertyMappings.add(propertyMapping);
                        }
                        handledTargets.add(((PropertyEntry)entryByTP.getKey()).getName());
                    }
                    if (!groupedSourceReferences.nonNested.isEmpty()) {
                        SourceReference reference;
                        MappingOptions nonNestedOptions = MappingOptions.forMappingsOnly(this.groupByTargetName(groupedSourceReferences.nonNested), true);
                        PropertyMapping propertyMapping = this.createPropertyMappingForNestedTarget(nonNestedOptions, targetProperty, reference = new SourceReference.BuilderFromProperty().sourceParameter(sourceParameter).name(targetProperty.getName()).build(), forceUpdateMethod);
                        if (propertyMapping != null) {
                            propertyMappings.add(propertyMapping);
                        }
                        handledTargets.add(((PropertyEntry)entryByTP.getKey()).getName());
                    }
                    unprocessedDefinedTarget.put(targetProperty, groupedSourceReferences.notProcessedAppliesToAll);
                }
            }
            return new NestedTargetPropertyMappingHolder(processedSourceParameters, handledTargets, propertyMappings, unprocessedDefinedTarget);
        }

        private GroupedTargetReferences groupByTargetReferences(MappingOptions mappingOptions) {
            Map<String, List<Mapping>> mappings = mappingOptions.getMappings();
            HashMap mappingsKeyedByProperty = new HashMap();
            HashMap singleTargetReferences = new HashMap();
            for (List<Mapping> mapping : mappings.values()) {
                PropertyEntry property = Collections.first(Collections.first(mapping).getTargetReference().getPropertyEntries());
                Mapping newMapping = Collections.first(mapping).popTargetReference();
                if (newMapping != null) {
                    if (!mappingsKeyedByProperty.containsKey(property)) {
                        mappingsKeyedByProperty.put(property, new ArrayList());
                    }
                    ((List)mappingsKeyedByProperty.get(property)).add(newMapping);
                    continue;
                }
                if (!singleTargetReferences.containsKey(property)) {
                    singleTargetReferences.put(property, new ArrayList());
                }
                ((List)singleTargetReferences.get(property)).add(Collections.first(mapping));
            }
            return new GroupedTargetReferences(mappingsKeyedByProperty, singleTargetReferences);
        }

        private GroupedBySourceParameters groupBySourceParameter(List<Mapping> mappings, List<Mapping> singleTargetReferences) {
            HashMap mappingsKeyedByParameter = new HashMap();
            ArrayList<Mapping> appliesToAll = new ArrayList<Mapping>();
            for (Mapping mapping : mappings) {
                if (mapping.getSourceReference() != null && mapping.getSourceReference().isValid()) {
                    Parameter parameter = mapping.getSourceReference().getParameter();
                    if (!mappingsKeyedByParameter.containsKey(parameter)) {
                        mappingsKeyedByParameter.put(parameter, new ArrayList());
                    }
                    ((List)mappingsKeyedByParameter.get(parameter)).add(mapping);
                    continue;
                }
                appliesToAll.add(mapping);
            }
            this.populateWithSingleTargetReferences(mappingsKeyedByParameter, singleTargetReferences, SOURCE_PARAM_EXTRACTOR);
            for (Map.Entry entry : mappingsKeyedByParameter.entrySet()) {
                ((List)entry.getValue()).addAll(appliesToAll);
            }
            ArrayList<Mapping> notProcessAppliesToAll = mappingsKeyedByParameter.isEmpty() ? appliesToAll : new ArrayList<Mapping>();
            return new GroupedBySourceParameters(mappingsKeyedByParameter, notProcessAppliesToAll);
        }

        private GroupedSourceReferences groupByPoppedSourceReferences(List<Mapping> mappings, List<Mapping> singleTargetReferences) {
            ArrayList<Mapping> nonNested = new ArrayList<Mapping>();
            ArrayList<Mapping> appliesToAll = new ArrayList<Mapping>();
            HashMap mappingsKeyedByProperty = new HashMap();
            for (Mapping mapping : mappings) {
                Mapping newMapping = mapping.popSourceReference();
                if (newMapping != null) {
                    PropertyEntry property = Collections.first(mapping.getSourceReference().getPropertyEntries());
                    if (!mappingsKeyedByProperty.containsKey(property)) {
                        mappingsKeyedByProperty.put(property, new ArrayList());
                    }
                    ((List)mappingsKeyedByProperty.get(property)).add(newMapping);
                    continue;
                }
                if (mapping.getSourceReference() == null) {
                    appliesToAll.add(mapping);
                    continue;
                }
                nonNested.add(mapping);
            }
            this.populateWithSingleTargetReferences(mappingsKeyedByProperty, singleTargetReferences, PROPERTY_EXTRACTOR);
            for (Map.Entry entry : mappingsKeyedByProperty.entrySet()) {
                ((List)entry.getValue()).addAll(appliesToAll);
            }
            ArrayList<Mapping> notProcessedAppliesToAll = new ArrayList<Mapping>();
            if (mappingsKeyedByProperty.isEmpty() && !nonNested.isEmpty()) {
                nonNested.addAll(appliesToAll);
            } else if (mappingsKeyedByProperty.isEmpty() && nonNested.isEmpty()) {
                notProcessedAppliesToAll.addAll(appliesToAll);
            }
            return new GroupedSourceReferences(mappingsKeyedByProperty, nonNested, notProcessedAppliesToAll);
        }

        private Map<String, List<Mapping>> groupByTargetName(List<Mapping> mappingList) {
            HashMap<String, List<Mapping>> result = new HashMap<String, List<Mapping>>();
            for (Mapping mapping : mappingList) {
                if (!result.containsKey(mapping.getTargetName())) {
                    result.put(mapping.getTargetName(), new ArrayList());
                }
                ((List)result.get(mapping.getTargetName())).add(mapping);
            }
            return result;
        }

        private PropertyMapping createPropertyMappingForNestedTarget(MappingOptions mappingOptions, PropertyEntry targetProperty, SourceReference sourceReference, boolean forceUpdateMethod) {
            PropertyMapping propertyMapping = ((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)new PropertyMapping.PropertyMappingBuilder().mappingContext(this.mappingContext)).sourceMethod(this.method)).targetProperty(targetProperty)).targetPropertyName(targetProperty.getName())).sourceReference(sourceReference).existingVariableNames(this.existingVariableNames)).dependsOn(mappingOptions.collectNestedDependsOn())).forgeMethodWithMappingOptions(mappingOptions).forceUpdateMethod(forceUpdateMethod).forgedNamedBased(false).build();
            return propertyMapping;
        }

        private <K> void populateWithSingleTargetReferences(Map<K, List<Mapping>> map, List<Mapping> singleTargetReferences, Extractor<SourceReference, K> keyExtractor) {
            if (singleTargetReferences != null) {
                for (Mapping mapping : singleTargetReferences) {
                    K key;
                    if (mapping.getSourceReference() == null || !mapping.getSourceReference().isValid() || mapping.getSourceReference().getPropertyEntries().isEmpty() || map.containsKey(key = keyExtractor.apply(mapping.getSourceReference()))) continue;
                    map.put(key, new ArrayList());
                }
            }
        }
    }
}

