/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.util.Types;
import org.mapstruct.ap.internal.model.common.Accessibility;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.model.source.BeanMapping;
import org.mapstruct.ap.internal.model.source.IterableMapping;
import org.mapstruct.ap.internal.model.source.MapMapping;
import org.mapstruct.ap.internal.model.source.Mapping;
import org.mapstruct.ap.internal.model.source.MappingOptions;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.MethodMatcher;
import org.mapstruct.ap.internal.model.source.ParameterProvidedMethods;
import org.mapstruct.ap.internal.model.source.PropertyEntry;
import org.mapstruct.ap.internal.model.source.ValueMapping;
import org.mapstruct.ap.internal.prism.ObjectFactoryPrism;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.Executables;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.MapperConfiguration;
import org.mapstruct.ap.internal.util.Strings;

public class SourceMethod
implements Method {
    private final Types typeUtils;
    private final TypeFactory typeFactory;
    private final Type declaringMapper;
    private final ExecutableElement executable;
    private final List<Parameter> parameters;
    private final Parameter mappingTargetParameter;
    private final Parameter targetTypeParameter;
    private final boolean isObjectFactory;
    private final Type returnType;
    private final Accessibility accessibility;
    private final List<Type> exceptionTypes;
    private final MapperConfiguration config;
    private final MappingOptions mappingOptions;
    private final List<SourceMethod> prototypeMethods;
    private final Type mapperToImplement;
    private final List<Parameter> sourceParameters;
    private final List<Parameter> contextParameters;
    private final ParameterProvidedMethods contextProvidedMethods;
    private List<String> parameterNames;
    private List<SourceMethod> applicablePrototypeMethods;
    private Boolean isBeanMapping;
    private Boolean isEnumMapping;
    private Boolean isValueMapping;
    private Boolean isIterableMapping;
    private Boolean isMapMapping;
    private Boolean isStreamMapping;

    private SourceMethod(Builder builder, MappingOptions mappingOptions) {
        this.declaringMapper = builder.declaringMapper;
        this.executable = builder.executable;
        this.parameters = builder.parameters;
        this.returnType = builder.returnType;
        this.exceptionTypes = builder.exceptionTypes;
        this.accessibility = Accessibility.fromModifiers(builder.executable.getModifiers());
        this.mappingOptions = mappingOptions;
        this.sourceParameters = Parameter.getSourceParameters(this.parameters);
        this.contextParameters = Parameter.getContextParameters(this.parameters);
        this.contextProvidedMethods = builder.contextProvidedMethods;
        this.mappingTargetParameter = Parameter.getMappingTargetParameter(this.parameters);
        this.targetTypeParameter = Parameter.getTargetTypeParameter(this.parameters);
        this.isObjectFactory = this.determineIfIsObjectFactory(this.executable);
        this.typeUtils = builder.typeUtils;
        this.typeFactory = builder.typeFactory;
        this.config = builder.mapperConfig;
        this.prototypeMethods = builder.prototypeMethods;
        this.mapperToImplement = builder.definingType;
    }

    private boolean determineIfIsObjectFactory(ExecutableElement executable) {
        boolean hasFactoryAnnotation = ObjectFactoryPrism.getInstanceOn(executable) != null;
        boolean hasNoSourceParameters = this.getSourceParameters().isEmpty();
        boolean hasNoMappingTargetParam = this.getMappingTargetParameter() == null;
        return !this.isLifecycleCallbackMethod() && !this.returnType.isVoid() && hasNoMappingTargetParam && (hasFactoryAnnotation || hasNoSourceParameters);
    }

    @Override
    public Type getDeclaringMapper() {
        return this.declaringMapper;
    }

    @Override
    public ExecutableElement getExecutable() {
        return this.executable;
    }

    @Override
    public String getName() {
        return this.executable.getSimpleName().toString();
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public List<Parameter> getSourceParameters() {
        return this.sourceParameters;
    }

    @Override
    public List<Parameter> getContextParameters() {
        return this.contextParameters;
    }

    @Override
    public ParameterProvidedMethods getContextProvidedMethods() {
        return this.contextProvidedMethods;
    }

    @Override
    public List<String> getParameterNames() {
        if (this.parameterNames == null) {
            ArrayList<String> names = new ArrayList<String>(this.parameters.size());
            for (Parameter parameter : this.parameters) {
                names.add(parameter.getName());
            }
            this.parameterNames = java.util.Collections.unmodifiableList(names);
        }
        return this.parameterNames;
    }

    @Override
    public Type getResultType() {
        return this.mappingTargetParameter != null ? this.mappingTargetParameter.getType() : this.returnType;
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    public Accessibility getAccessibility() {
        return this.accessibility;
    }

    public Mapping getSingleMappingByTargetPropertyName(String targetPropertyName) {
        List<Mapping> all = this.mappingOptions.getMappings().get(targetPropertyName);
        return all != null ? Collections.first(all) : null;
    }

    public boolean reverses(SourceMethod method) {
        return this.getDeclaringMapper() == null && this.isAbstract() && this.getSourceParameters().size() == 1 && method.getSourceParameters().size() == 1 && this.equals(Collections.first(this.getSourceParameters()).getType(), method.getResultType()) && this.equals(this.getResultType(), Collections.first(method.getSourceParameters()).getType());
    }

    public boolean isSame(SourceMethod method) {
        return this.getSourceParameters().size() == 1 && method.getSourceParameters().size() == 1 && this.equals(Collections.first(this.getSourceParameters()).getType(), Collections.first(method.getSourceParameters()).getType()) && this.equals(this.getResultType(), method.getResultType());
    }

    public boolean canInheritFrom(SourceMethod method) {
        return method.getDeclaringMapper() == null && method.isAbstract() && this.isMapMapping() == method.isMapMapping() && this.isIterableMapping() == method.isIterableMapping() && this.isEnumMapping() == method.isEnumMapping() && this.getResultType().isAssignableTo(method.getResultType()) && SourceMethod.allParametersAreAssignable(this.getSourceParameters(), method.getSourceParameters());
    }

    @Override
    public Parameter getMappingTargetParameter() {
        return this.mappingTargetParameter;
    }

    @Override
    public boolean isObjectFactory() {
        return this.isObjectFactory;
    }

    @Override
    public Parameter getTargetTypeParameter() {
        return this.targetTypeParameter;
    }

    public boolean isIterableMapping() {
        if (this.isIterableMapping == null) {
            this.isIterableMapping = this.getSourceParameters().size() == 1 && Collections.first(this.getSourceParameters()).getType().isIterableType() && this.getResultType().isIterableType();
        }
        return this.isIterableMapping;
    }

    public boolean isStreamMapping() {
        if (this.isStreamMapping == null) {
            this.isStreamMapping = this.getSourceParameters().size() == 1 && (Collections.first(this.getSourceParameters()).getType().isIterableType() && this.getResultType().isStreamType() || Collections.first(this.getSourceParameters()).getType().isStreamType() && this.getResultType().isIterableType() || Collections.first(this.getSourceParameters()).getType().isStreamType() && this.getResultType().isStreamType());
        }
        return this.isStreamMapping;
    }

    public boolean isMapMapping() {
        if (this.isMapMapping == null) {
            this.isMapMapping = this.getSourceParameters().size() == 1 && Collections.first(this.getSourceParameters()).getType().isMapType() && this.getResultType().isMapType();
        }
        return this.isMapMapping;
    }

    public boolean isEnumMapping() {
        if (this.isEnumMapping == null) {
            this.isEnumMapping = this.getSourceParameters().size() == 1 && Collections.first(this.getSourceParameters()).getType().isEnumType() && this.getResultType().isEnumType();
        }
        return this.isEnumMapping;
    }

    public boolean isBeanMapping() {
        if (this.isBeanMapping == null) {
            this.isBeanMapping = !this.isIterableMapping() && !this.isMapMapping() && !this.isEnumMapping() && !this.isValueMapping() && !this.isStreamMapping();
        }
        return this.isBeanMapping;
    }

    public boolean isValueMapping() {
        if (this.isValueMapping == null) {
            this.isValueMapping = this.isEnumMapping() && this.mappingOptions.getMappings().isEmpty();
        }
        return this.isValueMapping;
    }

    private boolean equals(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o1.equals(o2);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.returnType.toString());
        sb.append(" ");
        if (this.declaringMapper != null) {
            sb.append(this.declaringMapper).append(".");
        }
        sb.append(this.getName()).append("(").append(Strings.join(this.parameters, ", ")).append(")");
        return sb.toString();
    }

    public List<Mapping> getMappingBySourcePropertyName(String sourcePropertyName) {
        ArrayList<Mapping> mappingsOfSourceProperty = new ArrayList<Mapping>();
        for (List<Mapping> mappingOfProperty : this.mappingOptions.getMappings().values()) {
            for (Mapping mapping : mappingOfProperty) {
                if (this.isEnumMapping()) {
                    if (!mapping.getSourceName().equals(sourcePropertyName)) continue;
                    mappingsOfSourceProperty.add(mapping);
                    continue;
                }
                List<PropertyEntry> sourceEntries = mapping.getSourceReference().getPropertyEntries();
                if (sourceEntries.size() != 1 || !sourcePropertyName.equals(Collections.first(sourceEntries).getName())) continue;
                mappingsOfSourceProperty.add(mapping);
            }
        }
        return mappingsOfSourceProperty;
    }

    public Parameter getSourceParameter(String sourceParameterName) {
        for (Parameter parameter : this.getSourceParameters()) {
            if (!parameter.getName().equals(sourceParameterName)) continue;
            return parameter;
        }
        return null;
    }

    public List<SourceMethod> getApplicablePrototypeMethods() {
        if (this.applicablePrototypeMethods == null) {
            this.applicablePrototypeMethods = new ArrayList<SourceMethod>();
            for (SourceMethod prototype : this.prototypeMethods) {
                if (!this.canInheritFrom(prototype)) continue;
                this.applicablePrototypeMethods.add(prototype);
            }
        }
        return this.applicablePrototypeMethods;
    }

    private static boolean allParametersAreAssignable(List<Parameter> fromParams, List<Parameter> toParams) {
        if (fromParams.size() == toParams.size()) {
            HashSet<Parameter> unaccountedToParams = new HashSet<Parameter>(toParams);
            for (Parameter fromParam : fromParams) {
                boolean hasMatch = false;
                for (Parameter toParam : toParams) {
                    if (!fromParam.getType().isAssignableTo(toParam.getType())) continue;
                    unaccountedToParams.remove(toParam);
                    hasMatch = true;
                }
                if (hasMatch) continue;
                return false;
            }
            return unaccountedToParams.isEmpty();
        }
        return false;
    }

    @Override
    public boolean overridesMethod() {
        return this.declaringMapper == null && this.executable.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    @Override
    public boolean matches(List<Type> sourceTypes, Type targetType) {
        MethodMatcher matcher = new MethodMatcher(this.typeUtils, this.typeFactory, this);
        return matcher.matches(sourceTypes, targetType);
    }

    public static boolean containsTargetTypeParameter(List<Parameter> parameters) {
        for (Parameter param : parameters) {
            if (!param.isTargetType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Type> getThrownTypes() {
        return this.exceptionTypes;
    }

    @Override
    public MappingOptions getMappingOptions() {
        return this.mappingOptions;
    }

    @Override
    public boolean isStatic() {
        return this.executable.getModifiers().contains((Object)Modifier.STATIC);
    }

    @Override
    public boolean isDefault() {
        return Executables.isDefaultMethod(this.executable);
    }

    @Override
    public Type getDefiningType() {
        return this.mapperToImplement;
    }

    @Override
    public MapperConfiguration getMapperConfiguration() {
        return this.config;
    }

    @Override
    public boolean isLifecycleCallbackMethod() {
        return Executables.isLifecycleCallbackMethod(this.getExecutable());
    }

    public boolean isAfterMappingMethod() {
        return Executables.isAfterMappingMethod(this.getExecutable());
    }

    public boolean isBeforeMappingMethod() {
        return Executables.isBeforeMappingMethod(this.getExecutable());
    }

    public boolean isAbstract() {
        return this.executable.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    @Override
    public boolean isUpdateMethod() {
        return this.getMappingTargetParameter() != null;
    }

    public static class Builder {
        private Type declaringMapper = null;
        private Type definingType = null;
        private ExecutableElement executable;
        private List<Parameter> parameters;
        private Type returnType = null;
        private List<Type> exceptionTypes;
        private Map<String, List<Mapping>> mappings;
        private IterableMapping iterableMapping = null;
        private MapMapping mapMapping = null;
        private BeanMapping beanMapping = null;
        private Types typeUtils;
        private TypeFactory typeFactory = null;
        private FormattingMessager messager = null;
        private MapperConfiguration mapperConfig = null;
        private List<SourceMethod> prototypeMethods = java.util.Collections.emptyList();
        private List<ValueMapping> valueMappings;
        private ParameterProvidedMethods contextProvidedMethods;

        public Builder setDeclaringMapper(Type declaringMapper) {
            this.declaringMapper = declaringMapper;
            return this;
        }

        public Builder setExecutable(ExecutableElement executable) {
            this.executable = executable;
            return this;
        }

        public Builder setParameters(List<Parameter> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder setReturnType(Type returnType) {
            this.returnType = returnType;
            return this;
        }

        public Builder setExceptionTypes(List<Type> exceptionTypes) {
            this.exceptionTypes = exceptionTypes;
            return this;
        }

        public Builder setMappings(Map<String, List<Mapping>> mappings) {
            this.mappings = mappings;
            return this;
        }

        public Builder setIterableMapping(IterableMapping iterableMapping) {
            this.iterableMapping = iterableMapping;
            return this;
        }

        public Builder setMapMapping(MapMapping mapMapping) {
            this.mapMapping = mapMapping;
            return this;
        }

        public Builder setBeanMapping(BeanMapping beanMapping) {
            this.beanMapping = beanMapping;
            return this;
        }

        public Builder setValueMappings(List<ValueMapping> valueMappings) {
            this.valueMappings = valueMappings;
            return this;
        }

        public Builder setTypeUtils(Types typeUtils) {
            this.typeUtils = typeUtils;
            return this;
        }

        public Builder setTypeFactory(TypeFactory typeFactory) {
            this.typeFactory = typeFactory;
            return this;
        }

        public Builder setMessager(FormattingMessager messager) {
            this.messager = messager;
            return this;
        }

        public Builder setMapperConfiguration(MapperConfiguration mapperConfig) {
            this.mapperConfig = mapperConfig;
            return this;
        }

        public Builder setPrototypeMethods(List<SourceMethod> prototypeMethods) {
            this.prototypeMethods = prototypeMethods;
            return this;
        }

        public Builder setDefininingType(Type definingType) {
            this.definingType = definingType;
            return this;
        }

        public Builder setContextProvidedMethods(ParameterProvidedMethods contextProvidedMethods) {
            this.contextProvidedMethods = contextProvidedMethods;
            return this;
        }

        public SourceMethod build() {
            MappingOptions mappingOptions = new MappingOptions(this.mappings, this.iterableMapping, this.mapMapping, this.beanMapping, this.valueMappings, false);
            SourceMethod sourceMethod = new SourceMethod(this, mappingOptions);
            if (this.mappings != null) {
                for (Map.Entry<String, List<Mapping>> entry : this.mappings.entrySet()) {
                    for (Mapping mapping : entry.getValue()) {
                        mapping.init(sourceMethod, this.messager, this.typeFactory, false);
                    }
                }
            }
            return sourceMethod;
        }
    }
}

