/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.Arrays;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.util.Strings;
import org.mapstruct.ap.internal.util.accessor.Accessor;
import org.mapstruct.ap.internal.util.accessor.ExecutableElementAccessor;

public class PropertyEntry {
    private final String[] fullName;
    private final Accessor readAccessor;
    private final Accessor writeAccessor;
    private final ExecutableElementAccessor presenceChecker;
    private final Type type;

    private PropertyEntry(String[] fullName, Accessor readAccessor, Accessor writeAccessor, ExecutableElementAccessor presenceChecker, Type type) {
        this.fullName = fullName;
        this.readAccessor = readAccessor;
        this.writeAccessor = writeAccessor;
        this.presenceChecker = presenceChecker;
        this.type = type;
    }

    public static PropertyEntry forTargetReference(String[] fullName, Accessor readAccessor, Accessor writeAccessor, Type type) {
        return new PropertyEntry(fullName, readAccessor, writeAccessor, null, type);
    }

    public static PropertyEntry forSourceReference(String name, Accessor readAccessor, ExecutableElementAccessor presenceChecker, Type type) {
        return new PropertyEntry(new String[]{name}, readAccessor, null, presenceChecker, type);
    }

    public String getName() {
        return this.fullName[this.fullName.length - 1];
    }

    public Accessor getReadAccessor() {
        return this.readAccessor;
    }

    public Accessor getWriteAccessor() {
        return this.writeAccessor;
    }

    public ExecutableElementAccessor getPresenceChecker() {
        return this.presenceChecker;
    }

    public Type getType() {
        return this.type;
    }

    public String getFullName() {
        return Strings.join(Arrays.asList(this.fullName), ".");
    }

    public PropertyEntry pop() {
        if (this.fullName.length > 1) {
            String[] newFullName = Arrays.copyOfRange(this.fullName, 1, this.fullName.length);
            return new PropertyEntry(newFullName, this.readAccessor, this.writeAccessor, this.presenceChecker, this.type);
        }
        return null;
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + Arrays.deepHashCode(this.fullName);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyEntry other = (PropertyEntry)obj;
        return Arrays.deepEquals(this.fullName, other.fullName);
    }
}

