/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.mapstruct.ap.internal.model.DecoratorConstructor;
import org.mapstruct.ap.internal.model.Field;
import org.mapstruct.ap.internal.model.GeneratedType;
import org.mapstruct.ap.internal.model.Mapper;
import org.mapstruct.ap.internal.model.MappingMethod;
import org.mapstruct.ap.internal.model.common.Accessibility;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.option.Options;
import org.mapstruct.ap.internal.prism.DecoratedWithPrism;
import org.mapstruct.ap.internal.version.VersionInformation;

public class Decorator
extends GeneratedType {
    private final Type decoratorType;

    private Decorator(TypeFactory typeFactory, String packageName, String name, Type decoratorType, String interfacePackage, String interfaceName, List<MappingMethod> methods, List<? extends Field> fields, Options options, VersionInformation versionInformation, Accessibility accessibility, SortedSet<Type> extraImports, DecoratorConstructor decoratorConstructor) {
        super(typeFactory, packageName, name, decoratorType.getName(), interfacePackage, interfaceName, methods, fields, options, versionInformation, accessibility, extraImports, decoratorConstructor);
        this.decoratorType = decoratorType;
    }

    @Override
    public SortedSet<Type> getImportTypes() {
        Set importTypes = super.getImportTypes();
        this.addIfImportRequired(importTypes, this.decoratorType);
        return importTypes;
    }

    @Override
    protected String getTemplateName() {
        return this.getTemplateNameForClass(GeneratedType.class);
    }

    public static class Builder {
        private Elements elementUtils;
        private TypeFactory typeFactory;
        private TypeElement mapperElement;
        private DecoratedWithPrism decoratorPrism;
        private List<MappingMethod> methods;
        private Options options;
        private VersionInformation versionInformation;
        private boolean hasDelegateConstructor;
        private String implName;
        private String implPackage;
        private SortedSet<Type> extraImportedTypes;

        public Builder elementUtils(Elements elementUtils) {
            this.elementUtils = elementUtils;
            return this;
        }

        public Builder typeFactory(TypeFactory typeFactory) {
            this.typeFactory = typeFactory;
            return this;
        }

        public Builder mapperElement(TypeElement mapperElement) {
            this.mapperElement = mapperElement;
            return this;
        }

        public Builder decoratorPrism(DecoratedWithPrism decoratorPrism) {
            this.decoratorPrism = decoratorPrism;
            return this;
        }

        public Builder methods(List<MappingMethod> methods) {
            this.methods = methods;
            return this;
        }

        public Builder options(Options options) {
            this.options = options;
            return this;
        }

        public Builder versionInformation(VersionInformation versionInformation) {
            this.versionInformation = versionInformation;
            return this;
        }

        public Builder hasDelegateConstructor(boolean hasDelegateConstructor) {
            this.hasDelegateConstructor = hasDelegateConstructor;
            return this;
        }

        public Builder implName(String implName) {
            this.implName = "default".equals(implName) ? "<CLASS_NAME>Impl" : implName;
            return this;
        }

        public Builder implPackage(String implPackage) {
            this.implPackage = "default".equals(implPackage) ? "<PACKAGE_NAME>" : implPackage;
            return this;
        }

        public Builder extraImports(SortedSet<Type> extraImportedTypes) {
            this.extraImportedTypes = extraImportedTypes;
            return this;
        }

        public Decorator build() {
            String implementationName = this.implName.replace("<CLASS_NAME>", Mapper.getFlatName(this.mapperElement));
            Type decoratorType = this.typeFactory.getType(this.decoratorPrism.value());
            DecoratorConstructor decoratorConstructor = new DecoratorConstructor(implementationName, implementationName + "_", this.hasDelegateConstructor);
            String elementPackage = this.elementUtils.getPackageOf(this.mapperElement).getQualifiedName().toString();
            String packageName = this.implPackage.replace("<PACKAGE_NAME>", elementPackage);
            return new Decorator(this.typeFactory, packageName, implementationName, decoratorType, elementPackage, this.mapperElement.getKind() == ElementKind.INTERFACE ? this.mapperElement.getSimpleName().toString() : null, this.methods, Arrays.asList(new Field(this.typeFactory.getType(this.mapperElement), "delegate", true)), this.options, this.versionInformation, Accessibility.fromModifiers(this.mapperElement.getModifiers()), this.extraImportedTypes, decoratorConstructor);
        }
    }
}

