/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.conversion;

import java.util.Date;
import java.util.Set;
import org.mapstruct.ap.internal.conversion.ConversionUtils;
import org.mapstruct.ap.internal.conversion.SimpleConversion;
import org.mapstruct.ap.internal.model.common.ConversionContext;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.util.Collections;

public class JavaLocalDateTimeToDateConversion
extends SimpleConversion {
    @Override
    protected String getToExpression(ConversionContext conversionContext) {
        return ConversionUtils.date(conversionContext) + ".from( <SOURCE>.toInstant( " + ConversionUtils.zoneOffset(conversionContext) + ".UTC ) )";
    }

    @Override
    protected Set<Type> getToConversionImportTypes(ConversionContext conversionContext) {
        return Collections.asSet(conversionContext.getTypeFactory().getType(Date.class), conversionContext.getTypeFactory().getType("java.time.ZoneOffset"));
    }

    @Override
    protected String getFromExpression(ConversionContext conversionContext) {
        return ConversionUtils.localDateTime(conversionContext) + ".ofInstant( <SOURCE>.toInstant(), " + ConversionUtils.zoneId(conversionContext) + ".of( \"UTC\" ) )";
    }

    @Override
    protected Set<Type> getFromConversionImportTypes(ConversionContext conversionContext) {
        return Collections.asSet(conversionContext.getTypeFactory().getType("java.time.LocalDateTime"), conversionContext.getTypeFactory().getType("java.time.ZoneId"));
    }
}

