/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.mapstruct.ap.internal.model.AbstractMappingMethodBuilder;
import org.mapstruct.ap.internal.model.ContainerMappingMethod;
import org.mapstruct.ap.internal.model.LifecycleCallbackMethodReference;
import org.mapstruct.ap.internal.model.LifecycleMethodResolver;
import org.mapstruct.ap.internal.model.MethodReference;
import org.mapstruct.ap.internal.model.ObjectFactoryMethodResolver;
import org.mapstruct.ap.internal.model.common.Assignment;
import org.mapstruct.ap.internal.model.common.FormattingParameters;
import org.mapstruct.ap.internal.model.common.SourceRHS;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.ForgedMethod;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.prism.NullValueMappingStrategyPrism;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.Strings;

public abstract class ContainerMappingMethodBuilder<B extends ContainerMappingMethodBuilder<B, M>, M extends ContainerMappingMethod>
extends AbstractMappingMethodBuilder<B, M> {
    private SelectionParameters selectionParameters;
    private FormattingParameters formattingParameters;
    private NullValueMappingStrategyPrism nullValueMappingStrategy;
    private String errorMessagePart;
    private String callingContextTargetPropertyName;

    ContainerMappingMethodBuilder(Class<B> selfType, String errorMessagePart) {
        super(selfType);
        this.errorMessagePart = errorMessagePart;
    }

    public B formattingParameters(FormattingParameters formattingParameters) {
        this.formattingParameters = formattingParameters;
        return (B)((ContainerMappingMethodBuilder)this.myself);
    }

    public B selectionParameters(SelectionParameters selectionParameters) {
        this.selectionParameters = selectionParameters;
        return (B)((ContainerMappingMethodBuilder)this.myself);
    }

    public B nullValueMappingStrategy(NullValueMappingStrategyPrism nullValueMappingStrategy) {
        this.nullValueMappingStrategy = nullValueMappingStrategy;
        return (B)((ContainerMappingMethodBuilder)this.myself);
    }

    public B callingContextTargetPropertyName(String callingContextTargetPropertyName) {
        this.callingContextTargetPropertyName = callingContextTargetPropertyName;
        return (B)((ContainerMappingMethodBuilder)this.myself);
    }

    @Override
    public final M build() {
        Type sourceParameterType = Collections.first(this.method.getSourceParameters()).getType();
        Type resultType = this.method.getResultType();
        Type sourceElementType = this.getElementType(sourceParameterType);
        Type targetElementType = this.getElementType(resultType);
        String loopVariableName = Strings.getSaveVariableName(sourceElementType.getName(), this.method.getParameterNames());
        SourceRHS sourceRHS = new SourceRHS(loopVariableName, sourceElementType, new HashSet<String>(), this.errorMessagePart);
        Assignment assignment = this.ctx.getMappingResolver().getTargetAssignment(this.method, targetElementType, this.callingContextTargetPropertyName, this.formattingParameters, this.selectionParameters, sourceRHS, false);
        if (assignment == null) {
            assignment = this.forgeMapping(sourceRHS, sourceElementType, targetElementType);
        }
        if (assignment == null) {
            if (this.method instanceof ForgedMethod) {
                return null;
            }
            this.reportCannotCreateMapping(this.method, String.format("%s \"%s\"", sourceRHS.getSourceErrorMessagePart(), sourceRHS.getSourceType()), sourceRHS.getSourceType(), targetElementType, "");
        } else if (this.method instanceof ForgedMethod) {
            ForgedMethod forgedMethod = (ForgedMethod)this.method;
            forgedMethod.addThrownTypes(assignment.getThrownTypes());
        }
        assignment = this.getWrapper(assignment, this.method);
        boolean mapNullToDefault = false;
        if (this.method.getMapperConfiguration() != null) {
            mapNullToDefault = this.method.getMapperConfiguration().isMapToDefault(this.nullValueMappingStrategy);
        }
        MethodReference factoryMethod = null;
        if (!this.method.isUpdateMethod()) {
            factoryMethod = ObjectFactoryMethodResolver.getFactoryMethod(this.method, this.method.getResultType(), null, this.ctx);
        }
        HashSet<String> existingVariables = new HashSet<String>(this.method.getParameterNames());
        existingVariables.add(loopVariableName);
        List<LifecycleCallbackMethodReference> beforeMappingMethods = LifecycleMethodResolver.beforeMappingMethods(this.method, this.selectionParameters, this.ctx, existingVariables);
        List<LifecycleCallbackMethodReference> afterMappingMethods = LifecycleMethodResolver.afterMappingMethods(this.method, this.selectionParameters, this.ctx, existingVariables);
        return this.instantiateMappingMethod(this.method, existingVariables, assignment, factoryMethod, mapNullToDefault, loopVariableName, beforeMappingMethods, afterMappingMethods, this.selectionParameters);
    }

    protected abstract M instantiateMappingMethod(Method var1, Collection<String> var2, Assignment var3, MethodReference var4, boolean var5, String var6, List<LifecycleCallbackMethodReference> var7, List<LifecycleCallbackMethodReference> var8, SelectionParameters var9);

    protected abstract Type getElementType(Type var1);

    protected abstract Assignment getWrapper(Assignment var1, Method var2);

    @Override
    protected boolean shouldUsePropertyNamesInHistory() {
        return false;
    }
}

