/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.MappingMethod;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.ForgedMethod;
import org.mapstruct.ap.internal.model.source.PropertyEntry;
import org.mapstruct.ap.internal.util.Strings;
import org.mapstruct.ap.internal.util.ValueProvider;

public class NestedPropertyMappingMethod
extends MappingMethod {
    private final List<SafePropertyEntry> safePropertyEntries;

    private NestedPropertyMappingMethod(ForgedMethod method, List<SafePropertyEntry> sourcePropertyEntries) {
        super(method);
        this.safePropertyEntries = sourcePropertyEntries;
    }

    public Parameter getSourceParameter() {
        for (Parameter parameter : this.getParameters()) {
            if (parameter.isMappingTarget() || parameter.isMappingContext()) continue;
            return parameter;
        }
        throw new IllegalStateException("Method " + this + " has no source parameter.");
    }

    public List<SafePropertyEntry> getPropertyEntries() {
        return this.safePropertyEntries;
    }

    @Override
    public Set<Type> getImportTypes() {
        Set<Type> types = super.getImportTypes();
        for (SafePropertyEntry propertyEntry : this.safePropertyEntries) {
            types.add(propertyEntry.getType());
        }
        return types;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getReturnType() == null ? 0 : this.getReturnType().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NestedPropertyMappingMethod other = (NestedPropertyMappingMethod)obj;
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getSourceParameters().size() != other.getSourceParameters().size()) {
            return false;
        }
        for (int i = 0; i < this.getSourceParameters().size(); ++i) {
            if (this.getSourceParameters().get(i).getType().equals(other.getSourceParameters().get(i).getType())) continue;
            return false;
        }
        return this.safePropertyEntries.equals(other.safePropertyEntries);
    }

    public static class SafePropertyEntry {
        private final String safeName;
        private final String readAccessorName;
        private final String presenceCheckerName;
        private final Type type;

        public SafePropertyEntry(PropertyEntry entry, String safeName) {
            this.safeName = safeName;
            this.readAccessorName = ValueProvider.of(entry.getReadAccessor()).getValue();
            this.presenceCheckerName = entry.getPresenceChecker() != null ? entry.getPresenceChecker().getSimpleName().toString() : null;
            this.type = entry.getType();
        }

        public String getName() {
            return this.safeName;
        }

        public String getAccessorName() {
            return this.readAccessorName;
        }

        public String getPresenceCheckerName() {
            return this.presenceCheckerName;
        }

        public Type getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SafePropertyEntry)) {
                return false;
            }
            SafePropertyEntry that = (SafePropertyEntry)o;
            if (this.readAccessorName != null ? !this.readAccessorName.equals(that.readAccessorName) : that.readAccessorName != null) {
                return false;
            }
            if (this.presenceCheckerName != null ? !this.presenceCheckerName.equals(that.presenceCheckerName) : that.presenceCheckerName != null) {
                return false;
            }
            return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
        }

        public int hashCode() {
            int result = this.readAccessorName != null ? this.readAccessorName.hashCode() : 0;
            result = 31 * result + (this.presenceCheckerName != null ? this.presenceCheckerName.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }
    }

    public static class Builder {
        private MappingBuilderContext ctx;
        private ForgedMethod method;
        private List<PropertyEntry> propertyEntries;

        public Builder method(ForgedMethod sourceMethod) {
            this.method = sourceMethod;
            return this;
        }

        public Builder propertyEntries(List<PropertyEntry> propertyEntries) {
            this.propertyEntries = propertyEntries;
            return this;
        }

        public Builder mappingContext(MappingBuilderContext mappingContext) {
            this.ctx = mappingContext;
            return this;
        }

        public NestedPropertyMappingMethod build() {
            ArrayList<String> existingVariableNames = new ArrayList<String>();
            for (Parameter parameter : this.method.getSourceParameters()) {
                existingVariableNames.add(parameter.getName());
            }
            ArrayList<Type> thrownTypes = new ArrayList<Type>();
            ArrayList<SafePropertyEntry> safePropertyEntries = new ArrayList<SafePropertyEntry>();
            for (PropertyEntry propertyEntry : this.propertyEntries) {
                String safeName = Strings.getSaveVariableName(propertyEntry.getName(), existingVariableNames);
                safePropertyEntries.add(new SafePropertyEntry(propertyEntry, safeName));
                existingVariableNames.add(safeName);
                thrownTypes.addAll(this.ctx.getTypeFactory().getThrownTypes(propertyEntry.getReadAccessor()));
            }
            this.method.addThrownTypes(thrownTypes);
            return new NestedPropertyMappingMethod(this.method, safePropertyEntries);
        }
    }
}

