/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.prism;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.mapstruct.ap.internal.prism.BuilderPrism;

public class BeanMappingPrism {
    private TypeMirror _resultType;
    private List<TypeMirror> _qualifiedBy;
    private List<String> _qualifiedByName;
    private String _nullValueMappingStrategy;
    private Boolean _ignoreByDefault;
    private List<String> _ignoreUnmappedSourceProperties;
    private BuilderPrism _builder;
    public final Values values;
    public final boolean isValid;
    public final AnnotationMirror mirror;
    private Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
    private Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
    private boolean valid = true;

    public static BeanMappingPrism getInstanceOn(Element e) {
        AnnotationMirror m = BeanMappingPrism.getMirror("org.mapstruct.BeanMapping", e);
        if (m == null) {
            return null;
        }
        return BeanMappingPrism.getInstance(m);
    }

    public static BeanMappingPrism getInstance(AnnotationMirror mirror) {
        return new BeanMappingPrism(mirror);
    }

    private BeanMappingPrism(AnnotationMirror mirror) {
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
        }
        this._resultType = this.getValue("resultType", TypeMirror.class);
        this._qualifiedBy = this.getArrayValues("qualifiedBy", TypeMirror.class);
        this._qualifiedByName = this.getArrayValues("qualifiedByName", String.class);
        VariableElement nullValueMappingStrategyMirror = this.getValue("nullValueMappingStrategy", VariableElement.class);
        this.valid = this.valid && nullValueMappingStrategyMirror != null;
        this._nullValueMappingStrategy = nullValueMappingStrategyMirror == null ? null : nullValueMappingStrategyMirror.getSimpleName().toString();
        this._ignoreByDefault = this.getValue("ignoreByDefault", Boolean.class);
        this._ignoreUnmappedSourceProperties = this.getArrayValues("ignoreUnmappedSourceProperties", String.class);
        AnnotationMirror annotationMirror = this.getValue("builder", AnnotationMirror.class);
        this.valid = this.valid && annotationMirror != null;
        this._builder = annotationMirror == null ? null : BuilderPrism.getInstance(annotationMirror);
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    public TypeMirror resultType() {
        return this._resultType;
    }

    public List<TypeMirror> qualifiedBy() {
        return this._qualifiedBy;
    }

    public List<String> qualifiedByName() {
        return this._qualifiedByName;
    }

    public String nullValueMappingStrategy() {
        return this._nullValueMappingStrategy;
    }

    public Boolean ignoreByDefault() {
        return this._ignoreByDefault;
    }

    public List<String> ignoreUnmappedSourceProperties() {
        return this._ignoreUnmappedSourceProperties;
    }

    public BuilderPrism builder() {
        return this._builder;
    }

    private <T> T getValue(String name, Class<T> clazz) {
        T result = BeanMappingPrism.getValue(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private <T> List<T> getArrayValues(String name, Class<T> clazz) {
        List<T> result = BeanMappingPrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private static AnnotationMirror getMirror(String fqn, Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!fqn.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static <T> T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (clazz.isInstance(av.getValue())) {
            return clazz.cast(av.getValue());
        }
        return null;
    }

    private static <T> List<T> getArrayValues(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (av.getValue() instanceof List) {
            ArrayList<T> result = new ArrayList<T>();
            for (AnnotationValue v : BeanMappingPrism.getValueAsList(av)) {
                if (clazz.isInstance(v.getValue())) {
                    result.add(clazz.cast(v.getValue()));
                    continue;
                }
                return null;
            }
            return result;
        }
        return null;
    }

    private static List<AnnotationValue> getValueAsList(AnnotationValue av) {
        return (List)av.getValue();
    }

    public static class Values {
        private Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }

        public AnnotationValue resultType() {
            return this.values.get("resultType");
        }

        public AnnotationValue qualifiedBy() {
            return this.values.get("qualifiedBy");
        }

        public AnnotationValue qualifiedByName() {
            return this.values.get("qualifiedByName");
        }

        public AnnotationValue nullValueMappingStrategy() {
            return this.values.get("nullValueMappingStrategy");
        }

        public AnnotationValue ignoreByDefault() {
            return this.values.get("ignoreByDefault");
        }

        public AnnotationValue ignoreUnmappedSourceProperties() {
            return this.values.get("ignoreUnmappedSourceProperties");
        }

        public AnnotationValue builder() {
            return this.values.get("builder");
        }
    }
}

