/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.spi;

import java.beans.Introspector;
import java.util.regex.Pattern;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.mapstruct.ap.spi.AccessorNamingStrategy;
import org.mapstruct.ap.spi.MethodType;

public class DefaultAccessorNamingStrategy
implements AccessorNamingStrategy {
    private static final Pattern JAVA_JAVAX_PACKAGE = Pattern.compile("^javax?\\..*");

    @Override
    public MethodType getMethodType(ExecutableElement method) {
        if (this.isGetterMethod(method)) {
            return MethodType.GETTER;
        }
        if (this.isSetterMethod(method)) {
            return MethodType.SETTER;
        }
        if (this.isAdderMethod(method)) {
            return MethodType.ADDER;
        }
        if (this.isPresenceCheckMethod(method)) {
            return MethodType.PRESENCE_CHECKER;
        }
        return MethodType.OTHER;
    }

    public boolean isGetterMethod(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        boolean isNonBooleanGetterName = methodName.startsWith("get") && methodName.length() > 3 && method.getReturnType().getKind() != TypeKind.VOID;
        boolean isBooleanGetterName = methodName.startsWith("is") && methodName.length() > 2;
        boolean returnTypeIsBoolean = method.getReturnType().getKind() == TypeKind.BOOLEAN || "java.lang.Boolean".equals(DefaultAccessorNamingStrategy.getQualifiedName(method.getReturnType()));
        return isNonBooleanGetterName || isBooleanGetterName && returnTypeIsBoolean;
    }

    public boolean isSetterMethod(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        return methodName.startsWith("set") && methodName.length() > 3 || this.isBuilderSetter(method);
    }

    protected boolean isBuilderSetter(ExecutableElement method) {
        return method.getParameters().size() == 1 && !JAVA_JAVAX_PACKAGE.matcher(method.getEnclosingElement().asType().toString()).matches() && !this.isAdderWithUpperCase4thCharacter(method) && method.getReturnType().toString().equals(method.getEnclosingElement().asType().toString());
    }

    private boolean isAdderWithUpperCase4thCharacter(ExecutableElement method) {
        return this.isAdderMethod(method) && Character.isUpperCase(method.getSimpleName().toString().charAt(3));
    }

    public boolean isAdderMethod(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        return methodName.startsWith("add") && methodName.length() > 3;
    }

    public boolean isPresenceCheckMethod(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        return methodName.startsWith("has") && methodName.length() > 3;
    }

    @Override
    public String getPropertyName(ExecutableElement getterOrSetterMethod) {
        String methodName = getterOrSetterMethod.getSimpleName().toString();
        if (methodName.startsWith("is") || methodName.startsWith("get") || methodName.startsWith("set")) {
            return Introspector.decapitalize(methodName.substring(methodName.startsWith("is") ? 2 : 3));
        }
        if (this.isBuilderSetter(getterOrSetterMethod)) {
            return methodName;
        }
        return Introspector.decapitalize(methodName.substring(methodName.startsWith("is") ? 2 : 3));
    }

    @Override
    public String getElementName(ExecutableElement adderMethod) {
        String methodName = adderMethod.getSimpleName().toString();
        return Introspector.decapitalize(methodName.substring(3));
    }

    protected static String getQualifiedName(TypeMirror type) {
        DeclaredType declaredType = type.accept(new SimpleTypeVisitor6<DeclaredType, Void>(){

            @Override
            public DeclaredType visitDeclared(DeclaredType t, Void p) {
                return t;
            }
        }, null);
        if (declaredType == null) {
            return null;
        }
        TypeElement typeElement = declaredType.asElement().accept(new SimpleElementVisitor6<TypeElement, Void>(){

            @Override
            public TypeElement visitType(TypeElement e, Void p) {
                return e;
            }
        }, null);
        return typeElement != null ? typeElement.getQualifiedName().toString() : null;
    }

    @Override
    public String getCollectionGetterName(String property) {
        throw new IllegalStateException("This method is not intended to be called anymore and will be removed in future versions.");
    }
}

