/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import javax.lang.model.element.TypeElement;
import org.mapstruct.ap.internal.model.AnnotatedConstructor;
import org.mapstruct.ap.internal.model.Annotation;
import org.mapstruct.ap.internal.model.AnnotationMapperReference;
import org.mapstruct.ap.internal.model.Decorator;
import org.mapstruct.ap.internal.model.Field;
import org.mapstruct.ap.internal.model.Mapper;
import org.mapstruct.ap.internal.model.MapperReference;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.prism.InjectionStrategyPrism;
import org.mapstruct.ap.internal.processor.ModelElementProcessor;
import org.mapstruct.ap.internal.util.MapperConfiguration;

public abstract class AnnotationBasedComponentModelProcessor
implements ModelElementProcessor<Mapper, Mapper> {
    private TypeFactory typeFactory;

    @Override
    public Mapper process(ModelElementProcessor.ProcessorContext context, TypeElement mapperTypeElement, Mapper mapper) {
        this.typeFactory = context.getTypeFactory();
        MapperConfiguration mapperConfiguration = MapperConfiguration.getInstanceOn(mapperTypeElement);
        String componentModel = mapperConfiguration.componentModel(context.getOptions());
        InjectionStrategyPrism injectionStrategy = mapperConfiguration.getInjectionStrategy();
        if (!this.getComponentModelIdentifier().equalsIgnoreCase(componentModel)) {
            return mapper;
        }
        for (Annotation typeAnnotation : this.getTypeAnnotations(mapper)) {
            mapper.addAnnotation(typeAnnotation);
        }
        if (!this.requiresGenerationOfDecoratorClass()) {
            mapper.removeDecorator();
        } else if (mapper.getDecorator() != null) {
            this.adjustDecorator(mapper, injectionStrategy);
        }
        List<Annotation> annotations = this.getMapperReferenceAnnotations();
        ListIterator<Field> iterator = mapper.getFields().listIterator();
        while (iterator.hasNext()) {
            Field reference = iterator.next();
            if (!(reference instanceof MapperReference)) continue;
            iterator.remove();
            iterator.add(this.replacementMapperReference(reference, annotations, injectionStrategy));
        }
        if (injectionStrategy == InjectionStrategyPrism.CONSTRUCTOR) {
            this.buildConstructors(mapper);
        }
        return mapper;
    }

    protected void adjustDecorator(Mapper mapper, InjectionStrategyPrism injectionStrategy) {
        Decorator decorator = mapper.getDecorator();
        for (Annotation typeAnnotation : this.getDecoratorAnnotations()) {
            decorator.addAnnotation(typeAnnotation);
        }
        decorator.removeConstructor();
        List<Annotation> annotations = this.getDelegatorReferenceAnnotations(mapper);
        ArrayList<Field> replacement = new ArrayList<Field>();
        if (!decorator.getMethods().isEmpty()) {
            for (Field field : decorator.getFields()) {
                replacement.add(this.replacementMapperReference(field, annotations, injectionStrategy));
            }
        }
        decorator.setFields(replacement);
    }

    private List<MapperReference> toMapperReferences(List<Field> fields) {
        ArrayList<MapperReference> mapperReferences = new ArrayList<MapperReference>();
        for (Field field : fields) {
            if (!(field instanceof MapperReference)) continue;
            mapperReferences.add((MapperReference)field);
        }
        return mapperReferences;
    }

    private void buildConstructors(Mapper mapper) {
        AnnotatedConstructor decoratorConstructor;
        Decorator decorator;
        AnnotatedConstructor annotatedConstructor;
        if (!this.toMapperReferences(mapper.getFields()).isEmpty() && !(annotatedConstructor = this.buildAnnotatedConstructorForMapper(mapper)).getMapperReferences().isEmpty()) {
            mapper.setConstructor(annotatedConstructor);
        }
        if ((decorator = mapper.getDecorator()) != null && !(decoratorConstructor = this.buildAnnotatedConstructorForDecorator(decorator)).getMapperReferences().isEmpty()) {
            decorator.setConstructor(decoratorConstructor);
        }
    }

    private AnnotatedConstructor buildAnnotatedConstructorForMapper(Mapper mapper) {
        List<MapperReference> mapperReferences = this.toMapperReferences(mapper.getFields());
        ArrayList<AnnotationMapperReference> mapperReferencesForConstructor = new ArrayList<AnnotationMapperReference>(mapperReferences.size());
        for (MapperReference mapperReference : mapperReferences) {
            if (!mapperReference.isUsed()) continue;
            mapperReferencesForConstructor.add((AnnotationMapperReference)mapperReference);
        }
        List<Annotation> mapperReferenceAnnotations = this.getMapperReferenceAnnotations();
        this.removeDuplicateAnnotations(mapperReferencesForConstructor, mapperReferenceAnnotations);
        return AnnotatedConstructor.forComponentModels(mapper.getName(), mapperReferencesForConstructor, mapperReferenceAnnotations, mapper.getConstructor(), this.additionalPublicEmptyConstructor());
    }

    private AnnotatedConstructor buildAnnotatedConstructorForDecorator(Decorator decorator) {
        ArrayList<AnnotationMapperReference> mapperReferencesForConstructor = new ArrayList<AnnotationMapperReference>(decorator.getFields().size());
        for (Field field : decorator.getFields()) {
            if (!(field instanceof AnnotationMapperReference)) continue;
            mapperReferencesForConstructor.add((AnnotationMapperReference)field);
        }
        List<Annotation> mapperReferenceAnnotations = this.getMapperReferenceAnnotations();
        this.removeDuplicateAnnotations(mapperReferencesForConstructor, mapperReferenceAnnotations);
        return AnnotatedConstructor.forComponentModels(decorator.getName(), mapperReferencesForConstructor, mapperReferenceAnnotations, decorator.getConstructor(), this.additionalPublicEmptyConstructor());
    }

    private void removeDuplicateAnnotations(List<AnnotationMapperReference> annotationMapperReferences, List<Annotation> mapperReferenceAnnotations) {
        ListIterator<AnnotationMapperReference> mapperReferenceIterator = annotationMapperReferences.listIterator();
        HashSet<Type> mapperReferenceAnnotationsTypes = new HashSet<Type>();
        for (Annotation annotation : mapperReferenceAnnotations) {
            mapperReferenceAnnotationsTypes.add(annotation.getType());
        }
        while (mapperReferenceIterator.hasNext()) {
            AnnotationMapperReference annotationMapperReference = mapperReferenceIterator.next();
            mapperReferenceIterator.remove();
            ArrayList<Annotation> qualifiers = new ArrayList<Annotation>();
            for (Annotation annotation : annotationMapperReference.getAnnotations()) {
                if (mapperReferenceAnnotationsTypes.contains(annotation.getType())) continue;
                qualifiers.add(annotation);
            }
            mapperReferenceIterator.add(annotationMapperReference.withNewAnnotations(qualifiers));
        }
    }

    protected boolean additionalPublicEmptyConstructor() {
        return false;
    }

    protected List<Annotation> getDelegatorReferenceAnnotations(Mapper mapper) {
        return Collections.emptyList();
    }

    protected Field replacementMapperReference(Field originalReference, List<Annotation> annotations, InjectionStrategyPrism injectionStrategyPrism) {
        boolean finalField = injectionStrategyPrism == InjectionStrategyPrism.CONSTRUCTOR && !this.additionalPublicEmptyConstructor();
        boolean includeAnnotationsOnField = injectionStrategyPrism == InjectionStrategyPrism.FIELD;
        return new AnnotationMapperReference(originalReference.getType(), originalReference.getVariableName(), annotations, originalReference.isUsed(), finalField, includeAnnotationsOnField);
    }

    protected abstract String getComponentModelIdentifier();

    protected abstract List<Annotation> getTypeAnnotations(Mapper var1);

    protected List<Annotation> getDecoratorAnnotations() {
        return Collections.emptyList();
    }

    protected abstract List<Annotation> getMapperReferenceAnnotations();

    protected abstract boolean requiresGenerationOfDecoratorClass();

    @Override
    public int getPriority() {
        return 1100;
    }

    protected TypeFactory getTypeFactory() {
        return this.typeFactory;
    }
}

