/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.processor;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mapstruct.ap.internal.model.AbstractBaseBuilder;
import org.mapstruct.ap.internal.model.BeanMappingMethod;
import org.mapstruct.ap.internal.model.ContainerMappingMethod;
import org.mapstruct.ap.internal.model.ContainerMappingMethodBuilder;
import org.mapstruct.ap.internal.model.Decorator;
import org.mapstruct.ap.internal.model.DefaultMapperReference;
import org.mapstruct.ap.internal.model.DelegatingMethod;
import org.mapstruct.ap.internal.model.EnumMappingMethod;
import org.mapstruct.ap.internal.model.Field;
import org.mapstruct.ap.internal.model.IterableMappingMethod;
import org.mapstruct.ap.internal.model.MapMappingMethod;
import org.mapstruct.ap.internal.model.Mapper;
import org.mapstruct.ap.internal.model.MapperReference;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.MappingMethod;
import org.mapstruct.ap.internal.model.StreamMappingMethod;
import org.mapstruct.ap.internal.model.SupportingConstructorFragment;
import org.mapstruct.ap.internal.model.SupportingField;
import org.mapstruct.ap.internal.model.ValueMappingMethod;
import org.mapstruct.ap.internal.model.common.FormattingParameters;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.model.source.BeanMapping;
import org.mapstruct.ap.internal.model.source.MappingOptions;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.option.Options;
import org.mapstruct.ap.internal.prism.BuilderPrism;
import org.mapstruct.ap.internal.prism.DecoratedWithPrism;
import org.mapstruct.ap.internal.prism.InheritConfigurationPrism;
import org.mapstruct.ap.internal.prism.InheritInverseConfigurationPrism;
import org.mapstruct.ap.internal.prism.MapperPrism;
import org.mapstruct.ap.internal.prism.MappingInheritanceStrategyPrism;
import org.mapstruct.ap.internal.prism.NullValueMappingStrategyPrism;
import org.mapstruct.ap.internal.processor.ModelElementProcessor;
import org.mapstruct.ap.internal.processor.creation.MappingResolverImpl;
import org.mapstruct.ap.internal.util.AccessorNamingUtils;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.MapperConfiguration;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.Strings;
import org.mapstruct.ap.internal.version.VersionInformation;

public class MapperCreationProcessor
implements ModelElementProcessor<List<SourceMethod>, Mapper> {
    private Elements elementUtils;
    private Types typeUtils;
    private FormattingMessager messager;
    private Options options;
    private VersionInformation versionInformation;
    private TypeFactory typeFactory;
    private AccessorNamingUtils accessorNaming;
    private MappingBuilderContext mappingContext;

    @Override
    public Mapper process(ModelElementProcessor.ProcessorContext context, TypeElement mapperTypeElement, List<SourceMethod> sourceModel) {
        MappingBuilderContext ctx;
        this.elementUtils = context.getElementUtils();
        this.typeUtils = context.getTypeUtils();
        this.messager = context.getMessager();
        this.options = context.getOptions();
        this.versionInformation = context.getVersionInformation();
        this.typeFactory = context.getTypeFactory();
        this.accessorNaming = context.getAccessorNaming();
        MapperConfiguration mapperConfig = MapperConfiguration.getInstanceOn(mapperTypeElement);
        List<MapperReference> mapperReferences = this.initReferencedMappers(mapperTypeElement, mapperConfig);
        this.mappingContext = ctx = new MappingBuilderContext(this.typeFactory, this.elementUtils, this.typeUtils, this.messager, this.accessorNaming, this.options, new MappingResolverImpl(this.messager, this.elementUtils, this.typeUtils, this.typeFactory, new ArrayList<Method>(sourceModel), mapperReferences), mapperTypeElement, java.util.Collections.unmodifiableList(sourceModel), mapperReferences);
        return this.getMapper(mapperTypeElement, mapperConfig, sourceModel);
    }

    @Override
    public int getPriority() {
        return 1000;
    }

    private List<MapperReference> initReferencedMappers(TypeElement element, MapperConfiguration mapperConfig) {
        LinkedList<MapperReference> result = new LinkedList<MapperReference>();
        LinkedList<String> variableNames = new LinkedList<String>();
        for (TypeMirror typeMirror : mapperConfig.uses()) {
            DefaultMapperReference mapperReference = DefaultMapperReference.getInstance(this.typeFactory.getType(typeMirror), MapperPrism.getInstanceOn(this.typeUtils.asElement(typeMirror)) != null, this.typeFactory, variableNames);
            result.add(mapperReference);
            variableNames.add(mapperReference.getVariableName());
        }
        return result;
    }

    private Mapper getMapper(TypeElement element, MapperConfiguration mapperConfig, List<SourceMethod> methods) {
        List<MappingMethod> mappingMethods = this.getMappingMethods(mapperConfig, methods);
        mappingMethods.addAll(this.mappingContext.getUsedSupportedMappings());
        mappingMethods.addAll(this.mappingContext.getMappingsToGenerate());
        ArrayList<Field> fields = new ArrayList<Field>(this.mappingContext.getMapperReferences());
        LinkedHashSet<Field> supportingFieldSet = new LinkedHashSet<Field>();
        SupportingField.addAllFieldsIn(this.mappingContext.getUsedSupportedMappings(), supportingFieldSet);
        fields.addAll(supportingFieldSet);
        LinkedHashSet<SupportingConstructorFragment> constructorFragments = new LinkedHashSet<SupportingConstructorFragment>();
        SupportingConstructorFragment.addAllFragmentsIn(this.mappingContext.getUsedSupportedMappings(), constructorFragments);
        Mapper mapper = ((Mapper.Builder)((Mapper.Builder)((Mapper.Builder)((Mapper.Builder)((Mapper.Builder)((Mapper.Builder)new Mapper.Builder().element(element).methods(mappingMethods)).fields(fields).constructorFragments(constructorFragments).options(this.options)).versionInformation(this.versionInformation)).decorator(this.getDecorator(element, methods, mapperConfig.implementationName(), mapperConfig.implementationPackage())).typeFactory(this.typeFactory)).elementUtils(this.elementUtils)).extraImports(this.getExtraImports(element))).implName(mapperConfig.implementationName()).implPackage(mapperConfig.implementationPackage()).build();
        if (!this.mappingContext.getForgedMethodsUnderCreation().isEmpty()) {
            this.messager.printMessage((Element)element, Message.GENERAL_NOT_ALL_FORGED_CREATED, this.mappingContext.getForgedMethodsUnderCreation().keySet());
        }
        return mapper;
    }

    private Decorator getDecorator(TypeElement element, List<SourceMethod> methods, String implName, String implPackage) {
        DecoratedWithPrism decoratorPrism = DecoratedWithPrism.getInstanceOn(element);
        if (decoratorPrism == null) {
            return null;
        }
        TypeElement decoratorElement = (TypeElement)this.typeUtils.asElement(decoratorPrism.value());
        if (!this.typeUtils.isAssignable(decoratorElement.asType(), element.asType())) {
            this.messager.printMessage((Element)element, decoratorPrism.mirror, Message.DECORATOR_NO_SUBTYPE, new Object[0]);
        }
        ArrayList<MappingMethod> mappingMethods = new ArrayList<MappingMethod>(methods.size());
        for (SourceMethod mappingMethod : methods) {
            boolean implementationRequired = true;
            for (ExecutableElement method : ElementFilter.methodsIn(decoratorElement.getEnclosedElements())) {
                if (!this.elementUtils.overrides(method, mappingMethod.getExecutable(), decoratorElement)) continue;
                implementationRequired = false;
                break;
            }
            Type declaringMapper = mappingMethod.getDeclaringMapper();
            if (!implementationRequired || mappingMethod.isDefault() || mappingMethod.isStatic() || declaringMapper != null && !declaringMapper.equals(this.typeFactory.getType(element))) continue;
            mappingMethods.add(new DelegatingMethod(mappingMethod));
        }
        boolean hasDelegateConstructor = false;
        boolean hasDefaultConstructor = false;
        for (ExecutableElement constructor : ElementFilter.constructorsIn(decoratorElement.getEnclosedElements())) {
            if (constructor.getParameters().isEmpty()) {
                hasDefaultConstructor = true;
                continue;
            }
            if (constructor.getParameters().size() != 1 || !this.typeUtils.isAssignable(element.asType(), Collections.first(constructor.getParameters()).asType())) continue;
            hasDelegateConstructor = true;
        }
        if (!hasDelegateConstructor && !hasDefaultConstructor) {
            this.messager.printMessage((Element)element, decoratorPrism.mirror, Message.DECORATOR_CONSTRUCTOR, new Object[0]);
        }
        Decorator decorator = ((Decorator.Builder)((Decorator.Builder)((Decorator.Builder)((Decorator.Builder)((Decorator.Builder)((Decorator.Builder)new Decorator.Builder().elementUtils(this.elementUtils)).typeFactory(this.typeFactory)).mapperElement(element).decoratorPrism(decoratorPrism).methods(mappingMethods)).hasDelegateConstructor(hasDelegateConstructor).options(this.options)).versionInformation(this.versionInformation)).implName(implName).implPackage(implPackage).extraImports(this.getExtraImports(element))).build();
        return decorator;
    }

    private SortedSet<Type> getExtraImports(TypeElement element) {
        TreeSet<Type> extraImports = new TreeSet<Type>();
        MapperConfiguration mapperConfiguration = MapperConfiguration.getInstanceOn(element);
        for (TypeMirror extraImport : mapperConfiguration.imports()) {
            Type type = this.typeFactory.getType(extraImport);
            extraImports.add(type);
        }
        if (!"default".equals(mapperConfiguration.implementationPackage())) {
            extraImports.add(this.typeFactory.getType(element));
        }
        return extraImports;
    }

    private List<MappingMethod> getMappingMethods(MapperConfiguration mapperConfig, List<SourceMethod> methods) {
        ArrayList<MappingMethod> mappingMethods = new ArrayList<MappingMethod>();
        for (SourceMethod method : methods) {
            Object builder;
            if (!method.overridesMethod()) continue;
            this.mergeInheritedOptions(method, mapperConfig, methods, new ArrayList<SourceMethod>());
            MappingOptions mappingOptions = method.getMappingOptions();
            boolean hasFactoryMethod = false;
            if (method.isIterableMapping()) {
                IterableMappingMethod iterableMappingMethod = this.createWithElementMappingMethod(method, mappingOptions, new IterableMappingMethod.Builder());
                hasFactoryMethod = iterableMappingMethod.getFactoryMethod() != null;
                mappingMethods.add(iterableMappingMethod);
            } else if (method.isMapMapping()) {
                MapMappingMethod mapMappingMethod;
                builder = new MapMappingMethod.Builder();
                SelectionParameters keySelectionParameters = null;
                FormattingParameters keyFormattingParameters = null;
                SelectionParameters valueSelectionParameters = null;
                FormattingParameters valueFormattingParameters = null;
                NullValueMappingStrategyPrism nullValueMappingStrategy = null;
                if (mappingOptions.getMapMapping() != null) {
                    keySelectionParameters = mappingOptions.getMapMapping().getKeySelectionParameters();
                    keyFormattingParameters = mappingOptions.getMapMapping().getKeyFormattingParameters();
                    valueSelectionParameters = mappingOptions.getMapMapping().getValueSelectionParameters();
                    valueFormattingParameters = mappingOptions.getMapMapping().getValueFormattingParameters();
                    nullValueMappingStrategy = mappingOptions.getMapMapping().getNullValueMappingStrategy();
                }
                hasFactoryMethod = (mapMappingMethod = ((MapMappingMethod.Builder)((MapMappingMethod.Builder)((AbstractBaseBuilder)builder).mappingContext(this.mappingContext)).method(method)).keyFormattingParameters(keyFormattingParameters).keySelectionParameters(keySelectionParameters).valueFormattingParameters(valueFormattingParameters).valueSelectionParameters(valueSelectionParameters).nullValueMappingStrategy(nullValueMappingStrategy).build()).getFactoryMethod() != null;
                mappingMethods.add(mapMappingMethod);
            } else if (method.isValueMapping()) {
                ValueMappingMethod valueMappingMethod = new ValueMappingMethod.Builder().mappingContext(this.mappingContext).method(method).valueMappings(mappingOptions.getValueMappings()).build();
                mappingMethods.add(valueMappingMethod);
            } else if (method.isEnumMapping()) {
                this.messager.printMessage((Element)method.getExecutable(), Message.ENUMMAPPING_DEPRECATED, new Object[0]);
                builder = new EnumMappingMethod.Builder();
                EnumMappingMethod enumMappingMethod = ((EnumMappingMethod.Builder)builder).mappingContext(this.mappingContext).sourceMethod(method).build();
                if (enumMappingMethod != null) {
                    mappingMethods.add(enumMappingMethod);
                }
            } else if (method.isStreamMapping()) {
                StreamMappingMethod streamMappingMethod = this.createWithElementMappingMethod(method, mappingOptions, new StreamMappingMethod.Builder());
                hasFactoryMethod = streamMappingMethod.getFactoryMethod() != null || method.getResultType().isStreamType();
                mappingMethods.add(streamMappingMethod);
            } else {
                BuilderPrism builderPrism = BeanMapping.builderPrismFor(method);
                BeanMappingMethod.Builder builder2 = new BeanMappingMethod.Builder();
                BeanMappingMethod beanMappingMethod = builder2.mappingContext(this.mappingContext).sourceMethod(method).returnTypeBuilder(this.typeFactory.builderTypeFor(method.getReturnType(), builderPrism)).build();
                if (beanMappingMethod != null) {
                    hasFactoryMethod = true;
                    mappingMethods.add(beanMappingMethod);
                }
            }
            if (hasFactoryMethod) continue;
            this.reportErrorIfNoImplementationTypeIsRegisteredForInterfaceReturnType(method);
        }
        return mappingMethods;
    }

    private <M extends ContainerMappingMethod> M createWithElementMappingMethod(SourceMethod method, MappingOptions mappingOptions, ContainerMappingMethodBuilder<?, M> builder) {
        FormattingParameters formattingParameters = null;
        SelectionParameters selectionParameters = null;
        NullValueMappingStrategyPrism nullValueMappingStrategy = null;
        if (mappingOptions.getIterableMapping() != null) {
            formattingParameters = mappingOptions.getIterableMapping().getFormattingParameters();
            selectionParameters = mappingOptions.getIterableMapping().getSelectionParameters();
            nullValueMappingStrategy = mappingOptions.getIterableMapping().getNullValueMappingStrategy();
        }
        return (M)((ContainerMappingMethodBuilder)((ContainerMappingMethodBuilder)((ContainerMappingMethodBuilder)((ContainerMappingMethodBuilder)((ContainerMappingMethodBuilder)builder.mappingContext(this.mappingContext)).method(method)).formattingParameters(formattingParameters)).selectionParameters(selectionParameters)).nullValueMappingStrategy(nullValueMappingStrategy)).build();
    }

    private void mergeInheritedOptions(SourceMethod method, MapperConfiguration mapperConfig, List<SourceMethod> availableMethods, List<SourceMethod> initializingMethods) {
        MappingInheritanceStrategyPrism inheritanceStrategy;
        if (initializingMethods.contains(method)) {
            initializingMethods.add(method);
            this.messager.printMessage((Element)method.getExecutable(), Message.INHERITCONFIGURATION_CYCLE, Strings.join(initializingMethods, " -> "));
            return;
        }
        initializingMethods.add(method);
        MappingOptions mappingOptions = method.getMappingOptions();
        List<SourceMethod> applicableReversePrototypeMethods = method.getApplicableReversePrototypeMethods();
        MappingOptions inverseMappingOptions = this.getInverseMappingOptions(Collections.join(availableMethods, applicableReversePrototypeMethods), method, initializingMethods, mapperConfig);
        List<SourceMethod> applicablePrototypeMethods = method.getApplicablePrototypeMethods();
        MappingOptions forwardMappingOptions = this.getTemplateMappingOptions(Collections.join(availableMethods, applicablePrototypeMethods), method, initializingMethods, mapperConfig);
        if (forwardMappingOptions != null) {
            mappingOptions.applyInheritedOptions(forwardMappingOptions, false, method, this.messager, this.typeFactory, this.accessorNaming);
        }
        if (inverseMappingOptions != null) {
            mappingOptions.applyInheritedOptions(inverseMappingOptions, true, method, this.messager, this.typeFactory, this.accessorNaming);
        }
        if ((inheritanceStrategy = mapperConfig.getMappingInheritanceStrategy()).isAutoInherit()) {
            if (forwardMappingOptions == null && inheritanceStrategy.isApplyForward()) {
                if (applicablePrototypeMethods.size() == 1) {
                    mappingOptions.applyInheritedOptions(Collections.first(applicablePrototypeMethods).getMappingOptions(), false, method, this.messager, this.typeFactory, this.accessorNaming);
                } else if (applicablePrototypeMethods.size() > 1) {
                    this.messager.printMessage((Element)method.getExecutable(), Message.INHERITCONFIGURATION_MULTIPLE_PROTOTYPE_METHODS_MATCH, Strings.join(applicablePrototypeMethods, ", "));
                }
            }
            if (inverseMappingOptions == null && inheritanceStrategy.isApplyReverse()) {
                if (applicableReversePrototypeMethods.size() == 1) {
                    mappingOptions.applyInheritedOptions(Collections.first(applicableReversePrototypeMethods).getMappingOptions(), true, method, this.messager, this.typeFactory, this.accessorNaming);
                } else if (applicableReversePrototypeMethods.size() > 1) {
                    this.messager.printMessage((Element)method.getExecutable(), Message.INHERITINVERSECONFIGURATION_MULTIPLE_PROTOTYPE_METHODS_MATCH, Strings.join(applicableReversePrototypeMethods, ", "));
                }
            }
        }
        if (mappingOptions.getBeanMapping() != null && mappingOptions.getBeanMapping().isignoreByDefault()) {
            mappingOptions.applyIgnoreAll(mappingOptions, method, this.messager, this.typeFactory, this.accessorNaming);
        }
        mappingOptions.markAsFullyInitialized();
    }

    private void reportErrorIfNoImplementationTypeIsRegisteredForInterfaceReturnType(Method method) {
        if (method.getReturnType().getTypeMirror().getKind() != TypeKind.VOID && method.getReturnType().isInterface() && method.getReturnType().getImplementationType() == null) {
            this.messager.printMessage((Element)method.getExecutable(), Message.GENERAL_NO_IMPLEMENTATION, method.getReturnType());
        }
    }

    private MappingOptions getInverseMappingOptions(List<SourceMethod> rawMethods, SourceMethod method, List<SourceMethod> initializingMethods, MapperConfiguration mapperConfig) {
        SourceMethod resultMethod = null;
        InheritInverseConfigurationPrism reversePrism = InheritInverseConfigurationPrism.getInstanceOn(method.getExecutable());
        if (reversePrism != null) {
            ArrayList<SourceMethod> candidates = new ArrayList<SourceMethod>();
            for (SourceMethod oneMethod : rawMethods) {
                if (!method.reverses(oneMethod)) continue;
                candidates.add(oneMethod);
            }
            String name = reversePrism.name();
            if (candidates.size() == 1) {
                if (name.isEmpty()) {
                    resultMethod = (SourceMethod)candidates.get(0);
                } else if (((SourceMethod)candidates.get(0)).getName().equals(name)) {
                    resultMethod = (SourceMethod)candidates.get(0);
                } else {
                    this.reportErrorWhenNonMatchingName((SourceMethod)candidates.get(0), method, reversePrism);
                }
            } else if (candidates.size() > 1) {
                ArrayList<SourceMethod> nameFilteredcandidates = new ArrayList<SourceMethod>();
                for (SourceMethod candidate : candidates) {
                    if (!candidate.getName().equals(name)) continue;
                    nameFilteredcandidates.add(candidate);
                }
                if (nameFilteredcandidates.size() == 1) {
                    resultMethod = (SourceMethod)nameFilteredcandidates.get(0);
                } else if (nameFilteredcandidates.size() > 1) {
                    this.reportErrorWhenSeveralNamesMatch(nameFilteredcandidates, method, reversePrism);
                } else {
                    this.reportErrorWhenAmbigousReverseMapping(candidates, method, reversePrism);
                }
            }
        }
        return this.extractInitializedOptions(resultMethod, rawMethods, mapperConfig, initializingMethods);
    }

    private MappingOptions extractInitializedOptions(SourceMethod resultMethod, List<SourceMethod> rawMethods, MapperConfiguration mapperConfig, List<SourceMethod> initializingMethods) {
        if (resultMethod != null) {
            if (!resultMethod.getMappingOptions().isFullyInitialized()) {
                this.mergeInheritedOptions(resultMethod, mapperConfig, rawMethods, initializingMethods);
            }
            return resultMethod.getMappingOptions();
        }
        return null;
    }

    private MappingOptions getTemplateMappingOptions(List<SourceMethod> rawMethods, SourceMethod method, List<SourceMethod> initializingMethods, MapperConfiguration mapperConfig) {
        SourceMethod resultMethod = null;
        InheritConfigurationPrism forwardPrism = InheritConfigurationPrism.getInstanceOn(method.getExecutable());
        if (forwardPrism != null) {
            ArrayList<SourceMethod> candidates = new ArrayList<SourceMethod>();
            for (SourceMethod oneMethod : rawMethods) {
                if (!method.canInheritFrom(oneMethod) || oneMethod.equals(method)) continue;
                candidates.add(oneMethod);
            }
            String name = forwardPrism.name();
            if (candidates.size() == 1) {
                SourceMethod sourceMethod = (SourceMethod)Collections.first(candidates);
                if (name.isEmpty()) {
                    resultMethod = sourceMethod;
                } else if (sourceMethod.getName().equals(name)) {
                    resultMethod = sourceMethod;
                } else {
                    this.reportErrorWhenNonMatchingName(sourceMethod, method, forwardPrism);
                }
            } else if (candidates.size() > 1) {
                ArrayList<SourceMethod> nameFilteredcandidates = new ArrayList<SourceMethod>();
                for (SourceMethod candidate : candidates) {
                    if (!candidate.getName().equals(name)) continue;
                    nameFilteredcandidates.add(candidate);
                }
                if (nameFilteredcandidates.size() == 1) {
                    resultMethod = (SourceMethod)Collections.first(nameFilteredcandidates);
                } else if (nameFilteredcandidates.size() > 1) {
                    this.reportErrorWhenSeveralNamesMatch(nameFilteredcandidates, method, forwardPrism);
                } else {
                    this.reportErrorWhenAmbigousMapping(candidates, method, forwardPrism);
                }
            }
        }
        return this.extractInitializedOptions(resultMethod, rawMethods, mapperConfig, initializingMethods);
    }

    private void reportErrorWhenAmbigousReverseMapping(List<SourceMethod> candidates, SourceMethod method, InheritInverseConfigurationPrism reversePrism) {
        ArrayList<String> candidateNames = new ArrayList<String>();
        for (SourceMethod candidate : candidates) {
            candidateNames.add(candidate.getName());
        }
        String name = reversePrism.name();
        if (name.isEmpty()) {
            this.messager.printMessage((Element)method.getExecutable(), reversePrism.mirror, Message.INHERITINVERSECONFIGURATION_DUPLICATES, Strings.join(candidateNames, "(), "));
        } else {
            this.messager.printMessage((Element)method.getExecutable(), reversePrism.mirror, Message.INHERITINVERSECONFIGURATION_INVALID_NAME, Strings.join(candidateNames, "(), "), name);
        }
    }

    private void reportErrorWhenSeveralNamesMatch(List<SourceMethod> candidates, SourceMethod method, InheritInverseConfigurationPrism reversePrism) {
        this.messager.printMessage((Element)method.getExecutable(), reversePrism.mirror, Message.INHERITINVERSECONFIGURATION_DUPLICATE_MATCHES, reversePrism.name(), Strings.join(candidates, ", "));
    }

    private void reportErrorWhenNonMatchingName(SourceMethod onlyCandidate, SourceMethod method, InheritInverseConfigurationPrism reversePrism) {
        this.messager.printMessage((Element)method.getExecutable(), reversePrism.mirror, Message.INHERITINVERSECONFIGURATION_NO_NAME_MATCH, reversePrism.name(), onlyCandidate.getName());
    }

    private void reportErrorWhenAmbigousMapping(List<SourceMethod> candidates, SourceMethod method, InheritConfigurationPrism prism) {
        ArrayList<String> candidateNames = new ArrayList<String>();
        for (SourceMethod candidate : candidates) {
            candidateNames.add(candidate.getName());
        }
        String name = prism.name();
        if (name.isEmpty()) {
            this.messager.printMessage((Element)method.getExecutable(), prism.mirror, Message.INHERITCONFIGURATION_DUPLICATES, Strings.join(candidateNames, "(), "));
        } else {
            this.messager.printMessage((Element)method.getExecutable(), prism.mirror, Message.INHERITCONFIGURATION_INVALIDNAME, Strings.join(candidateNames, "(), "), name);
        }
    }

    private void reportErrorWhenSeveralNamesMatch(List<SourceMethod> candidates, SourceMethod method, InheritConfigurationPrism prism) {
        this.messager.printMessage((Element)method.getExecutable(), prism.mirror, Message.INHERITCONFIGURATION_DUPLICATE_MATCHES, prism.name(), Strings.join(candidates, ", "));
    }

    private void reportErrorWhenNonMatchingName(SourceMethod onlyCandidate, SourceMethod method, InheritConfigurationPrism prims) {
        this.messager.printMessage((Element)method.getExecutable(), prims.mirror, Message.INHERITCONFIGURATION_NO_NAME_MATCH, prims.name(), onlyCandidate.getName());
    }
}

